/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;

public class PartitionStoragePanel
extends BaseInfoPanel {
    private JLabel m_tblspaceLabel;
    private JComboBox m_tblspaceComboBox;
    private NonNullableComboBoxModel m_tblspaceModel;

    private void $init$() {
        this.m_tblspaceLabel = new JLabel();
        this.m_tblspaceComboBox = new JComboBox();
    }

    public PartitionStoragePanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        ResourceUtils.resLabel((JLabel)this.m_tblspaceLabel, (Component)this.m_tblspaceComboBox, (String)UIArb.getString(668));
        this.m_tblspaceComboBox.setName("CMB_TABLESPACE");
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add(this.m_tblspaceLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_tblspaceComboBox, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
    }

    protected void init(DBObjectProvider pro, TablePartition part, String[] tablespaces) {
        String tbls;
        OracleStorageProperties osp;
        if (this.m_tblspaceModel == null) {
            int len = tablespaces != null ? tablespaces.length : 0;
            Object[] tmp = new String[len + 1];
            tmp[0] = "<DEFAULT>";
            int i = 0;
            while (i < len) {
                tmp[i + 1] = pro.getExternalName(tablespaces[i]);
                ++i;
            }
            this.m_tblspaceModel = new NonNullableComboBoxModel(tmp);
            this.m_tblspaceComboBox.setModel(this.m_tblspaceModel);
            if (!(pro instanceof Database)) {
                this.m_tblspaceComboBox.setEditable(true);
            }
        }
        if ((osp = part.getSegmentAttributes()) != null && (tbls = osp.getTablespace()) != null) {
            this.m_tblspaceComboBox.setSelectedItem(pro.getExternalName(tbls));
        }
    }

    protected void commit(DBObjectProvider pro, TablePartition part, Table table) throws ValidationException {
        String tbls;
        OracleStorageProperties osp = part.getSegmentAttributes();
        if (osp == null) {
            osp = new OracleStorageProperties();
            part.setSegmentAttributes(osp);
        }
        osp.setTablespace("<DEFAULT>".equals(tbls = (String)this.m_tblspaceComboBox.getSelectedItem()) ? null : pro.getInternalName(tbls));
        pro.validateObjectProperty((DBObject)part, (Object)Property.segmentAttributes);
    }
}

