/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.PartitionDefinitionPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.dialogs.MessageDialog;

public class PartitioningPanel
extends BaseInfoPanel
implements ActionListener {
    private DBObjectRenderer m_rend;
    private FSM m_fsm;
    private OracleTablePartitions.PartitionType m_lastType;
    private OracleTablePartitions.PartitionType m_lastSubtype;
    private WizardCallbacks m_wizCallbacks;
    private JLabel m_typeLabel;
    private JComboBox m_typeComboBox;
    private DefaultListModel m_colsFromModel;
    private ListPicker m_colsFromPick;
    private DefaultListModel m_colsToModel;
    private ListPicker m_colsToPick;
    private Shuttle m_colsShuttle;
    private JLabel m_subtypeLabel;
    private JComboBox m_subtypeComboBox;
    private ListPicker m_subColsFromPick;
    private DefaultListModel m_subColsToModel;
    private ListPicker m_subColsToPick;
    private Shuttle m_subColsShuttle;
    private boolean m_anyRealColumns;
    private Table m_table;

    private void $init$() {
        this.m_rend = new DBObjectRenderer();
        this.m_typeLabel = new JLabel();
        this.m_typeComboBox = new JComboBox();
        this.m_colsFromModel = new DefaultListModel();
        this.m_colsFromPick = new ListPicker(new JList(this.m_colsFromModel));
        this.m_colsToModel = new DefaultListModel();
        this.m_colsToPick = new ReorderableListPicker(new JList(this.m_colsToModel));
        this.m_colsShuttle = new Shuttle();
        this.m_subtypeLabel = new JLabel();
        this.m_subtypeComboBox = new JComboBox();
        this.m_subColsFromPick = new ListPicker(new JList(this.m_colsFromModel));
        this.m_subColsToModel = new DefaultListModel();
        this.m_subColsToPick = new ReorderableListPicker(new JList(this.m_subColsToModel));
        this.m_subColsShuttle = new Shuttle();
        this.m_anyRealColumns = false;
        this.m_table = null;
    }

    public PartitioningPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_typeComboBox.setName("PartitioningPanel.CMB_TYPE");
        this.m_typeComboBox.addItem(UIArb.getString(232));
        OracleTablePartitions.PartitionType[] partitionTypeArray = OracleTablePartitions.PartitionType.values();
        int n = 0;
        while (n < partitionTypeArray.length) {
            OracleTablePartitions.PartitionType type = partitionTypeArray[n];
            this.m_typeComboBox.addItem(type);
            ++n;
        }
        this.m_typeComboBox.addActionListener(this);
        this.m_subtypeComboBox.setName("PartitioningPanel.CMB_SUBTYPE");
        this.m_subtypeComboBox.addItem(UIArb.getString(232));
        this.m_subtypeComboBox.addItem(OracleTablePartitions.PartitionType.LIST);
        this.m_subtypeComboBox.addItem(OracleTablePartitions.PartitionType.HASH);
        this.m_subtypeComboBox.addActionListener(this);
        this.m_colsFromPick.getList().setCellRenderer(this.m_rend);
        this.m_colsShuttle.setFromPicker((ItemPicker)this.m_colsFromPick);
        this.m_colsToPick.getList().setCellRenderer(this.m_rend);
        this.m_colsShuttle.setToPicker((ItemPicker)this.m_colsToPick);
        this.m_subColsFromPick.getList().setCellRenderer(this.m_rend);
        this.m_subColsShuttle.setFromPicker((ItemPicker)this.m_subColsFromPick);
        this.m_subColsToPick.getList().setCellRenderer(this.m_rend);
        this.m_subColsShuttle.setToPicker((ItemPicker)this.m_subColsToPick);
        ResourceUtils.resLabel((JLabel)this.m_typeLabel, (Component)this.m_typeComboBox, (String)UIArb.getString(453));
        ResourceUtils.resLabel((JLabel)this.m_subtypeLabel, (Component)this.m_subtypeComboBox, (String)UIArb.getString(461));
        int y = 0;
        this.add(this.m_typeLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_typeComboBox, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 20), 0, 0));
        this.add((Component)this.m_colsShuttle, new GridBagConstraints(0, ++y, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_subtypeLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_subtypeComboBox, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 20), 0, 0));
        this.add((Component)this.m_subColsShuttle, new GridBagConstraints(0, ++y, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider pro = (DBObjectProvider)dataContext.get("DBObjectProvider");
        Table tab = (Table)dataContext.get("NewObject");
        OracleTablePartitions otp = (OracleTablePartitions)tab.getProperty("OracleTablePartitions");
        String[] tablespaces = this.getTablespaces(dataContext, pro);
        boolean editing = dataContext.get("OriginalObject") != null;
        this.m_wizCallbacks = dataContext.getWizardCallbacks();
        this.m_anyRealColumns = false;
        Column[] columnArray = tab.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            Column col = columnArray[n];
            if (!(col instanceof ViewColumn)) {
                this.m_anyRealColumns = true;
                break;
            }
            if (!col.getName().equals("*")) {
                this.m_anyRealColumns = true;
                break;
            }
            ++n;
        }
        this.init(pro, tab, otp, tablespaces, editing);
        if (!((Boolean)dataContext.find("DBObjectIsEditable")).booleanValue()) {
            this.m_typeLabel.setEnabled(false);
            this.m_typeComboBox.setEnabled(false);
            this.enablePartitionShuttle(false);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        DBObjectProvider pro = (DBObjectProvider)dataContext.get("DBObjectProvider");
        Table tab = (Table)dataContext.get("NewObject");
        OracleTablePartitions otp = (OracleTablePartitions)tab.getProperty("OracleTablePartitions");
        this.commit(pro, tab, otp);
    }

    private void init(DBObjectProvider pro, Table tab, OracleTablePartitions otp, String[] tablespaces, boolean editing) {
        this.m_colsFromModel.removeAllElements();
        this.m_colsToModel.removeAllElements();
        this.m_subColsToModel.removeAllElements();
        this.m_table = tab;
        Column[] columnArray = tab.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            String name;
            Column c = columnArray[n];
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)c.getDataTypeUsage());
            }
            catch (DBException e) {
                // empty catch block
            }
            if (dataType == null) {
                if (!(c instanceof ViewColumn) || !c.getName().equals("*") && !c.getName().endsWith(".*")) {
                    this.m_colsFromModel.addElement(c);
                }
            } else if (!(dataType instanceof ComplexType || "BLOB".equalsIgnoreCase(name = dataType.getName()) || "CLOB".equalsIgnoreCase(name) || "NCLOB".equalsIgnoreCase(name))) {
                this.m_colsFromModel.addElement(c);
            }
            ++n;
        }
        if (otp != null) {
            this.m_typeComboBox.setSelectedItem(otp.getPartitionType());
            DBObjectID[] dBObjectIDArray = otp.getPartitionColumns();
            int n2 = 0;
            while (n2 < dBObjectIDArray.length) {
                DBObjectID colID = dBObjectIDArray[n2];
                Column[] columnArray2 = tab.getColumns();
                int n3 = 0;
                while (n3 < columnArray2.length) {
                    Column col = columnArray2[n3];
                    DBObjectID id = col.getID();
                    if (id != null && id.equals(colID, false)) {
                        this.m_colsFromModel.removeElement(col);
                        this.m_colsToModel.addElement(col);
                    }
                    ++n3;
                }
                ++n2;
            }
            OracleTablePartitions subiotp = otp.getSubpartitionModel();
            if (subiotp == null) {
                this.m_subtypeComboBox.setSelectedItem(UIArb.getString(232));
                this.enableSubpartitionShuttle(false);
            } else {
                this.m_subtypeComboBox.setSelectedItem(subiotp.getPartitionType());
                DBObjectID[] dBObjectIDArray2 = subiotp.getPartitionColumns();
                int n4 = 0;
                while (n4 < dBObjectIDArray2.length) {
                    DBObjectID colID = dBObjectIDArray2[n4];
                    Column[] columnArray3 = tab.getColumns();
                    int n5 = 0;
                    while (n5 < columnArray3.length) {
                        Column col = columnArray3[n5];
                        DBObjectID id = col.getID();
                        if (id != null && id.equals(colID, false)) {
                            this.m_colsFromModel.removeElement(col);
                            this.m_subColsToModel.addElement(col);
                        }
                        ++n5;
                    }
                    ++n4;
                }
            }
        }
        if (!((Boolean)tab.getProperty("PARTITIONED TABLE", (Object)Boolean.FALSE)).booleanValue()) {
            this.m_typeComboBox.setSelectedItem(UIArb.getString(232));
            this.enablePartitionShuttle(false);
            this.enableSubpartitionShuttle(false);
        }
        this.m_colsShuttle.updateUI();
        this.m_subColsShuttle.updateUI();
        if (editing && pro instanceof Database) {
            this.m_typeLabel.setEnabled(false);
            this.m_typeComboBox.setEnabled(false);
            this.enablePartitionShuttle(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commit(DBObjectProvider pro, Table tab, OracleTablePartitions otp) throws TraversalException {
        if (!this.m_typeComboBox.isEnabled()) return;
        boolean asked = false;
        OracleTablePartitions.PartitionType existingType = otp == null ? null : otp.getPartitionType();
        Object partType = this.m_typeComboBox.getSelectedItem();
        if (partType instanceof OracleTablePartitions.PartitionType) {
            if (existingType != null && existingType != partType) {
                if (!MessageDialog.confirm((Component)((Object)this), (Object)UIArb.getString(782), (String)UIArb.getString(76), null, (boolean)true)) throw new TraversalException(null);
                otp = null;
                asked = true;
                Index[] indexArray = tab.getIndexes();
                int n = 0;
                while (n < indexArray.length) {
                    OracleIndexPartitions.PartitionType pt;
                    Index idx = indexArray[n];
                    OracleIndexPartitions oip = (OracleIndexPartitions)idx.getProperty("OracleIndexPartitions");
                    if (oip != null && (pt = oip.getPartitionType()) != null && (pt.equals((Object)OracleIndexPartitions.PartitionType.LOCAL_COMP) || pt.equals((Object)OracleIndexPartitions.PartitionType.LOCAL_HASH) || pt.equals((Object)OracleIndexPartitions.PartitionType.LOCAL_OTHER))) {
                        idx.setProperty("OracleIndexPartitions", null);
                    }
                    ++n;
                }
            }
            if (otp == null) {
                otp = new OracleTablePartitions();
                otp.setObjectType(OracleTablePartitions.ObjectType.PARTITION);
                tab.setProperty("PARTITIONED TABLE", (Object)Boolean.TRUE);
                tab.setProperty("OracleTablePartitions", (Object)otp);
            }
            otp.setPartitionType((OracleTablePartitions.PartitionType)partType);
            Enumeration cols = this.m_colsToModel.elements();
            DBObjectID[] colIDs = new DBObjectID[this.m_colsToModel.size()];
            int i = 0;
            while (i < colIDs.length) {
                Column col = (Column)cols.nextElement();
                colIDs[i] = col.getID();
                if (colIDs[i] == null) {
                    colIDs[i] = TemporaryObjectID.createID((DBObject)col);
                    col.setID(colIDs[i]);
                }
                ++i;
            }
            otp.setPartitionColumns(colIDs);
            OracleTablePartitions subotp = otp.getSubpartitionModel();
            Object subtype = this.m_subtypeComboBox.getSelectedItem();
            if (this.m_subtypeComboBox.isEnabled() && subtype instanceof OracleTablePartitions.PartitionType) {
                if (subotp != null && subtype != subotp.getPartitionType()) {
                    if (!asked && !MessageDialog.confirm((Component)((Object)this), (Object)UIArb.getString(761), (String)UIArb.getString(841), null, (boolean)true)) throw new TraversalException(null);
                    subotp = null;
                    TablePartition[] parts = otp.getPartitions();
                    if (parts != null) {
                        int i2 = 0;
                        while (i2 < parts.length) {
                            parts[i2].setPartitionLevelSubpartitions(null);
                            ++i2;
                        }
                    }
                    Index[] indexArray = tab.getIndexes();
                    int n = 0;
                    while (n < indexArray.length) {
                        Index idx = indexArray[n];
                        OracleIndexPartitions oip = (OracleIndexPartitions)idx.getProperty("OracleIndexPartitions");
                        if (oip != null) {
                            IndexPartition[] indexPartitionArray = oip.getPartitions();
                            int n2 = 0;
                            while (n2 < indexPartitionArray.length) {
                                IndexPartition ip = indexPartitionArray[n2];
                                ip.setSubpartitions(null);
                                ++n2;
                            }
                        }
                        ++n;
                    }
                }
                if (subotp == null) {
                    subotp = new OracleTablePartitions();
                    subotp.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION);
                    otp.setSubpartitionModel(subotp);
                }
                subotp.setPartitionType((OracleTablePartitions.PartitionType)subtype);
                Enumeration subcols = this.m_subColsToModel.elements();
                DBObjectID[] subcolIDs = new DBObjectID[this.m_subColsToModel.size()];
                int i3 = 0;
                while (i3 < subcolIDs.length) {
                    Column col = (Column)subcols.nextElement();
                    subcolIDs[i3] = col.getID();
                    if (subcolIDs[i3] == null) {
                        subcolIDs[i3] = TemporaryObjectID.createID((DBObject)col);
                        col.setID(subcolIDs[i3]);
                    }
                    ++i3;
                }
                subotp.setPartitionColumns(subcolIDs);
            } else {
                subotp = null;
                otp.setSubpartitionModel(null);
            }
            try {
                pro.validateObjectProperty((DBObject)otp, (Object)Property.partitionColumns);
                if (subotp == null) return;
                pro.validateObjectProperty((DBObject)subotp, (Object)Property.partitionColumns);
                return;
            }
            catch (ValidationException e) {
                throw new TraversalException(e.getMessage(), e.getTitle());
            }
        } else {
            if (tab.getProperty("PARTITIONED TABLE") == Boolean.TRUE) {
                tab.setProperty("PARTITIONED TABLE", (Object)Boolean.FALSE);
            }
            tab.setProperty("OracleTablePartitions", null);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_typeComboBox) {
            Object type = this.m_typeComboBox.getSelectedItem();
            if (!this.m_anyRealColumns && type instanceof OracleTablePartitions.PartitionType) {
                MessageDialog.error((Component)((Object)this), (Object)UIArb.getString(312), (String)UIArb.format(638, this.m_table.getName()), null);
                this.m_typeComboBox.setSelectedItem(UIArb.getString(232));
                this.enablePartitionShuttle(false);
                this.enableSubpartitionShuttle(false);
            } else {
                this.enablePartitionShuttle(type instanceof OracleTablePartitions.PartitionType);
            }
        } else if (source == this.m_subtypeComboBox) {
            Object subtype = this.m_subtypeComboBox.getSelectedItem();
            this.enableSubpartitionShuttle(subtype instanceof OracleTablePartitions.PartitionType);
        }
        if (this.m_wizCallbacks != null) {
            this.m_wizCallbacks.wizardUpdateExpectedTransition(this.getExitTransition());
        }
    }

    private void enablePartitionShuttle(boolean boo) {
        this.m_colsFromPick.getList().setEnabled(boo);
        this.m_colsToPick.getList().setEnabled(boo);
        this.m_colsShuttle.setEnabled(boo);
        if (boo) {
            OracleTablePartitions.PartitionType type = (OracleTablePartitions.PartitionType)this.m_typeComboBox.getSelectedItem();
            boo = type == OracleTablePartitions.PartitionType.RANGE && this.m_table.getProperty("TableType") != Table.TableType.INDEX_ORGANIZED;
        }
        this.m_subtypeLabel.setEnabled(boo);
        this.m_subtypeComboBox.setEnabled(boo);
        this.enableSubpartitionShuttle(boo && this.m_subtypeComboBox.getSelectedItem() instanceof OracleTablePartitions.PartitionType);
    }

    private void enableSubpartitionShuttle(boolean boo) {
        this.m_subColsFromPick.getList().setEnabled(boo);
        this.m_subColsToPick.getList().setEnabled(boo);
        this.m_subColsShuttle.setEnabled(boo);
        if (!(this.m_subtypeComboBox.getSelectedItem() instanceof OracleTablePartitions.PartitionType) && this.m_subColsToModel.size() > 0) {
            Enumeration putBack = this.m_subColsToModel.elements();
            while (putBack.hasMoreElements()) {
                this.m_colsFromModel.addElement(putBack.nextElement());
            }
            this.m_subColsToModel.removeAllElements();
        }
    }

    public Object getExitTransition() {
        Object type = this.m_typeComboBox.getSelectedItem();
        if (type instanceof OracleTablePartitions.PartitionType) {
            Object subtype;
            Object object = subtype = !this.m_subtypeComboBox.isEnabled() ? null : this.m_subtypeComboBox.getSelectedItem();
            if (this.m_fsm != null && this.m_lastType == type && this.m_lastSubtype == subtype) {
                return this.m_fsm;
            }
            boolean subParts = subtype instanceof OracleTablePartitions.PartitionType;
            Step[] steps = new Step[subParts ? 2 : 1];
            int i = 0;
            if (subParts) {
                steps[i++] = new Step(UIArb.getString(13), PartitionDefinitionPanel.class, new Class[]{Boolean.TYPE}, new Object[]{true}, null);
            }
            steps[i++] = new Step(UIArb.getString(130), PartitionDefinitionPanel.class, null);
            this.m_lastType = (OracleTablePartitions.PartitionType)type;
            this.m_lastSubtype = subParts ? (OracleTablePartitions.PartitionType)subtype : null;
            this.m_fsm = FSMBuilder.newFSM((Step[])steps);
            return this.m_fsm;
        }
        return null;
    }
}

