/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.BaseConstraintPanel;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.db.verifiers.table.TableInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.util.ModelUtil;

public class SimpleCreateTablePanel
extends BaseInfoPanel {
    private GridBagLayout m_layoutGB;
    private SimpleTableModel m_columnModel;
    private JTable m_tblColumnList;
    private JButton m_btnAddColumn;
    private JButton m_btnRemoveColumn;
    private DBObjectProvider m_prov;
    private Table m_table;
    private TableInfoVerifier m_tableVerifier;
    private ColumnInfoVerifier m_columnVerifier;
    private ConstraintsInfoVerifier m_constraintVerifier;
    private Collection<DataType> m_typeArray;
    private DataType m_defType;
    private boolean m_initialized;
    private String m_columnBaseName;
    public static final String HELP_SIMPLE_TABLE = "f1_odbta_html";
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Long LONG_0;
    private static final String[] LOB_TYPE_NAMES;

    private void $init$() {
        this.m_layoutGB = new GridBagLayout();
        this.m_columnModel = new SimpleTableModel();
        this.m_tblColumnList = new JTable();
        this.m_btnAddColumn = new JButton();
        this.m_btnRemoveColumn = new JButton();
        this.m_tableVerifier = null;
        this.m_columnVerifier = null;
        this.m_constraintVerifier = null;
        this.m_typeArray = new TreeSet<DataType>(DBUtil.getNameComparator());
    }

    public SimpleCreateTablePanel() {
        this.$init$();
        this.m_initialized = false;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DBUIResourceHelper reshelp = new DBUIResourceHelper("SimpleCreateTablePanel");
        this.setLayout(this.m_layoutGB);
        reshelp.resButton(this.m_btnAddColumn, UIArb.getString(148), "Add");
        reshelp.resButton(this.m_btnRemoveColumn, UIArb.getString(278), "Remove");
        this.m_btnAddColumn.addActionListener(new 1());
        this.m_btnRemoveColumn.addActionListener(new 2());
        reshelp.setName(this.m_tblColumnList, "ColumnTable");
        this.m_tblColumnList.setModel(this.m_columnModel);
        TableColumn colType = this.m_tblColumnList.getColumnModel().getColumn(2);
        colType.setCellEditor(new DefaultCellEditor(new IntegerTextField(null)));
        TableColumnModel tableColumnModel = this.m_tblColumnList.getColumnModel();
        TableColumn col = tableColumnModel.getColumn(0);
        col.setMinWidth(110);
        col = tableColumnModel.getColumn(1);
        col.setMinWidth(110);
        col.setMaxWidth(150);
        col = tableColumnModel.getColumn(2);
        col.setMinWidth(50);
        col.setMaxWidth(60);
        col = tableColumnModel.getColumn(3);
        col.setMinWidth(60);
        col.setMaxWidth(60);
        col = tableColumnModel.getColumn(4);
        col.setMinWidth(70);
        col.setMaxWidth(70);
        JScrollPane scrollPane = new JScrollPane(this.m_tblColumnList);
        this.m_tblColumnList.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.m_tblColumnList.setSelectionMode(0);
        ColumnListCellRenderer renderer = new ColumnListCellRenderer();
        try {
            this.m_tblColumnList.setDefaultRenderer(Object.class, renderer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.add(scrollPane, new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_btnAddColumn, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.m_btnRemoveColumn, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
    }

    public void init(DBObjectProvider prov) {
        if (this.m_columnBaseName == null) {
            this.m_columnBaseName = prov.getDescriptor().getCasePolicy() == 1 ? "column" : "COLUMN";
        }
        this.m_typeArray.clear();
        if (this.m_columnVerifier != null) {
            DataType[] dataTypeArray = this.m_columnVerifier.getPreferredTypes();
            int n = 0;
            while (n < dataTypeArray.length) {
                DataType type = dataTypeArray[n];
                this.m_typeArray.add(type);
                ++n;
            }
            this.m_defType = this.m_columnVerifier.getDefaultType();
            this.m_initialized = true;
        }
    }

    private void initializeVerifier(Verifier v) {
        if (v != null) {
            v.initializeVerifier(this.m_prov, null, (SchemaObject)this.m_table);
        }
    }

    static {
        $assertionsDisabled = SimpleCreateTablePanel.class.desiredAssertionStatus() ^ true;
        LONG_0 = new Long(0L);
        LOB_TYPE_NAMES = new String[]{JdbcDatabase.ANSI_BLOB.getName(), JdbcDatabase.ANSI_CLOB.getName(), JdbcDatabase.ANSI_BINARY_LARGE_OBJECT.getName(), JdbcDatabase.ANSI_CHAR_LARGE_OBJECT.getName(), JdbcDatabase.ANSI_CHARACTER_LARGE_OBJECT.getName()};
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this.m_table = (Table)dataContext.find("NewObject");
        if (!$assertionsDisabled && dataContext.find("OriginalObject") != null) {
            throw new AssertionError((Object)"simple create panel shouldn't be shown in edit dialog.");
        }
        this.m_tableVerifier = (TableInfoVerifier)dataContext.find("SchemaObjectInfoVerifier");
        this.m_columnVerifier = (ColumnInfoVerifier)dataContext.find("ColumnInfoVerifier");
        this.m_constraintVerifier = (ConstraintsInfoVerifier)dataContext.find("ConstraintsInfoVerifier");
        this.initializeVerifier(this.m_tableVerifier);
        this.initializeVerifier(this.m_columnVerifier);
        this.initializeVerifier(this.m_constraintVerifier);
        this.setup();
        int row = this.m_tblColumnList.getSelectedRow();
        if (row < 0) {
            row = this.m_columnModel.size();
            this.m_tblColumnList.setRowSelectionInterval(row - 1, row - 1);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        TableCellEditor ed = this.m_tblColumnList.getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
        int size = this.m_columnModel.size();
        ArrayList<Column> cols = new ArrayList<Column>(size);
        ArrayList<Column> pkCols = new ArrayList<Column>();
        int i = 0;
        while (i < size) {
            String colName = (String)this.m_columnModel.getValueAt(i, 0);
            DataType dt = (DataType)this.m_columnModel.getValueAt(i, 1);
            String colSize = ((String)this.m_columnModel.getValueAt(i, 2)).trim();
            Boolean notNull = (Boolean)this.m_columnModel.getValueAt(i, 3);
            Boolean isPK = (Boolean)this.m_columnModel.getValueAt(i, 4);
            String name = this.m_prov.getInternalName(colName);
            Column col = this.m_table.getColumn(name);
            if (col == null) {
                col = new Column(name);
                col.setID(TemporaryObjectID.createID((DBObject)col));
                this.m_table.addColumn(col);
            }
            col.setNotNull(notNull.booleanValue());
            DataTypeUsage dtUsage = col.getDataTypeUsage();
            if (dtUsage == null || !dtUsage.getDataTypeID().equals(dt.getID())) {
                dtUsage = dt.createDefaultUsage();
            }
            try {
                if (this.hasDeclarableAttribute(dt, "size")) {
                    if (ModelUtil.hasLength((String)colSize)) {
                        dtUsage.putAttributeValue("size", (Object)DataTypeHelper.toLongOrError((Object)colSize));
                    } else {
                        dtUsage.deleteAttributeValue("size");
                    }
                } else if (this.hasDeclarableAttribute(dt, "precision")) {
                    if (ModelUtil.hasLength((String)colSize)) {
                        dtUsage.putAttributeValue("precision", (Object)DataTypeHelper.toLongOrError((Object)colSize));
                        if (this.hasDeclarableAttribute(dt, "scale") && dtUsage.getAttributeValue("scale") == null) {
                            dtUsage.putAttributeValue("scale", (Object)LONG_0);
                        }
                    } else {
                        dtUsage.deleteAttributeValue("precision");
                        dtUsage.deleteAttributeValue("scale");
                    }
                }
            }
            catch (NumberFormatException ne) {
                throw new TraversalException(DBArb.format((int)189, (Object)colSize, (Object)dt.getName()));
            }
            col.setDataTypeUsage(dtUsage);
            if (this.m_columnVerifier != null) {
                this.m_columnVerifier.verifyColumn(null, col);
            }
            cols.add(col);
            if (isPK.booleanValue()) {
                pkCols.add(col);
            }
            ++i;
        }
        this.m_table.setColumns(cols.toArray(new Column[cols.size()]));
        if (this.m_columnVerifier != null) {
            this.m_columnVerifier.verifyRelation();
        }
        if (pkCols.size() > 0) {
            Constraint[] constraints;
            Constraint[] cons = this.m_table.getConstraints();
            PKConstraint pk = null;
            boolean pkFound = false;
            int i2 = 0;
            while (i2 < cons.length) {
                if ("PKConstraint".equals(cons[i2].getConstraintType())) {
                    pk = (PKConstraint)cons[i2];
                    pkFound = true;
                }
                ++i2;
            }
            if (pk == null) {
                pk = new PKConstraint();
                pk.setRelation((Relation)this.m_table);
                String pkName = BaseConstraintPanel.findUniqueName((Relation)this.m_table, (Constraint)pk, new Constraint[0], this.m_prov);
                if (this.m_constraintVerifier != null) {
                    try {
                        this.m_constraintVerifier.verifyName(pkName);
                    }
                    catch (TraversalException ex) {
                        ex.printStackTrace();
                    }
                }
                pk.setName(pkName);
            }
            pk.setEnabled(true);
            pk.setID(TemporaryObjectID.createID((DBObject)pk));
            pk.setColumns(pkCols.toArray(new Column[pkCols.size()]));
            if (pkFound) {
                constraints = cons;
            } else {
                constraints = new Constraint[cons.length + 1];
                constraints[0] = pk;
                int j = 1;
                while (j <= cons.length) {
                    constraints[j] = cons[j - 1];
                    ++j;
                }
            }
            this.m_table.setConstraints(constraints);
        } else {
            Constraint pk = null;
            Constraint[] constraintArray = this.m_table.getConstraints();
            int n = 0;
            while (n < constraintArray.length) {
                Constraint constraint = constraintArray[n];
                if ("PKConstraint".equals(constraint.getConstraintType())) {
                    pk = constraint;
                    break;
                }
                ++n;
            }
            if (pk != null) {
                this.m_table.removeConstraint(pk);
            }
        }
    }

    private void setup() {
        if (!this.m_initialized) {
            this.init(this.m_prov);
        }
        this.m_columnModel = new SimpleTableModel();
        this.m_tblColumnList.setModel(this.m_columnModel);
        TableColumn colType = this.m_tblColumnList.getColumnModel().getColumn(1);
        colType.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(this.m_typeArray.toArray())));
        Column[] cols = this.m_table.getColumns();
        if (cols.length == 0 && this.m_columnModel.size() == 0) {
            this.m_columnModel.addDefaultRow(0);
            this.m_tblColumnList.setRowSelectionInterval(0, 0);
        } else {
            Constraint[] cons = this.m_table.getConstraints();
            PKConstraint pk = null;
            int i = 0;
            while (i < cons.length) {
                if ("PKConstraint".equals(cons[i].getConstraintType())) {
                    pk = (PKConstraint)cons[i];
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < cols.length) {
                String name = cols[i2].getName();
                DataTypeUsage dtusage = cols[i2].getDataTypeUsage();
                DataType dt = null;
                boolean primaryKey = false;
                boolean notNull = cols[i2].isNotNull();
                String size = "";
                try {
                    dt = DataTypeHelper.getDataType((DataTypeUsage)dtusage);
                }
                catch (DBException ex) {
                    // empty catch block
                }
                if (dt != null) {
                    if (this.hasDeclarableAttribute(dt, "size") && dtusage.getAttributeValue("size") != null) {
                        size = dtusage.getAttributeValue("size").toString();
                    } else if (this.hasDeclarableAttribute(dt, "precision") && dtusage.getAttributeValue("precision") != null) {
                        size = dtusage.getAttributeValue("precision").toString();
                    }
                }
                if (pk != null) {
                    Column[] pkCols = pk.getColumns();
                    int j = 0;
                    while (j < pkCols.length) {
                        if (pkCols[j].equals((Object)cols[i2])) {
                            primaryKey = true;
                            notNull = true;
                            break;
                        }
                        ++j;
                    }
                }
                this.m_columnModel.addRow(i2, name, dt, size, notNull, primaryKey);
                ++i2;
            }
        }
    }

    private boolean hasDeclarableAttribute(DataType dt, String attrName) {
        DataTypeAttribute attr = dt.getDataTypeAttribute(attrName);
        return attr != null && attr.isDeclarable();
    }

    private boolean isLOB(DataType dt) {
        String dtName = dt.getName();
        String[] stringArray = LOB_TYPE_NAMES;
        int n = 0;
        while (n < stringArray.length) {
            String lobTypeName = stringArray[n];
            if (lobTypeName.equals(dtName)) {
                return true;
            }
            ++n;
        }
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        DataType ansiEquivalent = dtr.getMappedAnsiType(dt);
        if (ansiEquivalent != null) {
            dtName = ansiEquivalent.getName();
            String[] stringArray2 = LOB_TYPE_NAMES;
            int n2 = 0;
            while (n2 < stringArray2.length) {
                String lobTypeName = stringArray2[n2];
                if (lobTypeName.equals(dtName)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private String getDefaultSize(DataType dt) {
        DataTypeAttribute dtSize = dt.getDataTypeAttribute("size");
        dtSize = dtSize != null ? dtSize : dt.getDataTypeAttribute("precision");
        String size = dtSize != null && dtSize.isMandatory() ? DataTypeHelper.toString((Object)dtSize.getDefaultValue()) : null;
        return size != null ? size : "";
    }

    static String ra$m_columnBaseName(SimpleCreateTablePanel simpleCreateTablePanel) {
        return simpleCreateTablePanel.m_columnBaseName;
    }

    static String maS$getUniqueName(String string, DefaultListModel defaultListModel) {
        return BaseInfoPanel.getUniqueName(string, defaultListModel);
    }

    static DataType ra$m_defType(SimpleCreateTablePanel simpleCreateTablePanel) {
        return simpleCreateTablePanel.m_defType;
    }

    static String mav$getDefaultSize(SimpleCreateTablePanel simpleCreateTablePanel, DataType dataType) {
        return simpleCreateTablePanel.getDefaultSize(dataType);
    }

    static boolean mav$isLOB(SimpleCreateTablePanel simpleCreateTablePanel, DataType dataType) {
        return simpleCreateTablePanel.isLOB(dataType);
    }

    static boolean mav$hasDeclarableAttribute(SimpleCreateTablePanel simpleCreateTablePanel, DataType dataType, String string) {
        return simpleCreateTablePanel.hasDeclarableAttribute(dataType, string);
    }

    static JTable ra$m_tblColumnList(SimpleCreateTablePanel simpleCreateTablePanel) {
        return simpleCreateTablePanel.m_tblColumnList;
    }

    static SimpleTableModel ra$m_columnModel(SimpleCreateTablePanel simpleCreateTablePanel) {
        return simpleCreateTablePanel.m_columnModel;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int row = SimpleCreateTablePanel.ra$m_tblColumnList(SimpleCreateTablePanel.this).getSelectedRow();
            row = row < 0 ? SimpleCreateTablePanel.ra$m_columnModel(SimpleCreateTablePanel.this).size() : ++row;
            SimpleCreateTablePanel.ra$m_columnModel(SimpleCreateTablePanel.this).addDefaultRow(row);
            SimpleCreateTablePanel.ra$m_tblColumnList(SimpleCreateTablePanel.this).setRowSelectionInterval(row, row);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int row = SimpleCreateTablePanel.ra$m_tblColumnList(SimpleCreateTablePanel.this).getSelectedRow();
            if (row >= 0) {
                SimpleCreateTablePanel.ra$m_columnModel(SimpleCreateTablePanel.this).deleteRow(SimpleCreateTablePanel.ra$m_tblColumnList(SimpleCreateTablePanel.this).getSelectedRow());
                if (row > 0) {
                    SimpleCreateTablePanel.ra$m_tblColumnList(SimpleCreateTablePanel.this).setRowSelectionInterval(row - 1, row - 1);
                } else if (SimpleCreateTablePanel.ra$m_columnModel(SimpleCreateTablePanel.this).size() > 0) {
                    SimpleCreateTablePanel.ra$m_tblColumnList(SimpleCreateTablePanel.this).setRowSelectionInterval(0, 0);
                }
            }
        }
    }

    private class SimpleTableModel
    extends AbstractTableModel {
        public String[] columnNames;
        private ArrayList _data;
        private DefaultListModel _mdlColumns;

        private void $init$() {
            this.columnNames = new String[]{UIArb.getString(84), UIArb.getString(49), UIArb.getString(240), UIArb.getString(844), UIArb.getString(93)};
            this._data = new ArrayList(1);
            this._mdlColumns = new DefaultListModel();
        }

        public SimpleTableModel() {
            this.$init$();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this._data.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            if (row >= this._data.size()) {
                return null;
            }
            ArrayList colList = (ArrayList)this._data.get(row);
            if (col >= colList.size()) {
                return null;
            }
            return colList.get(col);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            Boolean b;
            if (col == 2) {
                DataType dt = (DataType)this.getValueAt(row, 1);
                return SimpleCreateTablePanel.mav$hasDeclarableAttribute(SimpleCreateTablePanel.this, dt, "size") || SimpleCreateTablePanel.mav$hasDeclarableAttribute(SimpleCreateTablePanel.this, dt, "precision");
            }
            if (col == 4) {
                return SimpleCreateTablePanel.mav$isLOB(SimpleCreateTablePanel.this, (DataType)this.getValueAt(row, 1)) ^ true;
            }
            return col != 3 || (b = (Boolean)this.getValueAt(row, 4)) == false;
        }

        public void setValueAt(Object value, int row, int col) {
            if (row >= this._data.size()) {
                return;
            }
            ArrayList colList = (ArrayList)this._data.get(row);
            if (col >= colList.size()) {
                return;
            }
            if (col == 0) {
                this._mdlColumns.removeElement(colList.get(0));
                this._mdlColumns.addElement(value);
            }
            colList.set(col, value);
            if (col == 1) {
                DataType dt = (DataType)value;
                colList.set(2, SimpleCreateTablePanel.mav$getDefaultSize(SimpleCreateTablePanel.this, dt));
                this.fireTableCellUpdated(row, 2);
                if (SimpleCreateTablePanel.mav$isLOB(SimpleCreateTablePanel.this, dt)) {
                    colList.set(4, false);
                    this.fireTableCellUpdated(row, 4);
                }
            } else if (col == 4 && ((Boolean)value).booleanValue()) {
                colList.set(3, true);
                this.fireTableCellUpdated(row, 3);
            }
            this.fireTableCellUpdated(row, col);
        }

        public void addDefaultRow(int row) {
            ArrayList<Object> colList = new ArrayList<Object>(5);
            String name = SimpleCreateTablePanel.maS$getUniqueName(SimpleCreateTablePanel.ra$m_columnBaseName(SimpleCreateTablePanel.this), this._mdlColumns);
            this._mdlColumns.addElement(name);
            colList.add(name);
            colList.add(SimpleCreateTablePanel.ra$m_defType(SimpleCreateTablePanel.this));
            colList.add(SimpleCreateTablePanel.mav$getDefaultSize(SimpleCreateTablePanel.this, SimpleCreateTablePanel.ra$m_defType(SimpleCreateTablePanel.this)));
            colList.add(false);
            colList.add(false);
            this._data.add(row, colList);
            this.fireTableDataChanged();
        }

        public void addRow(int row, String name, DataType dt, String size, boolean notNull, boolean pk) {
            ArrayList<Object> colList = new ArrayList<Object>(5);
            this._mdlColumns.addElement(name);
            colList.add(name);
            colList.add(dt);
            colList.add(size);
            colList.add(notNull);
            colList.add(pk);
            this._data.add(row, colList);
            this.fireTableDataChanged();
        }

        public void deleteRow(int row) {
            ArrayList colList = (ArrayList)this._data.get(row);
            this._mdlColumns.removeElement(colList.get(0));
            this._data.remove(row);
            this.fireTableDataChanged();
        }

        public int size() {
            return this._data.size();
        }
    }

    private class ColumnListCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setName("SimpleCreateTablePanel.ColumnRow" + row + ":" + column);
            TableModel model = table.getModel();
            if (!table.isRowSelected(row)) {
                if (!model.isCellEditable(row, column)) {
                    cell.setBackground(Color.lightGray);
                } else {
                    cell.setBackground(Color.white);
                }
            }
            return cell;
        }
    }

    private class IntegerTextField
    extends JTextField {
        static final String badchars = "`~!@#$%^&*()_+-=\\|\"':;?/>.<, ";

        public void processKeyEvent(KeyEvent ev) {
            char c = ev.getKeyChar();
            if (Character.isLetter(c) && !ev.isAltDown() || badchars.indexOf(c) > -1) {
                ev.consume();
                return;
            }
            super.processKeyEvent(ev);
        }

        private IntegerTextField() {
        }

        IntegerTextField(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

