/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.JComboCardPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.StorageClausePanel;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public final class StorageInfoPanel
extends BaseInfoPanel
implements ActionListener {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_EMBED_IN_LOB_DESCRIPTOR = 1;
    public static final String DEFAULT_OPTION = "<DEFAULT>";
    public static final String[] LOGGING_OPTIONS = new String[]{"<DEFAULT>", "ON", "OFF"};
    private BorderLayout layMain;
    private JMultiLineLabel lblTop;
    private JCheckBox cbxSegAttrs;
    private JPanel pnlCenter;
    private GridBagLayout layCenter;
    private JLabel lblTablespace;
    private JComboBox cmbTablespace;
    private JLabel lblPctFree;
    private JLabel lblPctUsed;
    private JLabel lblIniTrans;
    private JLabel lblMaxTrans;
    private StorageNumberField fldPctFree;
    private StorageNumberField fldPctUsed;
    private StorageNumberField fldIniTrans;
    private StorageNumberField fldMaxTrans;
    private JLabel lblLogging;
    private JComboBox cmbLogging;
    private NonNullableComboBoxModel mdlLogging;
    private NonNullableComboBoxModel mdlTablespace;
    private StorageClausePanel _pnlSubLobStorage;
    private OracleStorageProperties _oProps;
    private boolean _isIOT;
    private DBObject m_contextObject;
    private boolean m_readonly;
    private boolean m_pctusedSupported;
    private StorageInfoFor m_storageInfoFor;
    private static OracleStorageProperties s_osp;
    private static Component s_comp;

    private void $init$() {
        this.layMain = new BorderLayout();
        this.lblTop = new JMultiLineLabel();
        this.cbxSegAttrs = new JCheckBox();
        this.pnlCenter = null;
        this.layCenter = new GridBagLayout();
        this.lblTablespace = new JLabel();
        this.cmbTablespace = new JComboBox();
        this.lblPctFree = new JLabel();
        this.lblPctUsed = new JLabel();
        this.lblIniTrans = new JLabel();
        this.lblMaxTrans = new JLabel();
        this.fldPctFree = new StorageNumberField();
        this.fldPctUsed = new StorageNumberField();
        this.fldIniTrans = new StorageNumberField();
        this.fldMaxTrans = new StorageNumberField();
        this.lblLogging = new JLabel();
        this.cmbLogging = new JComboBox();
        this.mdlLogging = new NonNullableComboBoxModel((Object[])LOGGING_OPTIONS);
        this._pnlSubLobStorage = new StorageClausePanel();
        this._oProps = null;
        this._isIOT = false;
        this.m_readonly = false;
        this.m_pctusedSupported = true;
    }

    private StorageInfoPanel(StorageInfoFor storageInfoFor) {
        this.$init$();
        this.m_storageInfoFor = storageInfoFor;
        JPanel panel = new JPanel();
        try {
            this.jbInit(panel, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JComboCardPanel cardPanel = new JComboCardPanel(new JLabel(), (JComponent)this.cbxSegAttrs);
        ResourceUtils.resButton((AbstractButton)this.cbxSegAttrs, (String)UIArb.getString(157));
        cardPanel.showSubPanel((JComponent)this.pnlCenter);
        this.add((Component)cardPanel, "North");
        this.cbxSegAttrs.addActionListener(this);
    }

    public StorageInfoPanel() {
        this(null);
    }

    private void jbInit(JPanel PnlCenter, int layoutOption) throws Exception {
        this.pnlCenter = PnlCenter;
        this.pnlCenter.setLayout(this.layCenter);
        this.setLayout(this.layMain);
        this.lblTop.setPreferredAspectRatio(0.0f);
        this.lblTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        ResourceUtils.resLabel((JLabel)this.lblTablespace, (Component)this.cmbTablespace, (String)UIArb.getString(668));
        ResourceUtils.resLabel((JLabel)this.lblPctFree, (Component)((Object)this.fldPctFree), (String)UIArb.getString(643));
        this.fldPctFree.setMaximumValue(99);
        this.fldPctFree.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblPctUsed, (Component)((Object)this.fldPctUsed), (String)UIArb.getString(862));
        this.fldPctUsed.setMaximumValue(99);
        this.fldPctUsed.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblIniTrans, (Component)((Object)this.fldIniTrans), (String)UIArb.getString(876));
        this.fldIniTrans.setMaximumValue(255);
        this.fldIniTrans.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblMaxTrans, (Component)((Object)this.fldMaxTrans), (String)UIArb.getString(741));
        this.fldMaxTrans.setMaximumValue(255);
        this.fldMaxTrans.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblLogging, (Component)this.cmbLogging, (String)UIArb.getString(367));
        this.cmbLogging.setModel(this.mdlLogging);
        this.add((Component)this.lblTop, "North");
        this.pnlCenter.add((Component)this.lblTablespace, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.cmbTablespace, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.lblPctFree, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldPctFree), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.lblPctUsed, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldPctUsed), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        if (this.m_storageInfoFor != StorageInfoFor.MATERIALIZED_VIEW_INDEX) {
            this.pnlCenter.add((Component)this.lblLogging, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.pnlCenter.add((Component)this.cmbLogging, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 0), 0, 0));
        }
        this.pnlCenter.add((Component)this.lblIniTrans, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldIniTrans), new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.lblMaxTrans, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldMaxTrans), new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.pnlCenter.add((Component)((Object)this._pnlSubLobStorage), new GridBagConstraints(0, 2, 6, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void setComponentNames(String baseName) {
        this._pnlSubLobStorage.setComponentNames(baseName);
        if (ModelUtil.hasLength((String)baseName)) {
            this.setName(baseName);
            baseName = baseName + '.';
        }
        this.cbxSegAttrs.setName(baseName + "CBX_SEG_ATTRS");
        this.cmbTablespace.setName(baseName + "CMB_TABLESPACE");
        this.cmbLogging.setName(baseName + "CMB_LOGGING");
        this.fldPctFree.setName(baseName + "FLD_PCT_FREE");
        this.fldPctUsed.setName(baseName + "FLD_PCT_USED");
        this.fldIniTrans.setName(baseName + "FLD_INI_TRANS");
        this.fldMaxTrans.setName(baseName + "FLD_MAX_TRANS");
    }

    private void init(DBObjectProvider prov, OracleStorageProperties oProps, DBObject contextObject, DBObject parentObject, StorageInfoVerifier verifier, String[] tablespaces, boolean pctusedSupported, boolean readonly) {
        super.init(prov, verifier);
        this.m_contextObject = contextObject;
        this.m_pctusedSupported = pctusedSupported;
        this.m_readonly = readonly;
        if (prov instanceof Database) {
            this.cbxSegAttrs.setSelected(true);
            this.cbxSegAttrs.setEnabled(false);
        } else {
            this.cbxSegAttrs.setSelected(oProps != null);
            this.cbxSegAttrs.setEnabled(true);
        }
        OracleStorageProperties oracleStorageProperties = this._oProps = oProps != null ? oProps : this._oProps;
        if (this.mdlTablespace == null) {
            int len = tablespaces != null ? tablespaces.length : 0;
            Object[] tmp = new String[len + 1];
            tmp[0] = DEFAULT_OPTION;
            int i = 0;
            while (i < len) {
                tmp[i + 1] = this.getExternalName(tablespaces[i]);
                ++i;
            }
            this.mdlTablespace = new NonNullableComboBoxModel(tmp);
            this.cmbTablespace.setModel(this.mdlTablespace);
        }
        if (this._oProps != null) {
            String val = this._oProps.getTablespace();
            val = val == null ? DEFAULT_OPTION : this.getExternalName(val);
            if (this.mdlTablespace.getIndexOf((Object)val) < 0) {
                this.mdlTablespace.addElement((Object)val);
            }
            this.cmbTablespace.setSelectedItem(val);
            this.fldPctFree.setNumber(this._oProps.getPercentFree());
            this.fldPctUsed.setNumber(this._oProps.getPercentUsed());
            this.fldIniTrans.setNumber(this._oProps.getInitrans());
            this.fldMaxTrans.setNumber(this._oProps.getMaxtrans());
            Boolean b = this._oProps.getLogging();
            int logIdx = b == null ? 0 : (b != false ? 1 : 2);
            this.cmbLogging.setSelectedIndex(logIdx);
            this._pnlSubLobStorage.init(prov, this._oProps, verifier);
        }
        this.enableAllComponents(verifier, true);
    }

    private boolean commit(OracleStorageProperties oProps) throws TraversalException {
        if (!this.cbxSegAttrs.isSelected()) {
            return false;
        }
        if (oProps == null) {
            oProps = new OracleStorageProperties();
        }
        this._oProps = oProps;
        String tblspc = (String)this.mdlTablespace.getSelectedItem();
        if (!ModelUtil.hasLength((String)tblspc) || DEFAULT_OPTION.equals(tblspc)) {
            tblspc = null;
        }
        if (ModelUtil.hasLength((String)tblspc)) {
            tblspc = this.getInternalName(tblspc);
        }
        Integer pctFree = (Integer)this.fldPctFree.getNumber();
        Integer pctUsed = (Integer)this.fldPctUsed.getNumber();
        Integer iniTrans = (Integer)this.fldIniTrans.getNumber();
        Integer maxTrans = (Integer)this.fldMaxTrans.getNumber();
        Boolean logging = null;
        switch (this.cmbLogging.getSelectedIndex()) {
            case 1: {
                logging = Boolean.TRUE;
                break;
            }
            case 2: {
                logging = Boolean.FALSE;
                break;
            }
        }
        oProps.setTablespace(tblspc);
        oProps.setPercentFree(pctFree);
        oProps.setPercentUsed(pctUsed);
        oProps.setInitrans(iniTrans);
        oProps.setMaxtrans(maxTrans);
        oProps.setLogging(logging);
        this._pnlSubLobStorage.commit(oProps);
        StorageInfoVerifier verifier = (StorageInfoVerifier)this.getVerifier();
        if (this.m_storageInfoFor == StorageInfoFor.TABLE_PARTITION) {
            try {
                this.getProvider().validateObject(this.m_contextObject);
            }
            catch (ValidationException e) {
                throw new TraversalException(e.getMessage());
            }
        } else if (this.m_storageInfoFor == StorageInfoFor.INDEX_PARTITION) {
            try {
                this.getProvider().validateObject(this.m_contextObject);
            }
            catch (ValidationException e) {
                throw new TraversalException(e.getMessage());
            }
        } else if (verifier != null) {
            verifier.verifyStorage(oProps);
        }
        return true;
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.cbxSegAttrs) {
            if (this.cbxSegAttrs.isSelected() && this.getVerifier() != null) {
                this.enableAllComponents((StorageInfoVerifier)this.getVerifier(), true);
            } else {
                this.enableAllComponents(this.cbxSegAttrs.isSelected(), true);
            }
        }
    }

    private void enableAllComponents(boolean boo, boolean incLabels) {
        boo = boo && this.cbxSegAttrs.isSelected() && !this.m_readonly;
        this.cmbLogging.setEnabled(boo);
        this.cmbTablespace.setEnabled(boo);
        this.cmbTablespace.setEditable(this.getProvider() != null && !(this.getProvider() instanceof Database));
        this.fldIniTrans.setEnabled(boo);
        this.fldMaxTrans.setEnabled(boo);
        this.fldPctFree.setEnabled(boo);
        this.fldPctUsed.setEnabled(boo && this.m_pctusedSupported);
        if (boo || incLabels) {
            this.lblIniTrans.setEnabled(boo);
            this.lblLogging.setEnabled(boo);
            this.lblMaxTrans.setEnabled(boo);
            this.lblPctFree.setEnabled(boo);
            this.lblPctUsed.setEnabled(boo && this.m_pctusedSupported);
            this.lblTablespace.setEnabled(boo);
        }
        this._pnlSubLobStorage.enableAllComponents(boo, incLabels);
    }

    private void enableAllComponents(StorageInfoVerifier siv, boolean incLabels) {
        if (this.m_readonly || !this.cbxSegAttrs.isSelected()) {
            this.enableAllComponents(false, incLabels);
        } else if (siv != null) {
            this.cmbTablespace.setEnabled(siv.canChangeTablespace());
            this.cmbTablespace.setEditable(siv.canEditTablespace());
            this.fldPctFree.setEnabled(siv.canChangePercentFree());
            this.fldPctUsed.setEnabled(this.m_pctusedSupported);
            this.fldIniTrans.setEnabled(siv.canChangeInitrans());
            this.fldMaxTrans.setEnabled(siv.canChangeMaxtrans());
            this.cmbLogging.setEnabled(siv.canChangeLogging());
            if (incLabels) {
                this.lblTablespace.setEnabled(siv.canChangeTablespace());
                this.lblPctFree.setEnabled(siv.canChangePercentFree());
                this.lblPctUsed.setEnabled(this.m_pctusedSupported);
                this.lblIniTrans.setEnabled(siv.canChangeInitrans());
                this.lblMaxTrans.setEnabled(siv.canChangeMaxtrans());
                this.lblLogging.setEnabled(siv.canChangeLogging());
            }
            this._pnlSubLobStorage.enableAllComponents(siv, incLabels);
        } else {
            this.enableAllComponents(true, incLabels);
        }
    }

    public static OracleStorageProperties edit(OracleStorageProperties osp, StorageInfoFor storageInfoFor, DBObjectProvider pro, DBObject contextObject, DBObject parentObject, StorageInfoVerifier verifier, String[] tablespaces, Component parentComp) {
        return StorageInfoPanel.edit(osp, storageInfoFor, pro, contextObject, parentObject, verifier, tablespaces, parentComp, false);
    }

    public static void view(OracleStorageProperties osp, StorageInfoFor storageInfoFor, DBObjectProvider pro, DBObject contextObject, DBObject parentObject, StorageInfoVerifier verifier, String[] tablespaces, Component parentComp) {
        StorageInfoPanel.edit(osp, storageInfoFor, pro, contextObject, parentObject, verifier, tablespaces, parentComp, true);
    }

    private static OracleStorageProperties edit(OracleStorageProperties osp, StorageInfoFor storageInfoFor, DBObjectProvider pro, DBObject contextObject, DBObject parentObject, StorageInfoVerifier verifier, String[] tablespaces, Component parentComp, boolean readonly) {
        String title;
        s_osp = osp;
        s_comp = parentComp;
        boolean pctusedSupported = true;
        StringBuffer abbotPrefix = new StringBuffer("StorageInfoPanel");
        if (storageInfoFor != null) {
            abbotPrefix = abbotPrefix.append(".").append(storageInfoFor.toString());
        }
        int buttonMask = 7;
        switch (2.$sm$oracle$ide$db$panels$table$StorageInfoPanel$StorageInfoFor[storageInfoFor.ordinal()]) {
            case 1: {
                title = UIArb.getString(785);
                if (contextObject.getProperty("TableType") != Table.TableType.INDEX_ORGANIZED) break;
                pctusedSupported = false;
                break;
            }
            case 2: {
                title = UIArb.getString(166);
                break;
            }
            case 3: {
                title = UIArb.getString(629);
                break;
            }
            case 4: {
                title = UIArb.getString(243);
                break;
            }
            case 5: {
                title = UIArb.getString(199);
                break;
            }
            case 6: {
                title = UIArb.getString(30);
                break;
            }
            case 7: {
                title = UIArb.getString(653);
                pctusedSupported = false;
                break;
            }
            case 8: {
                title = UIArb.getString(166);
                pctusedSupported = false;
                break;
            }
            default: {
                title = UIArb.getString(785);
            }
        }
        JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)parentComp), (String)title, (int)buttonMask);
        StorageInfoPanel panel = new StorageInfoPanel(storageInfoFor);
        panel.setPreferredSize(new Dimension(600, 220));
        panel.init(pro, osp, contextObject, parentObject, verifier, tablespaces, pctusedSupported, readonly);
        panel.setComponentNames(abbotPrefix.toString());
        StorageInfoPanel.nameButtons(abbotPrefix.toString(), (Container)dialog);
        panel.setHelpID("f1_odbtasegattr_html");
        dialog.setContent((Component)((Object)panel));
        dialog.setResizable(true);
        1 list = new 1(panel);
        dialog.addVetoableChangeListener((VetoableChangeListener)list);
        dialog.runDialog();
        return s_osp;
    }

    private static boolean nameButtons(String prefix, Container c) {
        if (c instanceof DialogButtonBar) {
            Component[] componentArray = c.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Component button = componentArray[n];
                String name = button.getName();
                button.setName(prefix + name);
                ++n;
            }
            return true;
        }
        if (c != null) {
            Component[] children;
            Component[] componentArray = children = c.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                boolean done;
                Component child = componentArray[n];
                if (child instanceof Container && (done = StorageInfoPanel.nameButtons(prefix, (Container)child))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    static OracleStorageProperties ra$s_osp() {
        return s_osp;
    }

    static void wa$s_osp(OracleStorageProperties oracleStorageProperties) {
        s_osp = oracleStorageProperties;
    }

    static boolean mav$commit(StorageInfoPanel storageInfoPanel, OracleStorageProperties oracleStorageProperties) {
        return storageInfoPanel.commit(oracleStorageProperties);
    }

    static Component ra$s_comp() {
        return s_comp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StorageInfoFor
    extends Enum<StorageInfoFor> {
        private static final /* synthetic */ StorageInfoFor[] $v;
        public static final /* enum */ StorageInfoFor TABLE;
        public static final /* enum */ StorageInfoFor TABLE_PARTITION;
        public static final /* enum */ StorageInfoFor IOT_OVERFLOW;
        public static final /* enum */ StorageInfoFor MATERIALIZED_VIEW;
        public static final /* enum */ StorageInfoFor MATERIALIZED_VIEW_INDEX;
        public static final /* enum */ StorageInfoFor MATERIALIZED_VIEW_LOG;
        public static final /* enum */ StorageInfoFor INDEX;
        public static final /* enum */ StorageInfoFor INDEX_PARTITION;

        public static StorageInfoFor valueOf(String string) {
            return Enum.valueOf(StorageInfoFor.class, string);
        }

        public static final StorageInfoFor[] values() {
            return (StorageInfoFor[])$v.clone();
        }

        static {
            StorageInfoFor[] storageInfoForArray = new StorageInfoFor[8];
            storageInfoForArray[7] = INDEX_PARTITION = new StorageInfoFor("INDEX_PARTITION", 7);
            storageInfoForArray[6] = INDEX = new StorageInfoFor("INDEX", 6);
            storageInfoForArray[5] = MATERIALIZED_VIEW_LOG = new StorageInfoFor("MATERIALIZED_VIEW_LOG", 5);
            storageInfoForArray[4] = MATERIALIZED_VIEW_INDEX = new StorageInfoFor("MATERIALIZED_VIEW_INDEX", 4);
            storageInfoForArray[3] = MATERIALIZED_VIEW = new StorageInfoFor("MATERIALIZED_VIEW", 3);
            storageInfoForArray[2] = IOT_OVERFLOW = new StorageInfoFor("IOT_OVERFLOW", 2);
            storageInfoForArray[1] = TABLE_PARTITION = new StorageInfoFor("TABLE_PARTITION", 1);
            storageInfoForArray[0] = TABLE = new StorageInfoFor("TABLE", 0);
            $v = storageInfoForArray;
        }

        private StorageInfoFor(String string2, int n2) {
        }
    }

    static class StorageNumberField
    extends NumberTextField {
        private int _maxValue;

        private void $init$() {
            this._maxValue = Integer.MAX_VALUE;
        }

        public StorageNumberField() {
            this.$init$();
            this.setDataType(Integer.class);
            this.setSigned(false);
        }

        protected boolean validateNumber(Number n) {
            return n == null || n.intValue() >= 0 && n.intValue() <= this._maxValue;
        }

        public int getMaximumValue() {
            return this._maxValue;
        }

        public void setMaximumValue(int max) {
            this._maxValue = max;
        }
    }

    static final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ StorageInfoPanel v$panel;

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                try {
                    if (StorageInfoPanel.ra$s_osp() == null) {
                        StorageInfoPanel.wa$s_osp(new OracleStorageProperties());
                    }
                    if (!StorageInfoPanel.mav$commit(this.v$panel, StorageInfoPanel.ra$s_osp())) {
                        StorageInfoPanel.wa$s_osp(null);
                    }
                }
                catch (TraversalException te) {
                    MessageDialog.error((Component)StorageInfoPanel.ra$s_comp(), (Object)te.getMessage(), null, null);
                    throw new PropertyVetoException(te.getMessage(), evt);
                }
            }
        }

        public 1(StorageInfoPanel storageInfoPanel) {
            this.v$panel = storageInfoPanel;
        }
    }

    static class 2 {
        static final /* synthetic */ int[] $sm$oracle$ide$db$panels$table$StorageInfoPanel$StorageInfoFor;

        static {
            int[] nArray = new int[StorageInfoFor.values().length];
            $sm$oracle$ide$db$panels$table$StorageInfoPanel$StorageInfoFor = nArray;
            try {
                nArray[StorageInfoFor.TABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.$sm$oracle$ide$db$panels$table$StorageInfoPanel$StorageInfoFor[StorageInfoFor.TABLE_PARTITION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.$sm$oracle$ide$db$panels$table$StorageInfoPanel$StorageInfoFor[StorageInfoFor.IOT_OVERFLOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.$sm$oracle$ide$db$panels$table$StorageInfoPanel$StorageInfoFor[StorageInfoFor.MATERIALIZED_VIEW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.$sm$oracle$ide$db$panels$table$StorageInfoPanel$StorageInfoFor[StorageInfoFor.MATERIALIZED_VIEW_INDEX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.$sm$oracle$ide$db$panels$table$StorageInfoPanel$StorageInfoFor[StorageInfoFor.MATERIALIZED_VIEW_LOG.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.$sm$oracle$ide$db$panels$table$StorageInfoPanel$StorageInfoFor[StorageInfoFor.INDEX.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.$sm$oracle$ide$db$panels$table$StorageInfoPanel$StorageInfoFor[StorageInfoFor.INDEX_PARTITION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

