/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.trigger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ListModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.trigger.BaseTriggerPanel;
import oracle.ide.db.panels.trigger.SchemaTriggerPanel;
import oracle.ide.db.verifiers.trigger.TriggerVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;

public class DBTriggerPanel
extends BaseTriggerPanel
implements ItemListener {
    private GridBagLayout _layMain;
    private JRadioButton _radBefore;
    private JRadioButton _radAfter;
    private ButtonGroup _grpTiming;
    private Shuttle _shtEvents;
    private JLabel _lblAvail;
    private JList _lstAvail;
    private ListPicker _pckAvail;
    private JLabel _lblSel;
    private JList _lstSel;
    private ListPicker _pckSel;
    private BaseTriggerPanel.ModelPair _mdlBefore;
    private BaseTriggerPanel.ModelPair _mdlAfter;
    private DBUIResourceHelper _resHelper;

    private void $init$() {
        this._layMain = new GridBagLayout();
        this._radBefore = new JRadioButton();
        this._radAfter = new JRadioButton();
        this._grpTiming = new ButtonGroup();
        this._shtEvents = new Shuttle();
        this._lblAvail = new JLabel();
        this._lstAvail = new JList();
        this._pckAvail = new ListPicker(this._lstAvail);
        this._lblSel = new JLabel();
        this._lstSel = new JList();
        this._pckSel = new ListPicker(this._lstSel);
        this._mdlBefore = SchemaTriggerPanel.createModel(Trigger.getEvents((Trigger.BaseType)Trigger.BaseType.DATABASE, (Trigger.Timing)Trigger.Timing.BEFORE));
        this._mdlAfter = SchemaTriggerPanel.createModel(Trigger.getEvents((Trigger.BaseType)Trigger.BaseType.DATABASE, (Trigger.Timing)Trigger.Timing.AFTER));
        this._resHelper = new DBUIResourceHelper("DBTriggerPanel");
    }

    public DBTriggerPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean getCurrentOKState() {
        return this._lstSel.getModel().getSize() > 0;
    }

    public void commit() throws TraversalException {
        Trigger.Timing timing = this._radBefore.isSelected() ? Trigger.Timing.BEFORE : Trigger.Timing.AFTER;
        ListModel model = this._lstSel.getModel();
        int count = model.getSize();
        String[] events = new String[count];
        int i = 0;
        while (i < count) {
            events[i] = (String)model.getElementAt(i);
            ++i;
        }
        Trigger trigger = this.getTrigger();
        trigger.setTiming(timing);
        trigger.setEvents(events);
        trigger.setStatementLevel(true);
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layMain);
        this._lstAvail.addFocusListener(this);
        this._lstSel.addFocusListener(this);
        this._resHelper.resButton(this._radBefore, UIArb.getString(874), "_radBefore");
        this._grpTiming.add(this._radBefore);
        this._radBefore.addItemListener(this);
        this._resHelper.resButton(this._radAfter, UIArb.getString(15), "_radAfter");
        this._grpTiming.add(this._radAfter);
        this._radBefore.setSelected(true);
        this._resHelper.resLabel(this._lblAvail, this._lstAvail, UIArb.getString(669), "_lstAvail");
        this._resHelper.resLabel(this._lblSel, this._lstSel, UIArb.getString(74), "_lstSel");
        this._shtEvents.setFromPicker((ItemPicker)this._pckAvail);
        this._shtEvents.setToPicker((ItemPicker)this._pckSel);
        this._pckAvail.setItemsSorted(true);
        this._pckSel.setItemsSorted(true);
        this._shtEvents.add((Component)this._lblAvail, (Object)"FromHeader");
        this._shtEvents.add((Component)this._lblSel, (Object)"ToHeader");
        this.add(this._radBefore, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._radAfter, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._shtEvents, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void itemStateChanged(ItemEvent e) {
        BaseTriggerPanel.ModelPair model = this._radBefore.isSelected() ? this._mdlBefore : this._mdlAfter;
        this._lstAvail.setModel(model.getAvailableModel());
        this._lstSel.setModel(model.getSelectedModel());
        this._pckAvail.setItemsSorted(false);
        this._pckAvail.setItemsSorted(true);
        this._pckSel.setItemsSorted(false);
        this._pckSel.setItemsSorted(true);
    }

    public void init(DBObjectProvider prov, Trigger trigger, Schema[] schemas, boolean canEditTrigger, boolean canChangeSchema, TriggerVerifier verifier) {
        super.init(prov, trigger, schemas, canEditTrigger, canChangeSchema, verifier);
        boolean before = trigger.getTiming() == null ? true : trigger.getTiming() == Trigger.Timing.BEFORE;
        this._radBefore.setSelected(before);
        this._radAfter.setSelected(before ^ true);
        this._mdlBefore = SchemaTriggerPanel.createModel(Trigger.getEvents((Trigger.BaseType)Trigger.BaseType.DATABASE, (Trigger.Timing)Trigger.Timing.BEFORE));
        this._mdlAfter = SchemaTriggerPanel.createModel(Trigger.getEvents((Trigger.BaseType)Trigger.BaseType.DATABASE, (Trigger.Timing)Trigger.Timing.AFTER));
        BaseTriggerPanel.ModelPair modelPair = this._radBefore.isSelected() ? this._mdlBefore : this._mdlAfter;
        DefaultListModel availableModel = (DefaultListModel)modelPair.getAvailableModel();
        DefaultListModel selectedModel = (DefaultListModel)modelPair.getSelectedModel();
        String[] stringArray = trigger.getEvents();
        int n = 0;
        while (n < stringArray.length) {
            String event = stringArray[n];
            int i = availableModel.getSize();
            while (i > 0) {
                if (event.equals((String)availableModel.getElementAt(i - 1))) {
                    availableModel.removeElementAt(i - 1);
                    selectedModel.addElement(event);
                    break;
                }
                --i;
            }
            ++n;
        }
        this.itemStateChanged(null);
        if (!canEditTrigger) {
            this._radBefore.setEnabled(false);
            this._radAfter.setEnabled(false);
            this._shtEvents.setEnabled(false);
            this._lblAvail.setEnabled(false);
            this._lstAvail.setEnabled(false);
            this._lblSel.setEnabled(false);
            this._lstSel.setEnabled(false);
        }
    }
}

