/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers;

import java.math.BigInteger;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.Sequence;
import oracle.javatools.util.ModelUtil;

public class SequenceInfoVerifier
extends AbstractSchemaObjectVerifier {
    public void verifySequence() throws TraversalException {
        this.verifySchemaObject();
    }

    protected String getErrorTitle() {
        return UIArb.format(39, this.getModifiedObject().getName());
    }

    protected String getInvalidNameMessage(String name) {
        return UIArb.format(ModelUtil.hasLength((String)name) ? 36 : 842, name);
    }

    public boolean canChangeIncrement() {
        return this.isEditable();
    }

    public boolean canChangeMinValue() {
        return this.isEditable();
    }

    public boolean canChangeMaxValue() {
        return this.isEditable();
    }

    public boolean canChangeCycle() {
        return this.isEditable();
    }

    public boolean canChangeOrder() {
        return this.isEditable();
    }

    public boolean canChangeCache() {
        return this.isEditable();
    }

    public boolean canChangeCacheSize() {
        return this.isEditable();
    }

    public boolean canEditStartWith() {
        return this.getOriginalObject() == null;
    }

    public void verifyMinValue() throws TraversalException {
        Sequence orig = (Sequence)this.getOriginalObject();
        if (orig != null) {
            Sequence seq = (Sequence)this.getModifiedObject();
            BigInteger minValue = seq.getMinValue();
            BigInteger omin = orig.getMinValue();
            if (omin == null && minValue != null || omin != null && minValue != null && minValue.compareTo(omin) > 0) {
                throw new TraversalException(DBArb.format((int)309, (Object)minValue.toString(), (Object)(omin == null ? "NOMINVALUE" : omin.toString())), UIArb.format(39, seq.getName()));
            }
        }
    }

    public void verifyMaxValue() throws TraversalException {
        Sequence orig = (Sequence)this.getOriginalObject();
        if (orig != null) {
            Sequence seq = (Sequence)this.getModifiedObject();
            BigInteger maxValue = seq.getMaxValue();
            BigInteger omax = orig.getMaxValue();
            if (omax == null && maxValue != null || omax != null && maxValue != null && maxValue.compareTo(omax) < 0) {
                throw new TraversalException(DBArb.format((int)133, (Object)maxValue.toString(), (Object)(omax == null ? "NOMAXVALUE" : omax.toString())), DBArb.format((int)39, (Object)seq.getName()));
            }
        }
    }
}

