/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers.index;

import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.util.ModelUtil;

public class AbstractTopLevelIndexVerifier
extends AbstractSchemaObjectVerifier
implements IndexInfoVerifier {
    public void verifyIndex(Index oldIndex, Index newIndex) throws TraversalException {
        try {
            this.getProvider().validateObject((DBObject)oldIndex, (DBObject)newIndex);
        }
        catch (ValidationException ve) {
            this.processValidationException(ve);
        }
    }

    public boolean canRenameIndex(Index index) {
        return ((Index)this.getModifiedObject()).getTable() == null;
    }

    public boolean canRemoveIndexes() {
        return false;
    }

    public boolean canRemoveIndex(Index index) {
        return false;
    }

    public boolean canReorderIndexes() {
        return false;
    }

    public boolean canMoveIndexUp(Index index) {
        return false;
    }

    public boolean canMoveIndexDown(Index index) {
        return false;
    }

    public boolean canAddIndexes() {
        return this.getOriginalTable() == null;
    }

    public boolean canAddIndex(Index index) {
        return this.getOriginalTable() == null;
    }

    public boolean canEditIndex(Index index) {
        return this.isEditable();
    }

    public boolean canAddIndexEntry(Index index) {
        int maxExpressions = 32;
        if (index.getIndexType() == Index.IndexType.BITMAP) {
            maxExpressions = 30;
        }
        return this.isEditable() && index.getColumnExpressions().length < maxExpressions;
    }

    public boolean canEditUniqueness(Index index) {
        return this.isEditable();
    }

    public boolean canEditDomain(Index index) {
        return this.isEditable();
    }

    public boolean canEditParallel(Index index) {
        Table table = index != null ? index.getTable() : null;
        return this.isEditable() && table != null && (table.getProperty("TableType") == Table.TableType.NORMAL || table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED);
    }

    public boolean canChangeName() {
        return true;
    }

    public boolean canChangeSchema() {
        return this.canEditIndex(null);
    }

    public boolean canCreateSchema() {
        return false;
    }

    public boolean canChangeComment() {
        return false;
    }

    public void verifyRelation() {
    }

    public void verifySchemaName(String name) throws TraversalException {
        if (!this.isValidName(name)) {
            throw new TraversalException(UIArb.format(355, name), UIArb.getString(309), null);
        }
    }

    public void verifyObject() throws TraversalException {
    }

    protected String getErrorTitle() {
        return UIArb.format(250, this.getModifiedRelationName());
    }

    protected String getInvalidNameMessage(String name) {
        return UIArb.format(ModelUtil.hasLength((String)name) ? 398 : 139, name);
    }

    protected String getChildType() {
        return "INDEX";
    }

    protected String getModifiedRelationName() {
        String result = "";
        SchemaObject dbo = this.getModifiedObject();
        if (dbo != null) {
            dbo = ((Index)dbo).getTable();
        }
        if (dbo != null) {
            result = dbo.getName();
        }
        return result;
    }

    protected Table getOriginalTable() {
        Table result = null;
        Index oi = (Index)this.getOriginalObject();
        if (oi != null) {
            result = oi.getTable();
        }
        return result;
    }

    protected Table getModifiedTable() {
        Index mi = (Index)this.getModifiedObject();
        return mi.getTable();
    }
}

