/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.relation.AbstractRelationVerifier;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractColumnInfoVerifier
extends AbstractRelationVerifier
implements ColumnInfoVerifier {
    private static HashSet noDefValDataTypes = new HashSet<String>(Arrays.asList("BLOB", "BFILE", "LONG RAW", "CLOB", "NCLOB"));
    private static final String[] ORA_TYPES = new String[]{"VARCHAR2", "NUMBER", "DATE", "CLOB", "BLOB"};
    private static final Object[] JDBC_TYPES = new Object[]{new String[]{JdbcDatabase.ANSI_VARCHAR.getName(), JdbcDatabase.ANSI_CHAR.getName(), JdbcDatabase.ANSI_CHARACTER.getName(), JdbcDatabase.ANSI_CHAR_VARYING.getName(), JdbcDatabase.ANSI_CHARACTER_VARYING.getName()}, new String[]{JdbcDatabase.ANSI_INTEGER.getName(), JdbcDatabase.ANSI_INT.getName()}, new String[]{JdbcDatabase.ANSI_DECIMAL.getName(), JdbcDatabase.ANSI_NUMERIC.getName(), JdbcDatabase.ANSI_DEC.getName()}, new String[]{JdbcDatabase.ANSI_TIMESTAMP.getName(), JdbcDatabase.ANSI_DATE.getName(), JdbcDatabase.ANSI_TIME.getName()}, new String[]{JdbcDatabase.ANSI_CLOB.getName(), JdbcDatabase.ANSI_CHARACTER_LARGE_OBJECT.getName(), JdbcDatabase.ANSI_CHAR_LARGE_OBJECT.getName()}, new String[]{JdbcDatabase.ANSI_BLOB.getName(), JdbcDatabase.ANSI_BINARY_LARGE_OBJECT.getName()}};

    protected AbstractColumnInfoVerifier() {
    }

    public boolean canAddColumns() {
        return this.isEditable() && this.getModifiedRelation().getColumns().length < 1000;
    }

    public boolean canAddColumn(Column col) {
        return this.isEditable();
    }

    public boolean canRemoveColumns() {
        return this.isEditable();
    }

    public boolean canRemoveColumn(Column col) {
        return this.isEditable() && DBUtil.getColumnUsages((DBObjectProvider)this.getProvider(), (Column)col).size() == 0;
    }

    public boolean canReorderColumns() {
        return this.isEditable();
    }

    public boolean canMoveColumnUp(Column col) {
        return this.isEditable();
    }

    public boolean canMoveColumnDown(Column col) {
        return this.isEditable();
    }

    public boolean canRenameColumn(Column col) {
        return this.isEditable();
    }

    public boolean canChangeColumnType(Column col) {
        return this.isEditable();
    }

    public boolean canChangeColumnSize(Column col) {
        return this.isEditable();
    }

    public boolean canChangeColumnNotNullState(Column col) {
        return this.isEditable();
    }

    public boolean canChangeColumnDefaultValue(Column col) {
        return this.isEditable();
    }

    public boolean canChangeColumnComment(Column col) {
        Table.TableType tableType;
        Relation relation;
        Relation relation2 = relation = col != null ? col.getRelation() : null;
        if (relation instanceof Table && Table.TableType.EXTERNAL.equals((Object)(tableType = (Table.TableType)relation.getProperty("TableType")))) {
            return false;
        }
        return this.isEditable();
    }

    public boolean canTakeDefaultValue(DataType datatype) {
        boolean result;
        boolean bl = result = datatype == null;
        if (!(result || datatype instanceof ComplexType || noDefValDataTypes.contains(datatype.getName()))) {
            result = true;
        }
        return result;
    }

    public void verifyColumn(Column oldCol, Column newCol) throws TraversalException {
        DBObjectProvider pro = this.getProvider();
        if (pro != null) {
            try {
                pro.validateObject((DBObject)oldCol, (DBObject)newCol);
            }
            catch (ValidationException ve) {
                this.processValidationException(ve);
            }
        }
    }

    protected String getErrorTitle() {
        return UIArb.getString(5);
    }

    protected String getInvalidNameMessage(String name) {
        return UIArb.format(ModelUtil.hasLength((String)name) ? 887 : 767, this.getModifiedRelation().getName(), name);
    }

    protected String getChildType() {
        return "COLUMN";
    }

    public DataType[] getPreferredTypes() {
        DBObjectProvider pro = this.getProvider();
        if (pro instanceof BaseOracleDatabase) {
            return this.getOraclePreferredTypes();
        }
        return pro != null ? this.getJdbcPreferredTypes(pro.getClass()) : null;
    }

    protected final DataType[] getOraclePreferredTypes() {
        ArrayList<DataType> retval = new ArrayList<DataType>();
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        int i = 0;
        while (i < ORA_TYPES.length) {
            DataType type = dtr.findDataType(ORA_TYPES[i], Oracle10gR2.class);
            if (type != null) {
                retval.add(type);
            }
            ++i;
        }
        return retval.toArray(new DataType[retval.size()]);
    }

    protected final DataType[] getJdbcPreferredTypes(Class providerClass) {
        ArrayList<DataType> retval = new ArrayList<DataType>();
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        int i = 0;
        while (i < JDBC_TYPES.length) {
            DataType type = null;
            String[] stringArray = (String[])JDBC_TYPES[i];
            int n = 0;
            while (n < stringArray.length) {
                String typeName = stringArray[n];
                type = dtr.findDataType(typeName, providerClass);
                if (type != null) {
                    retval.add(type);
                    break;
                }
                ++n;
            }
            if (type == null) {
                String[] stringArray2 = (String[])JDBC_TYPES[i];
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    String typeName = stringArray2[n2];
                    type = dtr.getMappedType(typeName, providerClass);
                    if (type != null) {
                        retval.add(type);
                        break;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return retval.toArray(new DataType[retval.size()]);
    }

    public DataType getDefaultType() {
        DBObjectProvider pro = this.getProvider();
        if (pro instanceof BaseOracleDatabase) {
            return pro.getDataType("VARCHAR2");
        }
        if (pro != null) {
            DataType def = pro.getDataType("VARCHAR");
            return def != null ? def : pro.getDataType("CHAR");
        }
        return null;
    }
}

