/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers.table;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.table.AbstractTableVerifier;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.util.ModelUtil;

public class AbstractIndexInfoVerifier
extends AbstractTableVerifier
implements IndexInfoVerifier {
    private ArrayList m_indexSet;

    private void $init$() {
        this.m_indexSet = null;
    }

    public AbstractIndexInfoVerifier() {
        this.$init$();
    }

    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject changed) {
        super.initializeVerifier(prov, orig, changed);
        Table table = (Table)changed;
        Index[] indexes = table.getIndexes();
        this.m_indexSet = new ArrayList<Index>(Arrays.asList(indexes));
    }

    protected String getErrorTitle() {
        return UIArb.format(250, this.getModifiedRelationName());
    }

    protected String getInvalidNameMessage(String name) {
        return UIArb.format(ModelUtil.hasLength((String)name) ? 398 : 139, name);
    }

    protected String getChildType() {
        return "INDEX";
    }

    public void verifyIndex(Index oldIndex, Index newIndex) throws TraversalException {
        try {
            this.getProvider().validateObject((DBObject)oldIndex, (DBObject)newIndex);
        }
        catch (ValidationException ve) {
            this.processValidationException(ve);
        }
    }

    public boolean canRenameIndex(Index index) {
        return this.getOriginalIndex(index) == null;
    }

    public boolean canRemoveIndexes() {
        return this.isEditable();
    }

    public boolean canRemoveIndex(Index index) {
        return this.isEditable();
    }

    public boolean canReorderIndexes() {
        return this.getOriginalRelation() == null;
    }

    public boolean canMoveIndexUp(Index index) {
        return this.getOriginalRelation() == null;
    }

    public boolean canMoveIndexDown(Index index) {
        return this.getOriginalRelation() == null;
    }

    public boolean canAddIndexes() {
        return this.getOriginalRelation() == null;
    }

    public boolean canAddIndex(Index index) {
        return this.getOriginalIndex(index) == null;
    }

    public boolean canEditIndex(Index index) {
        return true;
    }

    public boolean canAddIndexEntry(Index index) {
        int maxExpressions = 32;
        if (index.getIndexType() == Index.IndexType.BITMAP) {
            maxExpressions = 30;
        }
        return index.getColumnExpressions().length < maxExpressions;
    }

    protected Index getOriginalIndex(Index index) {
        Index result = null;
        Table original = (Table)this.getOriginalRelation();
        if (index != null && original != null) {
            result = original.getIndex(index.getName());
        }
        return result;
    }

    protected boolean hasNewIndex() {
        boolean result = true;
        if (this.getOriginalRelation() != null) {
            result = false;
            Index[] changeIndexes = ((Table)this.getModifiedRelation()).getIndexes();
            int i = 0;
            while (i < changeIndexes.length) {
                if (this.getOriginalIndex(changeIndexes[i]) == null) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    protected String getModifiedRelationName() {
        String result = "";
        SchemaObject dbo = this.getModifiedObject();
        if (dbo instanceof Index) {
            dbo = ((Index)dbo).getTable();
        }
        if (dbo != null) {
            result = dbo.getName();
        }
        return result;
    }

    public boolean canChangeName() {
        return true;
    }

    public boolean canChangeSchema() {
        return this.isEditable();
    }

    public boolean canCreateSchema() {
        return false;
    }

    public boolean canChangeComment() {
        return false;
    }

    public boolean canEditUniqueness(Index index) {
        return this.isEditable();
    }

    public boolean canEditDomain(Index index) {
        Table table = index != null ? index.getTable() : null;
        Table.TableType type = table != null ? (Table.TableType)table.getProperty("TableType") : null;
        return this.isEditable() && (type == null || type != Table.TableType.SESSION_TEMP && type != Table.TableType.TRANSACTION_TEMP);
    }

    public boolean canEditParallel(Index index) {
        return true;
    }

    public void verifySchemaName(String name) throws TraversalException {
        if (!this.isValidName(name)) {
            throw new TraversalException(UIArb.format(355, name), UIArb.getString(309), null);
        }
    }

    public void verifyObject() throws TraversalException {
    }

    protected boolean isNewIndex(Index index) {
        return this.m_indexSet.contains(index) ^ true;
    }
}

