/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Component;
import java.awt.Frame;
import java.sql.SQLException;
import javax.swing.SwingUtilities;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.StatementWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressBarExecutionWrapper
extends StatementWrapper.ExecutionProxy {
    public <T> T execute(StatementWrapper.ExecutionRunnable<T> r) throws DBException {
        if (SwingUtilities.isEventDispatchThread()) {
            Frame parent = IdeUtil.getMainWindow();
            ProgressBar pb = new ProgressBar((Component)parent, UIArb.format(682, r.getName()), null, true);
            R run = new R((Runnable)r, pb);
            pb.setRunnable((Runnable)run);
            pb.start("", "", 1500);
            if (pb.hasUserCancelled()) {
                try {
                    r.cancel();
                }
                catch (SQLException sqe) {
                    SQLErrorDialog.showErrorDialog(parent, UIArb.getString(335), sqe);
                }
                throw new CancelledException();
            }
        } else {
            r.run();
        }
        return (T)r.getResult();
    }

    private class R
    implements Runnable {
        private Runnable m_r;
        private ProgressBar m_pb;

        R(Runnable r, ProgressBar pb) {
            this.m_r = r;
            this.m_pb = pb;
        }

        public void run() {
            try {
                this.m_r.run();
            }
            finally {
                this.m_pb.setDoneStatus();
            }
        }
    }
}

