/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers;

import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.db.verifiers.trigger.TriggerVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Trigger;
import oracle.javatools.util.ModelUtil;

public class CreateTriggerVerifier
extends AbstractSchemaObjectVerifier
implements TriggerVerifier,
SchemaObjectInfoVerifier {
    private DBObjectProvider _prov;
    private Trigger _trigger;
    private boolean canChangeSchema;

    public void verifyTrigger(boolean replace) throws TraversalException {
        String[] events;
        Schema owner = this._trigger.getSchema();
        if (owner == null) {
            throw new TraversalException(UIArb.getString(122), UIArb.getString(492), null);
        }
        Schema tableOwner = this._trigger.getTableOwner();
        switch (1.$sm$oracle$javatools$db$Trigger$BaseType[this._trigger.getBaseType().ordinal()]) {
            case 1: 
            case 2: {
                if (tableOwner == null) {
                    throw new TraversalException(UIArb.getString(295), UIArb.getString(492), null);
                }
                String tableName = DBUtil.getDBObjectName((DBObjectID)this._trigger.getTableID());
                if (ModelUtil.hasLength((String)tableName)) break;
                throw new TraversalException(UIArb.getString(149), UIArb.getString(492), null);
            }
            case 3: {
                if (tableOwner != null) break;
                throw new TraversalException(UIArb.getString(875), UIArb.getString(492), null);
            }
        }
        if ((events = this._trigger.getEvents()).length == 0) {
            throw new TraversalException(UIArb.getString(882), UIArb.getString(492), null);
        }
    }

    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject change) {
        super.initializeVerifier(prov, orig, change);
        this._prov = prov;
        this._trigger = (Trigger)change;
        Schema schema = this._trigger.getSchema();
        Schema otherSchema = null;
        try {
            Schema[] schemaArray = prov.listSchemas();
            int n = 0;
            while (n < schemaArray.length) {
                Schema s = schemaArray[n];
                if (ModelUtil.areDifferent((Object)s, (Object)schema)) {
                    otherSchema = s;
                    break;
                }
                ++n;
            }
        }
        catch (DBException ex) {
            // empty catch block
        }
        this.canChangeSchema = otherSchema != null ? prov.hasPriviledge("TRIGGER", otherSchema, "CREATE") : false;
    }

    public void verifyName(String name) throws TraversalException {
        if (!this._prov.isValidName("TRIGGER", name)) {
            throw new TraversalException(UIArb.format(728, name), UIArb.getString(492), null);
        }
    }

    public boolean canChangeName() {
        return true;
    }

    public boolean canChangeSchema() {
        return this.canChangeSchema;
    }

    public boolean canCreateSchema() {
        if (this.getProvider() instanceof Database) {
            return super.canCreateSchema();
        }
        return true;
    }

    public void verifySchemaName(String name) throws TraversalException {
    }

    public void verifyObject() throws TraversalException {
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$Trigger$BaseType;

        static {
            int[] nArray = new int[Trigger.BaseType.values().length];
            $sm$oracle$javatools$db$Trigger$BaseType = nArray;
            try {
                nArray[Trigger.BaseType.TABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.VIEW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.SCHEMA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.DATABASE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

