/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEditorPanel<T extends DBObject>
extends DefaultTraversablePanel {
    private TraversableContext m_context;
    private DBUIHelper m_helper;

    protected BaseEditorPanel() {
        this(null);
    }

    protected BaseEditorPanel(String panelName) {
        if (panelName == null) {
            panelName = this.getClass().getSimpleName();
        }
        this.m_helper = new DBUIHelper(panelName, (Component)((Object)this));
    }

    protected TraversableContext getTraversableContext() {
        return this.m_context;
    }

    protected DBObjectProvider getProvider() {
        return (DBObjectProvider)this.m_context.find("DBObjectProvider");
    }

    protected DBUIHelper getHelper() {
        return this.m_helper;
    }

    protected T getOriginalObject() {
        return this.findOriginalObject(this.m_context);
    }

    protected T getDBObject() {
        return this.findDBObject(this.m_context);
    }

    protected Schema[] getSchemaList() {
        return (Schema[])this.m_context.find("SchemaList");
    }

    public final void onEntry(TraversableContext context) {
        this.m_context = context;
        this.m_helper.setProvider(this.getProvider());
        this.m_helper.setEditable((Boolean)context.get("DBObjectIsEditable"));
        this.m_helper.processComponents((DBObject)this.getOriginalObject(), (DBObject)this.getDBObject());
        this.initialisePanel();
    }

    protected abstract void initialisePanel();

    public final void onExit(TraversableContext dataContext) throws TraversalException {
        this.commitPanel();
        this.validateObject();
        this.m_helper.canCommit((DBObject)this.getOriginalObject(), (DBObject)this.getDBObject(), this.getTraversableContext());
    }

    protected abstract void commitPanel();

    protected void validateObject() throws TraversalException {
        try {
            this.getProvider().validateObject(this.getOriginalObject(), this.getDBObject());
        }
        catch (ValidationException ve) {
            this.processValidationException(ve);
        }
    }

    protected void processValidationException(ValidationException ve) throws TraversalException {
        String title = ve.getTitle();
        throw new TraversalException(ve.getMessage(), title == null ? this.getErrorTitle() : title);
    }

    protected T findOriginalObject(TraversableContext context) {
        return (T)((DBObject)context.find("OriginalObject"));
    }

    protected T findDBObject(TraversableContext context) {
        return (T)((DBObject)context.find("NewObject"));
    }

    protected final String getInternalName(String name) throws TraversalException {
        DBObjectProvider pro = this.getProvider();
        T obj = this.getDBObject();
        String type = obj.getType();
        try {
            pro.validateName(type, name);
        }
        catch (InvalidNameException ine) {
            String reason = ine.getMessage();
            throw new TraversalException(this.getInvalidNameMessage(name, type) + " " + reason, this.getErrorTitle());
        }
        return pro.getInternalName(name);
    }

    protected String getErrorTitle() {
        T obj = this.getDBObject();
        String type = DBTypeDisplayRegistry.getSingularDisplayName(obj.getType());
        return UIArb.format(426, type, obj.getName());
    }

    protected String getInvalidNameMessage(String name, String objtype) {
        String type = DBTypeDisplayRegistry.getSingularDisplayName(objtype);
        if (ModelUtil.hasLength((String)name)) {
            return UIArb.format(564, name, type);
        }
        return UIArb.format(254, type);
    }

    protected final String getExternalName(String name) {
        return this.getProvider().getExternalName(name);
    }

    protected String getUniqueName(String base, DefaultListModel model) {
        int size = model.size();
        HashSet<String> modelNames = new HashSet<String>();
        int i = 0;
        while (i < size) {
            Object element = model.getElementAt(i);
            modelNames.add(element.toString());
            ++i;
        }
        int i2 = 0;
        String name = null;
        while (modelNames.contains(name = base + ++i2)) {
        }
        return name;
    }
}

