/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.audit.boot;

import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeStarter;
import oracle.ide.Version;
import oracle.javatools.util.CommandException;
import oracle.javatools.util.CommandModel;
import oracle.javatools.util.CommandParser;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;

public class AuditStarter
extends IdeStarter {
    private CommandModel commandLine;
    protected static final Log LOG = new Log("main");
    protected static final FormatBundle bundle = new FormatBundle(AuditStarter.class);

    public CommandModel getCommand() {
        return this.commandLine;
    }

    private CommandParser createParser() {
        CommandParser parser = new CommandParser();
        parser.defineParameter("files", URL[].class);
        parser.defineOption("classpath", String.class);
        parser.defineOption("construct", String[].class);
        parser.defineOption("disable", String[].class);
        parser.defineOption("enable", String[].class);
        parser.defineOption("encoding", String.class);
        parser.defineOption("fail", FailSeverity.class);
        parser.defineOption("fix");
        parser.defineOption("help");
        parser.defineOption("name", String[].class);
        parser.defineOption("output", URL.class);
        parser.defineOption("profile", String.class);
        parser.defineOption("profilehelp");
        parser.defineOption("project", URL.class);
        parser.defineOption("quiet");
        parser.defineOption("sourcepath", String.class);
        parser.defineOption("style", String.class);
        parser.defineOption("stylehelp");
        parser.defineOption("title", String.class);
        parser.defineOption("untitled");
        parser.defineOption("verbose");
        parser.defineOption("version");
        parser.defineOption("workspace", URL.class);
        parser.defineOption("enableFileTypeAssociation");
        parser.defineOption("fileTypeKeyDefined");
        parser.defineRequirement(new String[]{"files", "help", "profilehelp", "stylehelp", "version"});
        parser.defineRequirementPresent("files", "profile");
        parser.defineRequirementPresent("disable", "profile");
        parser.defineRequirementPresent("enable", "profile");
        parser.defineRequirementAbsent("project", "classpath");
        parser.defineRequirementAbsent("project", "sourcepath");
        parser.defineRequirementAbsent("classpath", "project");
        parser.defineRequirementAbsent("sourcepath", "project");
        parser.defineRequirementAbsent("workspace", "classpath");
        parser.defineRequirementAbsent("workspace", "sourcepath");
        parser.defineRequirementAbsent("classpath", "workspace");
        parser.defineRequirementAbsent("sourcepath", "workspace");
        parser.defineSuperseding(new String[]{"title", "untitled"});
        parser.defineSynonym("construct", "c");
        parser.defineSynonym("fix", "f");
        parser.defineSynonym("help", "h");
        parser.defineSynonym("name", "n");
        parser.defineSynonym("output", "o");
        parser.defineSynonym("profile", "p");
        parser.defineSynonym("quiet", "q");
        parser.defineSynonym("style", "s");
        parser.defineSynonym("verbose", "v");
        parser.defineSynonym("workspace", "w");
        return parser;
    }

    public void startIde(String command, String[] arguments, IdeCore core) {
        IdeArgs ideArgs = core.getIdeArgs();
        ideArgs.setCreateUI(false);
        LOG.trace("creating main with command line {0}", (Object[])arguments);
        if (arguments.length == 0) {
            this.printUsage();
            System.exit(1);
        }
        CommandParser parser = this.createParser();
        try {
            this.commandLine = parser.parse(arguments);
        }
        catch (CommandException e) {
            this.printError(e.getMessage());
            System.err.println();
            System.exit(1);
        }
        if (this.commandLine.isPresent("help")) {
            this.printUsage();
            System.exit(0);
        } else if (this.commandLine.isPresent("version")) {
            this.printCopyright();
            System.exit(0);
        }
        if (this.commandLine.isAbsent("quiet")) {
            this.printCopyright();
        }
        try {
            Ide.startup((IdeCore)core);
        }
        catch (Throwable e) {
            this.printError(e.getMessage());
            e.printStackTrace(System.err);
            System.err.println();
            System.exit(1);
        }
    }

    private void printCopyright() {
        System.out.println(bundle.get("audit.copyright.message", new Object[]{Version.NAME_SHORT, Version.VER, Version.BUILD_NUM}));
        System.out.println();
    }

    private void printUsage() {
        this.printCopyright();
        System.out.println(bundle.get("audit.usage.message"));
        System.out.println();
    }

    private void printError(String message) {
        System.err.println("ojaudit: " + message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FailSeverity
    extends Enum<FailSeverity> {
        private static final /* synthetic */ FailSeverity[] $v;
        public static final /* enum */ FailSeverity ADVISORY;
        public static final /* enum */ FailSeverity INCOMPLETE;
        public static final /* enum */ FailSeverity WARNING;
        public static final /* enum */ FailSeverity ERROR;

        public static FailSeverity valueOf(String string) {
            return Enum.valueOf(FailSeverity.class, string);
        }

        public static final FailSeverity[] values() {
            return (FailSeverity[])$v.clone();
        }

        static {
            FailSeverity[] failSeverityArray = new FailSeverity[4];
            failSeverityArray[3] = ERROR = new FailSeverity("ERROR", 3);
            failSeverityArray[2] = WARNING = new FailSeverity("WARNING", 2);
            failSeverityArray[1] = INCOMPLETE = new FailSeverity("INCOMPLETE", 1);
            failSeverityArray[0] = ADVISORY = new FailSeverity("ADVISORY", 0);
            $v = failSeverityArray;
        }

        private FailSeverity(String string2, int n2) {
        }
    }
}

