/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Function;
import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Functions {
    public static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object o) {
            return o.toString();
        }
    };
    private static final Function<Object, Object> IDENTITY = new IdentityFunction();

    private Functions() {
    }

    public static <E> Function<E, E> identity() {
        return IDENTITY;
    }

    public static <A, B> Function<A, B> forMap(final Map<A, B> map) {
        Preconditions.checkNotNull(map);
        return new Function<A, B>(){

            @Override
            public B apply(A a) {
                return map.get(a);
            }
        };
    }

    public static <A, B> Function<A, B> forMap(final Map<A, ? extends B> map, final @Nullable B defaultValue) {
        Preconditions.checkNotNull(map);
        return new Function<A, B>(){

            @Override
            public B apply(A a) {
                return map.containsKey(a) ? map.get(a) : defaultValue;
            }
        };
    }

    public static <A, B, C> Function<A, C> compose(final Function<B, C> g, final Function<A, ? extends B> f) {
        Preconditions.checkNotNull(g);
        Preconditions.checkNotNull(f);
        return new Function<A, C>(){

            @Override
            public C apply(A a) {
                return g.apply(f.apply(a));
            }
        };
    }

    public static <T> Function<T, Boolean> forPredicate(Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        return new PredicateFunction(predicate);
    }

    public static <E> Function<Object, E> constant(final @Nullable E value) {
        return new Function<Object, E>(){

            @Override
            public E apply(Object from) {
                return value;
            }
        };
    }

    public static <A, B> Function<A, B> narrow(@Nullable Function<? super A, ? extends B> function) {
        Function<? super A, ? extends B> intermediate = function;
        return intermediate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PredicateFunction<T>
    implements Function<T, Boolean>,
    Serializable {
        private final Predicate<? super T> predicate;
        private static final long serialVersionUID = 7159925838099303368L;

        private PredicateFunction(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public Boolean apply(T t) {
            return this.predicate.apply(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdentityFunction
    implements Function<Object, Object> {
        private IdentityFunction() {
        }

        @Override
        public Object apply(Object e) {
            return e;
        }
    }
}

