/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Predicates {
    private static final Predicate<Object> ALWAYS_TRUE = new AlwaysTruePredicate();
    private static final Predicate<Object> ALWAYS_FALSE = new AlwaysFalsePredicate();
    private static final Predicate<Object> IS_NULL = new IsNullPredicate();

    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static <T> Predicate<T> isNull() {
        return IS_NULL;
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        return new NotPredicate(predicate);
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> components) {
        Preconditions.checkNotNull(components);
        return new AndPredicate(components);
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        Preconditions.checkNotNull(components);
        return Predicates.and(Arrays.asList(components));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        Preconditions.checkNotNull(components);
        return new OrPredicate(components);
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        Preconditions.checkNotNull(components);
        return Predicates.or(Arrays.asList(components));
    }

    public static <T> Predicate<T> isEqualTo(@Nullable T target) {
        return target == null ? Predicates.isNull() : new IsEqualToPredicate(target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsNullPredicate
    implements Predicate<Object>,
    Serializable {
        private static final long serialVersionUID = -2507344851931204908L;

        private IsNullPredicate() {
        }

        @Override
        public boolean apply(Object o) {
            return o == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 6457380537065200145L;
        private final T target;

        private IsEqualToPredicate(T target) {
            Preconditions.checkNotNull(target);
            this.target = target;
        }

        @Override
        public boolean apply(T t) {
            return this.target.equals(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -7942366790698074803L;
        private final Iterable<? extends Predicate<? super T>> components;

        private OrPredicate(Iterable<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (!predicate.apply(t)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 1022358602593297546L;
        private final Iterable<? extends Predicate<? super T>> components;

        private AndPredicate(Iterable<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (predicate.apply(t)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -5113445916422049953L;
        private final Predicate<? super T> predicate;

        private NotPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlwaysFalsePredicate
    implements Predicate<Object>,
    Serializable {
        private static final long serialVersionUID = -565481022115659695L;

        private AlwaysFalsePredicate() {
        }

        @Override
        public boolean apply(Object o) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlwaysTruePredicate
    implements Predicate<Object>,
    Serializable {
        private static final long serialVersionUID = 8759914710239461322L;

        private AlwaysTruePredicate() {
        }

        @Override
        public boolean apply(Object o) {
            return true;
        }
    }
}

