/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.Iterators;
import com.google.common.collect.ObjectArrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ForwardingCollection<E>
extends ForwardingObject
implements Collection<E> {
    protected ForwardingCollection(Collection<E> delegate) {
        super(delegate);
    }

    @Override
    protected Collection<E> delegate() {
        return (Collection)super.delegate();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate().iterator();
    }

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.delegate().removeAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate().contains(object);
    }

    @Override
    public Object[] toArray() {
        return this.delegate().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.delegate().toArray(array);
    }

    @Override
    public boolean add(E element) {
        return this.delegate().add(element);
    }

    @Override
    public boolean remove(Object object) {
        return this.delegate().remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegate().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.delegate().addAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate().retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate().clear();
    }

    static Object[] toArrayImpl(Collection<?> c) {
        return ObjectArrays.toArrayImpl(c);
    }

    static <T> T[] toArrayImpl(Collection<?> c, T[] array) {
        return ObjectArrays.toArrayImpl(c, array);
    }

    static String toStringImpl(Collection<?> c) {
        return Iterators.toString(c.iterator());
    }

    static boolean containsImpl(Collection<?> c, @Nullable Object o) {
        for (Object member : c) {
            if (!Objects.equal(member, o)) continue;
            return true;
        }
        return false;
    }

    static boolean containsAllImpl(Collection<?> c, Collection<?> d) {
        Preconditions.checkNotNull(c);
        for (Object o : d) {
            if (c.contains(o)) continue;
            return false;
        }
        return true;
    }

    static boolean removeImpl(Collection<?> c, @Nullable Object o) {
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            if (!Objects.equal(i.next(), o)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    static boolean removeAllImpl(Collection<?> c, Collection<?> d) {
        Preconditions.checkNotNull(d);
        boolean modified = false;
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            if (!d.contains(i.next())) continue;
            i.remove();
            modified = true;
        }
        return modified;
    }

    static boolean retainAllImpl(Collection<?> c, Collection<?> d) {
        Preconditions.checkNotNull(d);
        boolean modified = false;
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            if (d.contains(i.next())) continue;
            i.remove();
            modified = true;
        }
        return modified;
    }
}

