/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Lists {
    private static final Class<?> SINGLETON_CLASS = Collections.singletonList(1).getClass();

    private Lists() {
    }

    public static <E> List<E> immutableList(E ... elements) {
        switch (elements.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(elements[0]);
            }
        }
        return new ImmutableArrayList<Object>((Object[])elements.clone());
    }

    public static <E> List<E> immutableList(Iterable<? extends E> iterable) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return Lists.immutableList(collection);
        }
        return Lists.immutableList(iterable.iterator());
    }

    public static <E> List<E> immutableList(Iterator<? extends E> iterator) {
        return Lists.immutableList(Lists.newArrayList(iterator));
    }

    public static <E> List<E> immutableList(Collection<? extends E> collection) {
        int size = collection.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (SINGLETON_CLASS.isInstance(collection) || collection instanceof ImmutableArrayList) {
            List result = (List)collection;
            return result;
        }
        if (size == 1) {
            return Collections.singletonList(collection.iterator().next());
        }
        Object[] array = collection.toArray();
        return new ImmutableArrayList<Object>(array);
    }

    public static <E> List<E> immutableList() {
        return Collections.emptyList();
    }

    public static <E> List<E> immutableList(@Nullable E element) {
        return Collections.singletonList(element);
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(E ... elements) {
        int capacity = Lists.computeArrayListCapacity(elements.length);
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, elements);
        return list;
    }

    static int computeArrayListCapacity(int arraySize) {
        return (int)Math.min(5L + (long)arraySize + (long)(arraySize / 10), Integer.MAX_VALUE);
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new ArrayList(collection);
        }
        return Lists.newArrayList(elements.iterator());
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        ArrayList<E> list = Lists.newArrayList();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <E> ArrayList<E> newArrayListWithCapacity(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static <E> ArrayList<E> newArrayListWithExpectedSize(int expectedSize) {
        return new ArrayList(Lists.computeArrayListCapacity(expectedSize));
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> LinkedList<E> newLinkedList(E ... elements) {
        LinkedList<E> list = Lists.newLinkedList();
        Collections.addAll(list, elements);
        return list;
    }

    public static <E> LinkedList<E> newLinkedList(Iterable<? extends E> elements) {
        return Lists.newLinkedList(elements.iterator());
    }

    public static <E> LinkedList<E> newLinkedList(Iterator<? extends E> elements) {
        LinkedList<E> list = Lists.newLinkedList();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <E extends Comparable> List<E> sortedCopy(Iterable<E> iterable) {
        ArrayList<E> list = Lists.newArrayList(iterable);
        Collections.sort(list);
        return list;
    }

    public static <E> List<E> sortedCopy(Iterable<E> iterable, Comparator<? super E> comparator) {
        ArrayList<E> list = Lists.newArrayList(iterable);
        Collections.sort(list, Preconditions.checkNotNull(comparator));
        return list;
    }

    public static <E> List<E> asList(@Nullable E first, E[] rest) {
        return new OnePlusArrayList<E>(first, rest);
    }

    public static <E> List<E> asList(@Nullable E first, @Nullable E second, E[] rest) {
        return new TwoPlusArrayList<E>(first, second, rest);
    }

    public static <F, T> List<T> transform(List<F> fromList, Function<? super F, ? extends T> function) {
        return fromList instanceof RandomAccess ? new TransformingRandomAccessList<F, T>(fromList, function) : new TransformingList<F, T>(fromList, function);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmutableArrayList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        final E[] array;
        private static final long serialVersionUID = 170583961L;

        ImmutableArrayList(E[] array) {
            this.array = array;
        }

        @Override
        public E get(int index) {
            return this.array[index];
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Object[] toArray() {
            Object[] newArray = new Object[this.array.length];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            return newArray;
        }

        @Override
        public String toString() {
            return Arrays.toString(this.array);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformingRandomAccessList<F, T>
    extends TransformingList<F, T>
    implements RandomAccess {
        private static final long serialVersionUID = -7837562545549389035L;

        TransformingRandomAccessList(List<F> fromList, Function<? super F, ? extends T> function) {
            super(fromList, function);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformingList<F, T>
    extends AbstractList<T>
    implements Serializable {
        final List<F> fromList;
        final Function<? super F, ? extends T> function;
        private static final long serialVersionUID = -5874381536079320827L;

        TransformingList(List<F> fromList, Function<? super F, ? extends T> function) {
            this.fromList = Preconditions.checkNotNull(fromList);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public T get(int index) {
            return this.function.apply(this.fromList.get(index));
        }

        @Override
        public boolean isEmpty() {
            return this.fromList.isEmpty();
        }

        @Override
        public T remove(int index) {
            return this.function.apply(this.fromList.remove(index));
        }

        @Override
        public int size() {
            return this.fromList.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TwoPlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        final E first;
        final E second;
        final E[] rest;
        private static final long serialVersionUID = -1789891963162733178L;

        TwoPlusArrayList(@Nullable E first, @Nullable E second, E[] rest) {
            this.first = first;
            this.second = second;
            this.rest = Preconditions.checkNotNull(rest);
        }

        @Override
        public int size() {
            return this.rest.length + 2;
        }

        @Override
        public E get(int index) {
            switch (index) {
                case 0: {
                    return this.first;
                }
                case 1: {
                    return this.second;
                }
            }
            return this.rest[index - 2];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OnePlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        final E first;
        final E[] rest;
        private static final long serialVersionUID = -263507107612916621L;

        OnePlusArrayList(@Nullable E first, E[] rest) {
            this.first = first;
            this.rest = Preconditions.checkNotNull(rest);
        }

        @Override
        public int size() {
            return this.rest.length + 1;
        }

        @Override
        public E get(int index) {
            return index == 0 ? this.first : this.rest[index - 1];
        }
    }
}

