/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimapBuilder;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.StandardListMultimap;
import com.google.common.collect.StandardMultimap;
import com.google.common.collect.StandardSetMultimap;
import com.google.common.collect.StandardSortedSetMultimap;
import com.google.common.collect.Synchronized;
import com.google.common.collect.TreeMultimap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Multimaps {
    private static final ListMultimap<?, ?> EMPTY_LIST_MULTIMAP = new ImmutableMultimapBuilder().getMultimap();

    private Multimaps() {
    }

    public static <K, V> HashMultimap<K, V> newHashMultimap() {
        return new HashMultimap();
    }

    public static <K, V> HashMultimap<K, V> newHashMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new HashMultimap<K, V>(multimap);
    }

    public static <K, V> ArrayListMultimap<K, V> newArrayListMultimap() {
        return new ArrayListMultimap();
    }

    public static <K, V> ArrayListMultimap<K, V> newArrayListMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new ArrayListMultimap<K, V>(multimap);
    }

    public static <K, V> LinkedHashMultimap<K, V> newLinkedHashMultimap() {
        return new LinkedHashMultimap();
    }

    public static <K, V> LinkedHashMultimap<K, V> newLinkedHashMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new LinkedHashMultimap<K, V>(multimap);
    }

    public static <K, V> LinkedListMultimap<K, V> newLinkedListMultimap() {
        return new LinkedListMultimap();
    }

    public static <K, V> LinkedListMultimap<K, V> newLinkedListMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new LinkedListMultimap<K, V>(multimap);
    }

    public static <K extends Comparable, V extends Comparable> TreeMultimap<K, V> newTreeMultimap() {
        return new TreeMultimap();
    }

    public static <K, V> TreeMultimap<K, V> newTreeMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new TreeMultimap<K, V>(multimap);
    }

    public static <K, V> TreeMultimap<K, V> newTreeMultimap(@Nullable Comparator<? super K> keyComparator, @Nullable Comparator<? super V> valueComparator) {
        return new TreeMultimap<K, V>(keyComparator, valueComparator);
    }

    public static <K, V> TreeMultimap<K, V> newTreeMultimap(@Nullable Comparator<? super K> keyComparator, @Nullable Comparator<? super V> valueComparator, Multimap<? extends K, ? extends V> multimap) {
        return new TreeMultimap<K, V>(keyComparator, valueComparator, multimap);
    }

    public static <K, V> Multimap<K, V> newMultimap(Map<K, Collection<V>> map, final Supplier<? extends Collection<V>> factory) {
        return new StandardMultimap<K, V>(map){

            @Override
            protected Collection<V> createCollection() {
                return (Collection)factory.get();
            }
        };
    }

    public static <K, V> ListMultimap<K, V> newListMultimap(Map<K, Collection<V>> map, final Supplier<? extends List<V>> factory) {
        return new StandardListMultimap<K, V>(map){

            @Override
            protected List<V> createCollection() {
                return (List)factory.get();
            }
        };
    }

    public static <K, V> SetMultimap<K, V> newSetMultimap(Map<K, Collection<V>> map, final Supplier<? extends Set<V>> factory) {
        return new StandardSetMultimap<K, V>(map){

            @Override
            protected Set<V> createCollection() {
                return (Set)factory.get();
            }
        };
    }

    public static <K, V> SortedSetMultimap<K, V> newSortedSetMultimap(Map<K, Collection<V>> map, final Supplier<? extends SortedSet<V>> factory) {
        return new StandardSortedSetMultimap<K, V>(map){

            @Override
            protected SortedSet<V> createCollection() {
                return (SortedSet)factory.get();
            }
        };
    }

    public static <K, V> HashMultimap<V, K> inverseHashMultimap(Multimap<K, V> multimap) {
        HashMultimap inverse = new HashMultimap();
        Multimaps.addInverse(inverse, multimap);
        return inverse;
    }

    public static <K, V> ArrayListMultimap<V, K> inverseArrayListMultimap(Multimap<K, V> multimap) {
        ArrayListMultimap inverse = new ArrayListMultimap();
        Multimaps.addInverse(inverse, multimap);
        return inverse;
    }

    public static <K, V> LinkedHashMultimap<V, K> inverseLinkedHashMultimap(Multimap<K, V> multimap) {
        LinkedHashMultimap inverse = new LinkedHashMultimap();
        Multimaps.addInverse(inverse, multimap);
        return inverse;
    }

    public static <K, V> TreeMultimap<V, K> inverseTreeMultimap(Multimap<K, V> multimap) {
        TreeMultimap inverse = new TreeMultimap();
        Multimaps.addInverse(inverse, multimap);
        return inverse;
    }

    public static <K, V> LinkedListMultimap<V, K> inverseLinkedListMultimap(Multimap<K, V> multimap) {
        LinkedListMultimap inverse = new LinkedListMultimap();
        Multimaps.addInverse(inverse, multimap);
        return inverse;
    }

    private static <K, V> void addInverse(Multimap<V, K> inverse, Multimap<K, V> multimap) {
        for (Map.Entry<K, V> entry : multimap.entries()) {
            inverse.put(entry.getValue(), entry.getKey());
        }
    }

    public static <K, V> Multimap<K, V> synchronizedMultimap(Multimap<K, V> multimap) {
        return Synchronized.multimap(multimap, null);
    }

    public static <K, V> Multimap<K, V> unmodifiableMultimap(Multimap<K, V> delegate) {
        return new UnmodifiableMultimap<K, V>(delegate);
    }

    public static <K, V> SetMultimap<K, V> synchronizedSetMultimap(SetMultimap<K, V> multimap) {
        return new SetDecorator<K, V>(Multimaps.synchronizedMultimap(multimap));
    }

    public static <K, V> SetMultimap<K, V> unmodifiableSetMultimap(SetMultimap<K, V> delegate) {
        return new SetDecorator<K, V>(Multimaps.unmodifiableMultimap(delegate));
    }

    public static <K, V> SortedSetMultimap<K, V> synchronizedSortedSetMultimap(SortedSetMultimap<K, V> multimap) {
        return new SortedSetDecorator<K, V>(Multimaps.synchronizedMultimap(multimap));
    }

    public static <K, V> SortedSetMultimap<K, V> unmodifiableSortedSetMultimap(SortedSetMultimap<K, V> delegate) {
        return new SortedSetDecorator<K, V>(Multimaps.unmodifiableMultimap(delegate));
    }

    public static <K, V> ListMultimap<K, V> synchronizedListMultimap(ListMultimap<K, V> multimap) {
        return new ListDecorator<K, V>(Multimaps.synchronizedMultimap(multimap));
    }

    public static <K, V> ListMultimap<K, V> unmodifiableListMultimap(ListMultimap<K, V> delegate) {
        return new ListDecorator<K, V>(Multimaps.unmodifiableMultimap(delegate));
    }

    private static <V> Collection<V> unmodifiableValueCollection(Collection<V> collection) {
        if (collection instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        return Collections.unmodifiableCollection(collection);
    }

    private static <K, V> Map.Entry<K, Collection<V>> unmodifiableAsMapEntry(final Map.Entry<K, Collection<V>> entry) {
        Preconditions.checkNotNull(entry);
        return new AbstractMapEntry<K, Collection<V>>(){

            @Override
            public K getKey() {
                return entry.getKey();
            }

            @Override
            public Collection<V> getValue() {
                return Multimaps.unmodifiableValueCollection((Collection)entry.getValue());
            }
        };
    }

    private static <K, V> Collection<Map.Entry<K, V>> unmodifiableEntries(Collection<Map.Entry<K, V>> entries) {
        if (entries instanceof Set) {
            return Maps.unmodifiableEntrySet((Set)entries);
        }
        return new Maps.UnmodifiableEntries<K, V>(Collections.unmodifiableCollection(entries));
    }

    private static <K, V> Set<Map.Entry<K, Collection<V>>> unmodifiableAsMapEntries(Set<Map.Entry<K, Collection<V>>> asMapEntries) {
        return new UnmodifiableAsMapEntries<K, V>(Collections.unmodifiableSet(asMapEntries));
    }

    public static <K, V> SetMultimap<K, V> forMap(Map<K, V> map) {
        return new MapMultimap<K, V>(map);
    }

    public static <K, V> ListMultimap<K, V> immutableMultimap() {
        return EMPTY_LIST_MULTIMAP;
    }

    public static <K, V> ListMultimap<K, V> immutableMultimap(@Nullable K k1, @Nullable V v1) {
        return new ImmutableMultimapBuilder<K, V>().put(k1, v1).getMultimap();
    }

    public static <K, V> ListMultimap<K, V> immutableMultimap(@Nullable K k1, @Nullable V v1, @Nullable K k2, @Nullable V v2) {
        return new ImmutableMultimapBuilder<K, V>().put(k1, v1).put(k2, v2).getMultimap();
    }

    public static <K, V> ListMultimap<K, V> immutableMultimap(@Nullable K k1, @Nullable V v1, @Nullable K k2, @Nullable V v2, @Nullable K k3, @Nullable V v3) {
        return new ImmutableMultimapBuilder<K, V>().put(k1, v1).put(k2, v2).put(k3, v3).getMultimap();
    }

    public static <K, V> ListMultimap<K, V> immutableMultimap(@Nullable K k1, @Nullable V v1, @Nullable K k2, @Nullable V v2, @Nullable K k3, @Nullable V v3, @Nullable K k4, @Nullable V v4) {
        return new ImmutableMultimapBuilder<K, V>().put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).getMultimap();
    }

    public static <K, V> ListMultimap<K, V> immutableMultimap(@Nullable K k1, @Nullable V v1, @Nullable K k2, @Nullable V v2, @Nullable K k3, @Nullable V v3, @Nullable K k4, @Nullable V v4, @Nullable K k5, @Nullable V v5) {
        return new ImmutableMultimapBuilder<K, V>().put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).put(k5, v5).getMultimap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapMultimap<K, V>
    implements SetMultimap<K, V>,
    Serializable {
        final Map<K, V> map;
        volatile transient Map<K, Collection<V>> asMap;
        private static final long serialVersionUID = 7845222491160860175L;

        MapMultimap(Map<K, V> map) {
            this.map = Preconditions.checkNotNull(map);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public boolean containsEntry(Object key, Object value) {
            return this.map.entrySet().contains(Maps.immutableEntry(key, value));
        }

        @Override
        public Set<V> get(final K key) {
            return new AbstractSet<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        int i;

                        @Override
                        public boolean hasNext() {
                            return this.i == 0 && MapMultimap.this.map.containsKey(key);
                        }

                        @Override
                        public V next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            ++this.i;
                            return MapMultimap.this.map.get(key);
                        }

                        @Override
                        public void remove() {
                            Preconditions.checkState(this.i == 1);
                            this.i = -1;
                            MapMultimap.this.map.remove(key);
                        }
                    };
                }

                @Override
                public int size() {
                    return MapMultimap.this.map.containsKey(key) ? 1 : 0;
                }
            };
        }

        @Override
        public boolean put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Multimap<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<V> replaceValues(K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.map.entrySet().remove(Maps.immutableEntry(key, value));
        }

        @Override
        public Set<V> removeAll(Object key) {
            HashSet<V> values = new HashSet<V>(2, 0.75f);
            if (!this.map.containsKey(key)) {
                return values;
            }
            values.add(this.map.remove(key));
            return values;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public Multiset<K> keys() {
            return Multisets.forSet(this.map.keySet());
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entries() {
            return this.map.entrySet();
        }

        @Override
        public Map<K, Collection<V>> asMap() {
            if (this.asMap == null) {
                this.asMap = new AsMap();
            }
            return this.asMap;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Multimap)) {
                return false;
            }
            Multimap m = (Multimap)o;
            if (this.map.size() != m.size()) {
                return false;
            }
            for (Map.Entry<K, V> e : this.map.entrySet()) {
                if (m.containsEntry(e.getKey(), e.getValue())) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return ((Object)this.map).hashCode();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append('{');
            for (Map.Entry<K, V> e : this.map.entrySet()) {
                buf.append(e.getKey()).append("=[").append(e.getValue()).append("], ");
            }
            if (buf.length() > 1) {
                buf.setLength(buf.length() - 2);
            }
            buf.append('}');
            return buf.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AsMap
        extends AbstractMap<K, Collection<V>> {
            private volatile Set<Map.Entry<K, Collection<V>>> entries;

            AsMap() {
            }

            @Override
            public Set<Map.Entry<K, Collection<V>>> entrySet() {
                if (this.entries == null) {
                    this.entries = new AsMapEntries();
                }
                return this.entries;
            }

            @Override
            public boolean containsKey(Object key) {
                return MapMultimap.this.map.containsKey(key);
            }

            @Override
            public Collection<V> get(Object key) {
                Collection collection = MapMultimap.this.get(key);
                return collection.isEmpty() ? null : collection;
            }

            @Override
            public Collection<V> remove(Object key) {
                Collection collection = MapMultimap.this.removeAll(key);
                return collection.isEmpty() ? null : collection;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AsMapEntries
        extends AbstractSet<Map.Entry<K, Collection<V>>> {
            AsMapEntries() {
            }

            @Override
            public int size() {
                return MapMultimap.this.map.size();
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new Iterator<Map.Entry<K, Collection<V>>>(){
                    final Iterator<K> keys;
                    {
                        this.keys = MapMultimap.this.map.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keys.hasNext();
                    }

                    @Override
                    public Map.Entry<K, Collection<V>> next() {
                        final Object key = this.keys.next();
                        return new AbstractMapEntry<K, Collection<V>>(){

                            @Override
                            public K getKey() {
                                return key;
                            }

                            @Override
                            public Collection<V> getValue() {
                                return MapMultimap.this.get(key);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.keys.remove();
                    }
                };
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableAsMapEntries<K, V>
    extends ForwardingSet<Map.Entry<K, Collection<V>>> {
        UnmodifiableAsMapEntries(Set<Map.Entry<K, Collection<V>>> asMapEntries) {
            super(asMapEntries);
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            return new ForwardingIterator<Map.Entry<K, Collection<V>>>(super.iterator()){

                @Override
                public Map.Entry<K, Collection<V>> next() {
                    return Multimaps.unmodifiableAsMapEntry((Map.Entry)super.next());
                }
            };
        }

        @Override
        public Object[] toArray() {
            return UnmodifiableAsMapEntries.toArrayImpl(this);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return UnmodifiableAsMapEntries.toArrayImpl(this, array);
        }

        @Override
        public boolean contains(Object o) {
            return Maps.containsEntryImpl(this.delegate(), o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return UnmodifiableAsMapEntries.containsAllImpl(this, c);
        }

        @Override
        public boolean equals(Object o) {
            return UnmodifiableAsMapEntries.equalsImpl(this, o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListDecorator<K, V>
    extends ForwardingMultimap<K, V>
    implements ListMultimap<K, V> {
        private static final long serialVersionUID = -8065289457161999256L;

        ListDecorator(Multimap<K, V> delegate) {
            super(delegate);
        }

        @Override
        public List<V> get(@Nullable K key) {
            return (List)super.get(key);
        }

        @Override
        public List<V> removeAll(@Nullable Object key) {
            return (List)super.removeAll(key);
        }

        @Override
        public List<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
            return (List)super.replaceValues(key, values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SortedSetDecorator<K, V>
    extends ForwardingMultimap<K, V>
    implements SortedSetMultimap<K, V> {
        private static final long serialVersionUID = 7463737759006994232L;

        SortedSetDecorator(Multimap<K, V> delegate) {
            super(delegate);
        }

        @Override
        public SortedSet<V> get(@Nullable K key) {
            return (SortedSet)super.get(key);
        }

        @Override
        public Set<Map.Entry<K, V>> entries() {
            return (Set)super.entries();
        }

        @Override
        public SortedSet<V> removeAll(@Nullable Object key) {
            return (SortedSet)super.removeAll(key);
        }

        @Override
        public SortedSet<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
            return (SortedSet)super.replaceValues(key, values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SetDecorator<K, V>
    extends ForwardingMultimap<K, V>
    implements SetMultimap<K, V> {
        private static final long serialVersionUID = -6403585629821552555L;

        SetDecorator(Multimap<K, V> delegate) {
            super(delegate);
        }

        @Override
        public Set<V> get(@Nullable K key) {
            return (Set)super.get(key);
        }

        @Override
        public Set<Map.Entry<K, V>> entries() {
            return (Set)super.entries();
        }

        @Override
        public Set<V> removeAll(@Nullable Object key) {
            return (Set)super.removeAll(key);
        }

        @Override
        public Set<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
            return (Set)super.replaceValues(key, values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableAsMapValues<V>
    extends ForwardingCollection<Collection<V>> {
        UnmodifiableAsMapValues(Collection<Collection<V>> delegate) {
            super(Collections.unmodifiableCollection(delegate));
        }

        @Override
        public Iterator<Collection<V>> iterator() {
            final Iterator iterator = super.iterator();
            return new Iterator<Collection<V>>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Collection<V> next() {
                    return Multimaps.unmodifiableValueCollection((Collection)iterator.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return UnmodifiableAsMapValues.toArrayImpl(this);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return UnmodifiableAsMapValues.toArrayImpl(this, array);
        }

        @Override
        public boolean contains(Object o) {
            return UnmodifiableAsMapValues.containsImpl(this, o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return UnmodifiableAsMapValues.containsAllImpl(this, c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnmodifiableMultimap<K, V>
    extends ForwardingMultimap<K, V> {
        volatile transient Collection<Map.Entry<K, V>> entries;
        volatile transient Multiset<K> keys;
        volatile transient Set<K> keySet;
        volatile transient Collection<V> values;
        volatile transient Map<K, Collection<V>> map;

        public UnmodifiableMultimap(Multimap<K, V> delegate) {
            super(delegate);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<K, Collection<V>> asMap() {
            if (this.map == null) {
                Map unmodifiableMap = Collections.unmodifiableMap(this.delegate().asMap());
                this.map = new ForwardingMap<K, Collection<V>>(unmodifiableMap){
                    volatile Collection<Collection<V>> values;
                    volatile Set<Map.Entry<K, Collection<V>>> entrySet;

                    @Override
                    public Set<Map.Entry<K, Collection<V>>> entrySet() {
                        if (this.entrySet == null) {
                            this.entrySet = Multimaps.unmodifiableAsMapEntries(super.entrySet());
                        }
                        return this.entrySet;
                    }

                    @Override
                    public Collection<V> get(Object key) {
                        Collection collection = (Collection)super.get(key);
                        return collection == null ? null : Multimaps.unmodifiableValueCollection(collection);
                    }

                    @Override
                    public Collection<Collection<V>> values() {
                        if (this.values == null) {
                            this.values = new UnmodifiableAsMapValues(super.values());
                        }
                        return this.values;
                    }

                    @Override
                    public boolean containsValue(Object o) {
                        return this.values().contains(o);
                    }
                };
            }
            return this.map;
        }

        @Override
        public Collection<Map.Entry<K, V>> entries() {
            if (this.entries == null) {
                this.entries = Multimaps.unmodifiableEntries(super.entries());
            }
            return this.entries;
        }

        @Override
        public Collection<V> get(K key) {
            return Multimaps.unmodifiableValueCollection(super.get(key));
        }

        @Override
        public Multiset<K> keys() {
            if (this.keys == null) {
                this.keys = Multisets.unmodifiableMultiset(super.keys());
            }
            return this.keys;
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(super.keySet());
            }
            return this.keySet;
        }

        @Override
        public boolean put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Multimap<? extends K, ? extends V> multimap) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<V> removeAll(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(super.values());
            }
            return this.values;
        }
    }
}

