/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import java.lang.reflect.Array;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectArrays {
    private ObjectArrays() {
    }

    public static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] emptyArray(T[] array) {
        if (array.length == 0) {
            return array;
        }
        return (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
    }

    public static <T> T[] concat(T[] first, T[] second, Class<T> type) {
        T[] result = ObjectArrays.newArray(type, first.length + second.length);
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    static <T> T[] toArrayImpl(Collection<?> self, T[] array) {
        int size = self.size();
        if (array.length < size) {
            Class<?> type = array.getClass().getComponentType();
            array = ObjectArrays.newArray(type, size);
        }
        ObjectArrays.fillArray(self, array);
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    static Object[] toArrayImpl(Collection<?> self) {
        return ObjectArrays.fillArray(self, new Object[self.size()]);
    }

    private static Object[] fillArray(Iterable<?> elements, Object[] array) {
        int i = 0;
        for (Object element : elements) {
            array[i++] = element;
        }
        return array;
    }
}

