/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.SortedArraySet;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sets {
    private static final SortedSet<?> EMPTY_SORTED_SET = new EmptySortedSet();

    private Sets() {
    }

    public static <E extends Comparable> SortedSet<E> immutableSortedSet(E ... elements) {
        switch (elements.length) {
            case 0: {
                SortedSet<?> result = EMPTY_SORTED_SET;
                return result;
            }
        }
        return Collections.unmodifiableSortedSet(Sets.newSortedArraySet(elements));
    }

    public static <E> SortedSet<E> immutableSortedSet(@Nullable Comparator<? super E> comparator, E ... elements) {
        switch (elements.length) {
            case 0: {
                return Sets.immutableSortedSet(comparator);
            }
        }
        return Collections.unmodifiableSortedSet(Sets.newSortedArraySet(comparator, elements));
    }

    public static <E extends Comparable> SortedSet<E> immutableSortedSet() {
        return EMPTY_SORTED_SET;
    }

    public static <E> SortedSet<E> immutableSortedSet(@Nullable Comparator<? super E> comparator) {
        return Collections.unmodifiableSortedSet(Sets.newSortedArraySet(comparator));
    }

    public static <E extends Comparable> SortedSet<E> immutableSortedSet(E element) {
        return Collections.unmodifiableSortedSet(Sets.newSortedArraySet((Comparable[])new Comparable[]{element}));
    }

    public static <E> SortedSet<E> immutableSortedSet(@Nullable Comparator<? super E> comparator, @Nullable E element) {
        return Collections.unmodifiableSortedSet(Sets.newSortedArraySet(comparator, element));
    }

    public static <E> Set<E> immutableSet(E ... elements) {
        switch (elements.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(elements[0]);
            }
        }
        return new ImmutableHashSet<E>(elements);
    }

    public static <E> Set<E> immutableSet() {
        return Collections.emptySet();
    }

    public static <E> Set<E> immutableSet(@Nullable E element) {
        return Collections.singleton(element);
    }

    public static <E> Set<E> immutableSet(Collection<E> collection) {
        switch (collection.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(collection.iterator().next());
            }
        }
        return new ImmutableHashSet<E>(collection);
    }

    public static <E extends Enum<E>> Set<E> immutableEnumSet(E anElement, E ... otherElements) {
        return Collections.unmodifiableSet(EnumSet.of(anElement, otherElements));
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(E ... elements) {
        int capacity = elements.length * 4 / 3 + 1;
        HashSet set = new HashSet(capacity);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new HashSet(collection);
        }
        return Sets.newHashSet(elements.iterator());
    }

    public static <E> HashSet<E> newHashSet(Iterator<? extends E> elements) {
        HashSet<E> set = Sets.newHashSet();
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return set;
    }

    public static <E> Set<E> newConcurrentHashSet() {
        return Sets.newSetFromMap(new ConcurrentHashMap());
    }

    public static <E> Set<E> newConcurrentHashSet(E ... elements) {
        int capacity = elements.length * 4 / 3 + 1;
        Set set = Sets.newSetFromMap(new ConcurrentHashMap(capacity));
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> Set<E> newConcurrentHashSet(Iterable<? extends E> elements) {
        return Sets.newConcurrentHashSet(elements.iterator());
    }

    public static <E> Set<E> newConcurrentHashSet(Iterator<? extends E> elements) {
        Set<E> set = Sets.newConcurrentHashSet();
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return set;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(E ... elements) {
        LinkedHashSet set = new LinkedHashSet(elements.length * 4 / 3 + 1);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new LinkedHashSet(collection);
        }
        return Sets.newLinkedHashSet(elements.iterator());
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Iterator<? extends E> elements) {
        LinkedHashSet<E> set = Sets.newLinkedHashSet();
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return set;
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet(E ... elements) {
        TreeSet<E> set = Sets.newTreeSet();
        Collections.addAll(set, elements);
        return set;
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet(Iterable<? extends E> elements) {
        return Sets.newTreeSet(elements.iterator());
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet(Iterator<? extends E> elements) {
        TreeSet<E> set = Sets.newTreeSet();
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return set;
    }

    public static <E> TreeSet<E> newTreeSet(@Nullable Comparator<? super E> comparator) {
        return new TreeSet<E>(comparator);
    }

    public static <E> TreeSet<E> newTreeSet(@Nullable Comparator<? super E> comparator, E ... elements) {
        TreeSet<? super E> set = Sets.newTreeSet(comparator);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> TreeSet<E> newTreeSet(@Nullable Comparator<? super E> comparator, Iterable<? extends E> elements) {
        return Sets.newTreeSet(comparator, elements.iterator());
    }

    public static <E> TreeSet<E> newTreeSet(@Nullable Comparator<? super E> comparator, Iterator<? extends E> elements) {
        TreeSet<E> set = Sets.newTreeSet(comparator);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return set;
    }

    public static <E extends Comparable> SortedArraySet<E> newSortedArraySet() {
        return new SortedArraySet(0);
    }

    public static <E> SortedArraySet<E> newSortedArraySet(Comparator<? super E> comparator) {
        return new SortedArraySet<E>(comparator, 0);
    }

    public static <E extends Comparable> SortedArraySet<E> newSortedArraySet(Iterable<? extends E> elements) {
        return Sets.newSortedArraySet(elements, Comparators.naturalOrder());
    }

    public static <E> SortedArraySet<E> newSortedArraySet(Iterable<? extends E> elements, Comparator<? super E> comparator) {
        SortedArraySet<E> set = new SortedArraySet<E>(comparator, elements instanceof Collection ? ((Collection)elements).size() : 0);
        for (E element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <E> SortedArraySet<E> newSortedArraySet(Comparator<? super E> comparator, E ... elements) {
        SortedArraySet<? super E> set = new SortedArraySet<E>(comparator, elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E extends Comparable> SortedArraySet<E> newSortedArraySet(E ... elements) {
        for (E element : elements) {
            Preconditions.checkNotNull(element);
        }
        return Sets.newSortedArraySet(Comparators.naturalOrder(), elements);
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection) {
        Preconditions.checkNotNull(collection);
        if (collection instanceof EnumSet) {
            return EnumSet.complementOf((EnumSet)collection);
        }
        Preconditions.checkArgument(!collection.isEmpty(), "collection is empty; use the other version of this method");
        Class type = ((Enum)collection.iterator().next()).getDeclaringClass();
        return Sets.makeComplementByHand(collection, type);
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection, Class<E> type) {
        Preconditions.checkNotNull(collection);
        return collection instanceof EnumSet ? EnumSet.complementOf((EnumSet)collection) : Sets.makeComplementByHand(collection, type);
    }

    private static <E extends Enum<E>> EnumSet<E> makeComplementByHand(Collection<E> collection, Class<E> type) {
        EnumSet<E> result = EnumSet.allOf(type);
        result.removeAll(collection);
        return result;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        Preconditions.checkNotNull(map);
        Preconditions.checkArgument(map.isEmpty());
        return new MapBackedSet<E>(map);
    }

    public static <E> SortedSet<E> emptySortedSet() {
        return EMPTY_SORTED_SET;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptySortedSet<E>
    extends AbstractSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = -1674208229134945065L;

        private EmptySortedSet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public Comparator<? super E> comparator() {
            return null;
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            throw new IllegalArgumentException();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            throw new IllegalArgumentException();
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            throw new IllegalArgumentException();
        }

        @Override
        public E first() {
            throw new NoSuchElementException();
        }

        @Override
        public E last() {
            throw new NoSuchElementException();
        }

        private Object readResolve() {
            return EMPTY_SORTED_SET;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapBackedSet<E>
    extends ForwardingSet<E>
    implements Serializable {
        final Map<E, Boolean> map;
        private static final long serialVersionUID = -746515900529047486L;

        MapBackedSet(Map<E, Boolean> map) {
            super(map.keySet());
            this.map = map;
        }

        @Override
        public boolean add(E element) {
            return this.map.put(element, Boolean.TRUE) == null;
        }

        @Override
        public boolean addAll(Collection<? extends E> elementsToAdd) {
            boolean modified = false;
            for (E element : elementsToAdd) {
                modified |= this.add(element);
            }
            return modified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmutableHashSet<E>
    extends HashSet<E> {
        transient Integer cachedHashCode;
        static final long serialVersionUID = 1241522570505539952L;

        ImmutableHashSet(E ... elements) {
            super(elements.length * 2);
            for (E element : elements) {
                super.add(element);
            }
        }

        ImmutableHashSet(Collection<E> elements) {
            super(elements.size() * 2);
            for (E element : elements) {
                super.add(element);
            }
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.unmodifiableIterator(super.iterator());
        }

        @Override
        public int hashCode() {
            if (this.cachedHashCode == null) {
                this.cachedHashCode = super.hashCode();
            }
            return this.cachedHashCode;
        }

        @Override
        public boolean add(E o) {
            throw ImmutableHashSet.up();
        }

        @Override
        public boolean remove(Object o) {
            throw ImmutableHashSet.up();
        }

        @Override
        public void clear() {
            throw ImmutableHashSet.up();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw ImmutableHashSet.up();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw ImmutableHashSet.up();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw ImmutableHashSet.up();
        }

        private static UnsupportedOperationException up() {
            return new UnsupportedOperationException();
        }
    }
}

