/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.AbstractMultisetEntry;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class StandardMultimap<K, V>
implements Multimap<K, V>,
Serializable {
    private final Map<K, Collection<V>> map;
    private int totalSize;
    private volatile transient KeySet keySet;
    private volatile transient Multiset<K> multiset;
    private volatile transient Collection<V> values;
    private volatile transient Collection<Map.Entry<K, V>> entries;
    private volatile transient Map<K, Collection<V>> asMap;
    private static final long serialVersionUID = -2014783599408314531L;

    protected StandardMultimap(Map<K, Collection<V>> map) {
        Preconditions.checkArgument(map.isEmpty());
        this.map = map;
    }

    abstract Collection<V> createCollection();

    Collection<V> createCollection(@Nullable K key) {
        return this.createCollection();
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        for (Collection<V> collection : this.map.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        Collection<V> collection = this.map.get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public boolean put(@Nullable K key, @Nullable V value) {
        Collection<V> collection = this.getOrCreateCollection(key);
        if (collection.add(value)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    private Collection<V> getOrCreateCollection(K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
            this.map.put(key, collection);
        }
        return collection;
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            return false;
        }
        boolean changed = collection.remove(value);
        if (changed) {
            --this.totalSize;
            if (collection.isEmpty()) {
                this.map.remove(key);
            }
        }
        return changed;
    }

    @Override
    public void putAll(@Nullable K key, Iterable<? extends V> values) {
        if (!values.iterator().hasNext()) {
            return;
        }
        Collection<V> collection = this.getOrCreateCollection(key);
        int oldSize = collection.size();
        if (values instanceof Collection) {
            Collection c = (Collection)values;
            collection.addAll(c);
        } else {
            for (V value : values) {
                collection.add(value);
            }
        }
        this.totalSize += collection.size() - oldSize;
    }

    @Override
    public void putAll(Multimap<? extends K, ? extends V> multimap) {
        for (Map.Entry<K, V> entry : multimap.entries()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Collection<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
        Iterator<V> iterator = values.iterator();
        if (!iterator.hasNext()) {
            return this.removeAll(key);
        }
        Collection<V> collection = this.getOrCreateCollection(key);
        Collection<V> oldValues = this.createCollection();
        oldValues.addAll(collection);
        this.totalSize -= collection.size();
        collection.clear();
        while (iterator.hasNext()) {
            collection.add(iterator.next());
            ++this.totalSize;
        }
        return oldValues;
    }

    @Override
    public Collection<V> removeAll(@Nullable Object key) {
        Collection<V> collection = this.map.remove(key);
        Collection<V> output = this.createCollection();
        if (collection != null) {
            output.addAll(collection);
            this.totalSize -= collection.size();
            collection.clear();
        }
        return output;
    }

    @Override
    public void clear() {
        for (Collection<V> collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.totalSize = 0;
    }

    @Override
    public Collection<V> get(@Nullable K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
        }
        return this.wrapCollection(key, collection);
    }

    private Collection<V> wrapCollection(@Nullable K key, Collection<V> collection) {
        if (collection instanceof SortedSet) {
            return new WrappedSortedSet(key, (SortedSet)collection, null);
        }
        if (collection instanceof Set) {
            return new WrappedSet(key, (Set)collection);
        }
        if (collection instanceof List) {
            return this.wrapList(key, (List)collection, null);
        }
        return new WrappedCollection(key, collection, null);
    }

    private List<V> wrapList(@Nullable K key, List<V> list, @Nullable WrappedCollection ancestor) {
        return list instanceof RandomAccess ? new RandomAccessWrappedList(key, list, ancestor) : new WrappedList(key, list, ancestor);
    }

    private Iterator<V> iteratorOrListIterator(Collection<V> collection) {
        return collection instanceof List ? ((List)collection).listIterator() : collection.iterator();
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = this.map instanceof SortedMap ? new SortedKeySet((SortedMap)this.map) : new KeySet(this.map);
        }
        return this.keySet;
    }

    @Override
    public Multiset<K> keys() {
        if (this.multiset == null) {
            this.multiset = new MultisetView();
        }
        return this.multiset;
    }

    private int removeValuesForKey(Object key) {
        int count = 0;
        Collection<V> collection = this.map.remove(key);
        if (collection != null) {
            count = collection.size();
            collection.clear();
            this.totalSize -= count;
        }
        return count;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return StandardMultimap.this.totalSize;
                }

                @Override
                public void clear() {
                    StandardMultimap.this.clear();
                }

                @Override
                public boolean contains(Object value) {
                    return StandardMultimap.this.containsValue(value);
                }
            };
        }
        return this.values;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        if (this.entries == null) {
            this.entries = this instanceof SetMultimap ? new EntrySet() : new Entries();
        }
        return this.entries;
    }

    Iterator<Map.Entry<K, V>> createEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        if (this.asMap == null) {
            this.asMap = new AbstractMap<K, Collection<V>>(){
                volatile Set<Map.Entry<K, Collection<V>>> entrySet;

                @Override
                public Set<Map.Entry<K, Collection<V>>> entrySet() {
                    if (this.entrySet == null) {
                        this.entrySet = new AsMapEntries();
                    }
                    return this.entrySet;
                }

                @Override
                public void clear() {
                    StandardMultimap.this.clear();
                }

                @Override
                public boolean containsKey(Object key) {
                    return StandardMultimap.this.map.containsKey(key);
                }

                @Override
                public Collection<V> get(Object key) {
                    Collection collection = (Collection)StandardMultimap.this.map.get(key);
                    if (collection == null) {
                        return null;
                    }
                    Object k = key;
                    return StandardMultimap.this.wrapCollection(k, collection);
                }

                @Override
                public Collection<V> remove(Object key) {
                    Collection collection = StandardMultimap.this.removeAll(key);
                    return collection.isEmpty() ? null : collection;
                }

                @Override
                public boolean equals(Object other) {
                    return ((Object)StandardMultimap.this.map).equals(other);
                }

                @Override
                public int hashCode() {
                    return ((Object)StandardMultimap.this.map).hashCode();
                }

                @Override
                public String toString() {
                    return StandardMultimap.this.map.toString();
                }
            };
        }
        return this.asMap;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Multimap)) {
            return false;
        }
        Multimap otherMultimap = (Multimap)other;
        return ((Object)this.map).equals(otherMultimap.asMap());
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsMapIterator
    implements Iterator<Map.Entry<K, Collection<V>>> {
        final Iterator<Map.Entry<K, Collection<V>>> delegateIterator;
        Collection<V> collection;

        private AsMapIterator() {
            this.delegateIterator = StandardMultimap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegateIterator.hasNext();
        }

        @Override
        public Map.Entry<K, Collection<V>> next() {
            Map.Entry entry = this.delegateIterator.next();
            Object key = entry.getKey();
            this.collection = entry.getValue();
            return Maps.immutableEntry(key, StandardMultimap.this.wrapCollection(key, this.collection));
        }

        @Override
        public void remove() {
            this.delegateIterator.remove();
            StandardMultimap.this.totalSize -= this.collection.size();
            this.collection.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsMapEntries
    extends AbstractSet<Map.Entry<K, Collection<V>>> {
        private AsMapEntries() {
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            return new AsMapIterator();
        }

        @Override
        public int size() {
            return StandardMultimap.this.map.size();
        }

        @Override
        public void clear() {
            StandardMultimap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return entry.getValue() != null && entry.getValue().equals(StandardMultimap.this.map.get(entry.getKey()));
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return this.contains(entry) && StandardMultimap.this.removeValuesForKey(entry.getKey()) > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends Entries
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Set)) {
                return false;
            }
            Set otherSet = (Set)other;
            return StandardMultimap.this.totalSize == otherSet.size() && this.containsAll(otherSet);
        }

        @Override
        public int hashCode() {
            int hash = 0;
            for (Map.Entry entry : this) {
                hash += ((Object)entry).hashCode();
            }
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListMapEntry
    extends AbstractMapEntry<K, V> {
        final K key;
        V value;
        final ListIterator<V> iterator;

        ListMapEntry(K key, ListIterator<V> iterator) {
            this.key = key;
            this.value = iterator.next();
            this.iterator = iterator;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            Object oldValue = this.value;
            this.iterator.set(newValue);
            this.value = newValue;
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Map.Entry<K, Collection<V>>> keyIterator;
        K key;
        Collection<V> collection;
        Iterator<V> valueIterator;

        EntryIterator() {
            this.keyIterator = StandardMultimap.this.map.entrySet().iterator();
            if (this.keyIterator.hasNext()) {
                this.findValueIteratorAndKey();
            } else {
                this.valueIterator = Iterators.emptyIterator();
            }
        }

        void findValueIteratorAndKey() {
            Map.Entry entry = this.keyIterator.next();
            this.key = entry.getKey();
            this.collection = entry.getValue();
            this.valueIterator = StandardMultimap.this.iteratorOrListIterator(this.collection);
        }

        @Override
        public boolean hasNext() {
            return this.valueIterator.hasNext() || this.keyIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.valueIterator.hasNext()) {
                this.findValueIteratorAndKey();
            }
            return this.valueIterator instanceof ListIterator ? new ListMapEntry(this.key, (ListIterator)this.valueIterator) : Maps.immutableEntry(this.key, this.valueIterator.next());
        }

        @Override
        public void remove() {
            this.valueIterator.remove();
            if (this.collection.isEmpty()) {
                this.keyIterator.remove();
            }
            StandardMultimap.this.totalSize--;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entries
    extends AbstractCollection<Map.Entry<K, V>> {
        private Entries() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return StandardMultimap.this.createEntryIterator();
        }

        @Override
        public int size() {
            return StandardMultimap.this.totalSize;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return StandardMultimap.this.containsEntry(entry.getKey(), entry.getValue());
        }

        @Override
        public void clear() {
            StandardMultimap.this.clear();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return StandardMultimap.this.remove(entry.getKey(), entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    implements Iterator<V> {
        final Iterator<Map.Entry<K, V>> entryIterator;

        private ValueIterator() {
            this.entryIterator = StandardMultimap.this.createEntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public V next() {
            return this.entryIterator.next().getValue();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetKeyIterator
    implements Iterator<K> {
        final Iterator<Map.Entry<K, V>> entryIterator;

        private MultisetKeyIterator() {
            this.entryIterator = StandardMultimap.this.entries().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public K next() {
            return this.entryIterator.next().getKey();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetEntry
    extends AbstractMultisetEntry<K> {
        final Map.Entry<K, Collection<V>> entry;

        public MultisetEntry(Map.Entry<K, Collection<V>> entry) {
            this.entry = entry;
        }

        @Override
        public K getElement() {
            this.validate();
            return this.entry.getKey();
        }

        @Override
        public int getCount() {
            this.validate();
            return this.entry.getValue().size();
        }

        private void validate() {
            if (this.entry.getValue().isEmpty()) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetEntryIterator
    implements Iterator<Multiset.Entry<K>> {
        final Iterator<Map.Entry<K, Collection<V>>> asMapIterator;

        private MultisetEntryIterator() {
            this.asMapIterator = StandardMultimap.this.asMap().entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.asMapIterator.hasNext();
        }

        @Override
        public Multiset.Entry<K> next() {
            return new MultisetEntry(this.asMapIterator.next());
        }

        @Override
        public void remove() {
            this.asMapIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetView
    extends AbstractMultiset<K> {
        volatile transient Set<Multiset.Entry<K>> entrySet;

        private MultisetView() {
        }

        @Override
        public int remove(Object key, int occurrences) {
            Collection collection = (Collection)StandardMultimap.this.map.get(key);
            if (collection == null) {
                return 0;
            }
            int count = collection.size();
            if (occurrences >= count) {
                return StandardMultimap.this.removeValuesForKey(key);
            }
            Iterator iterator = collection.iterator();
            for (int i = 0; i < occurrences; ++i) {
                iterator.next();
                iterator.remove();
            }
            StandardMultimap.this.totalSize -= occurrences;
            return occurrences;
        }

        @Override
        public Set<K> elementSet() {
            return StandardMultimap.this.keySet();
        }

        @Override
        public Set<Multiset.Entry<K>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new AbstractSet<Multiset.Entry<K>>(){

                    @Override
                    public Iterator<Multiset.Entry<K>> iterator() {
                        return new MultisetEntryIterator();
                    }

                    @Override
                    public int size() {
                        return StandardMultimap.this.map.size();
                    }

                    @Override
                    public boolean contains(Object o) {
                        if (!(o instanceof Multiset.Entry)) {
                            return false;
                        }
                        Multiset.Entry entry = (Multiset.Entry)o;
                        Collection collection = (Collection)StandardMultimap.this.map.get(entry.getElement());
                        return collection != null && collection.size() == entry.getCount();
                    }

                    @Override
                    public void clear() {
                        StandardMultimap.this.clear();
                    }

                    @Override
                    public boolean remove(Object o) {
                        return this.contains(o) && StandardMultimap.this.removeValuesForKey(((Multiset.Entry)o).getElement()) > 0;
                    }
                };
            }
            return this.entrySet;
        }

        @Override
        public Iterator<K> iterator() {
            return new MultisetKeyIterator();
        }

        @Override
        public int count(Object key) {
            Collection collection = (Collection)StandardMultimap.this.map.get(key);
            return collection == null ? 0 : collection.size();
        }

        @Override
        public int removeAllOccurrences(Object key) {
            return StandardMultimap.this.removeValuesForKey(key);
        }

        @Override
        public int size() {
            return StandardMultimap.this.totalSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortedKeySet
    extends KeySet
    implements SortedSet<K> {
        SortedKeySet(SortedMap<K, Collection<V>> subMap) {
            super(subMap);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)this.subMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        public K first() {
            return this.sortedMap().firstKey();
        }

        @Override
        public SortedSet<K> headSet(K toElement) {
            return new SortedKeySet(this.sortedMap().headMap(toElement));
        }

        @Override
        public K last() {
            return this.sortedMap().lastKey();
        }

        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            return new SortedKeySet(this.sortedMap().subMap(fromElement, toElement));
        }

        @Override
        public SortedSet<K> tailSet(K fromElement) {
            return new SortedKeySet(this.sortedMap().tailMap(fromElement));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        final Map<K, Collection<V>> subMap;

        KeySet(Map<K, Collection<V>> subMap) {
            this.subMap = subMap;
        }

        @Override
        public int size() {
            return this.subMap.size();
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                final Iterator<Map.Entry<K, Collection<V>>> entryIterator;
                Map.Entry<K, Collection<V>> entry;
                {
                    this.entryIterator = KeySet.this.subMap.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entryIterator.hasNext();
                }

                @Override
                public K next() {
                    this.entry = this.entryIterator.next();
                    return this.entry.getKey();
                }

                @Override
                public void remove() {
                    this.entryIterator.remove();
                    StandardMultimap.this.totalSize -= this.entry.getValue().size();
                    this.entry.getValue().clear();
                }
            };
        }

        @Override
        public boolean contains(Object key) {
            return this.subMap.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            int count = 0;
            Collection collection = this.subMap.remove(key);
            if (collection != null) {
                count = collection.size();
                collection.clear();
                StandardMultimap.this.totalSize -= count;
            }
            return count > 0;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.subMap.keySet().containsAll(c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RandomAccessWrappedList
    extends WrappedList
    implements RandomAccess {
        RandomAccessWrappedList(K key, @Nullable List<V> delegate, WrappedCollection ancestor) {
            super(key, delegate, ancestor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrappedList
    extends WrappedCollection
    implements List<V> {
        WrappedList(K key, @Nullable List<V> delegate, WrappedCollection ancestor) {
            super(key, delegate, ancestor);
        }

        List<V> getListDelegate() {
            return (List)this.getDelegate();
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> c) {
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.getListDelegate().addAll(index, c);
            if (changed) {
                int newSize = this.getDelegate().size();
                StandardMultimap.this.totalSize += newSize - oldSize;
                if (oldSize == 0) {
                    this.addToMap();
                }
            }
            return changed;
        }

        @Override
        public V get(int index) {
            this.refreshIfEmpty();
            return this.getListDelegate().get(index);
        }

        @Override
        public V set(int index, V element) {
            this.refreshIfEmpty();
            return this.getListDelegate().set(index, element);
        }

        @Override
        public void add(int index, V element) {
            this.refreshIfEmpty();
            boolean wasEmpty = this.getListDelegate().isEmpty();
            this.getListDelegate().add(index, element);
            StandardMultimap.this.totalSize++;
            if (wasEmpty) {
                this.addToMap();
            }
        }

        @Override
        public V remove(int index) {
            this.refreshIfEmpty();
            Object value = this.getListDelegate().remove(index);
            StandardMultimap.this.totalSize--;
            this.removeIfEmpty();
            return value;
        }

        @Override
        public int indexOf(Object o) {
            this.refreshIfEmpty();
            return this.getListDelegate().indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            this.refreshIfEmpty();
            return this.getListDelegate().lastIndexOf(o);
        }

        @Override
        public ListIterator<V> listIterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator();
        }

        @Override
        public ListIterator<V> listIterator(int index) {
            this.refreshIfEmpty();
            return new WrappedListIterator(index);
        }

        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            this.refreshIfEmpty();
            return StandardMultimap.this.wrapList(this.getKey(), this.getListDelegate().subList(fromIndex, toIndex), this.getAncestor() == null ? this : this.getAncestor());
        }

        /*
         * Signature claims super is com.google.common.collect.StandardMultimap$WrappedCollection.WrappedIterator, not com.google.common.collect.StandardMultimap$WrappedCollection$WrappedIterator - discarding signature.
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class WrappedListIterator
        extends WrappedCollection.WrappedIterator
        implements ListIterator {
            WrappedListIterator() {
            }

            public WrappedListIterator(int index) {
                super(WrappedList.this.getListDelegate().listIterator(index));
            }

            private ListIterator<V> getDelegateListIterator() {
                return (ListIterator)this.getDelegateIterator();
            }

            @Override
            public boolean hasPrevious() {
                return this.getDelegateListIterator().hasPrevious();
            }

            public V previous() {
                return this.getDelegateListIterator().previous();
            }

            @Override
            public int nextIndex() {
                return this.getDelegateListIterator().nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.getDelegateListIterator().previousIndex();
            }

            public void set(V value) {
                this.getDelegateListIterator().set(value);
            }

            public void add(V value) {
                boolean wasEmpty = WrappedList.this.isEmpty();
                this.getDelegateListIterator().add(value);
                StandardMultimap.this.totalSize++;
                if (wasEmpty) {
                    WrappedList.this.addToMap();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrappedSortedSet
    extends WrappedCollection
    implements SortedSet<V> {
        WrappedSortedSet(K key, @Nullable SortedSet<V> delegate, WrappedCollection ancestor) {
            super(key, delegate, ancestor);
        }

        SortedSet<V> getSortedSetDelegate() {
            return (SortedSet)this.getDelegate();
        }

        @Override
        public Comparator<? super V> comparator() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().comparator();
        }

        @Override
        public V first() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().first();
        }

        @Override
        public V last() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().last();
        }

        @Override
        public SortedSet<V> headSet(V toElement) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().headSet(toElement), this.getAncestor() == null ? this : this.getAncestor());
        }

        @Override
        public SortedSet<V> subSet(V fromElement, V toElement) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().subSet(fromElement, toElement), this.getAncestor() == null ? this : this.getAncestor());
        }

        @Override
        public SortedSet<V> tailSet(V fromElement) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().tailSet(fromElement), this.getAncestor() == null ? this : this.getAncestor());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrappedSet
    extends WrappedCollection
    implements Set<V> {
        WrappedSet(K key, Set<V> delegate) {
            super(key, delegate, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrappedCollection
    extends AbstractCollection<V> {
        final K key;
        Collection<V> delegate;
        final WrappedCollection ancestor;
        final Collection<V> originalAncestorDelegate;

        WrappedCollection(K key, @Nullable Collection<V> delegate, WrappedCollection ancestor) {
            this.key = key;
            this.delegate = delegate;
            this.ancestor = ancestor;
            this.originalAncestorDelegate = ancestor == null ? null : ancestor.getDelegate();
        }

        void refreshIfEmpty() {
            Collection newDelegate;
            if (this.ancestor != null) {
                this.ancestor.refreshIfEmpty();
                if (this.ancestor.getDelegate() != this.originalAncestorDelegate) {
                    throw new ConcurrentModificationException();
                }
            } else if (this.delegate.isEmpty() && (newDelegate = (Collection)StandardMultimap.this.map.get(this.key)) != null) {
                this.delegate = newDelegate;
            }
        }

        void removeIfEmpty() {
            if (this.ancestor != null) {
                this.ancestor.removeIfEmpty();
            } else if (this.delegate.isEmpty()) {
                StandardMultimap.this.map.remove(this.key);
            }
        }

        K getKey() {
            return this.key;
        }

        void addToMap() {
            if (this.ancestor != null) {
                this.ancestor.addToMap();
            } else {
                StandardMultimap.this.map.put(this.key, this.delegate);
            }
        }

        @Override
        public int size() {
            this.refreshIfEmpty();
            return this.delegate.size();
        }

        @Override
        public boolean equals(Object other) {
            this.refreshIfEmpty();
            return ((Object)this.delegate).equals(other);
        }

        @Override
        public int hashCode() {
            this.refreshIfEmpty();
            return ((Object)this.delegate).hashCode();
        }

        @Override
        public String toString() {
            this.refreshIfEmpty();
            return this.delegate.toString();
        }

        Collection<V> getDelegate() {
            return this.delegate;
        }

        @Override
        public Iterator<V> iterator() {
            this.refreshIfEmpty();
            return new WrappedIterator();
        }

        @Override
        public boolean add(V value) {
            this.refreshIfEmpty();
            boolean wasEmpty = this.delegate.isEmpty();
            boolean changed = this.delegate.add(value);
            if (changed) {
                StandardMultimap.this.totalSize++;
                if (wasEmpty) {
                    this.addToMap();
                }
            }
            return changed;
        }

        WrappedCollection getAncestor() {
            return this.ancestor;
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.addAll(collection);
            if (changed) {
                int newSize = this.delegate.size();
                StandardMultimap.this.totalSize += newSize - oldSize;
                if (oldSize == 0) {
                    this.addToMap();
                }
            }
            return changed;
        }

        @Override
        public boolean contains(Object o) {
            this.refreshIfEmpty();
            return this.delegate.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            this.refreshIfEmpty();
            return this.delegate.containsAll(c);
        }

        @Override
        public void clear() {
            int oldSize = this.size();
            if (oldSize == 0) {
                return;
            }
            this.delegate.clear();
            StandardMultimap.this.totalSize -= oldSize;
            this.removeIfEmpty();
        }

        @Override
        public boolean remove(Object o) {
            this.refreshIfEmpty();
            boolean changed = this.delegate.remove(o);
            if (changed) {
                StandardMultimap.this.totalSize--;
                this.removeIfEmpty();
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.removeAll(c);
            if (changed) {
                int newSize = this.delegate.size();
                StandardMultimap.this.totalSize += newSize - oldSize;
                this.removeIfEmpty();
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            int oldSize = this.size();
            boolean changed = this.delegate.retainAll(c);
            if (changed) {
                int newSize = this.delegate.size();
                StandardMultimap.this.totalSize += newSize - oldSize;
                this.removeIfEmpty();
            }
            return changed;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WrappedIterator
        implements Iterator<V> {
            final Iterator<V> delegateIterator;
            final Collection<V> originalDelegate;

            WrappedIterator() {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = StandardMultimap.this.iteratorOrListIterator(WrappedCollection.this.delegate);
            }

            WrappedIterator(Iterator<V> delegateIterator) {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = delegateIterator;
            }

            void validateIterator() {
                WrappedCollection.this.refreshIfEmpty();
                if (WrappedCollection.this.delegate != this.originalDelegate) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.validateIterator();
                return this.delegateIterator.hasNext();
            }

            @Override
            public V next() {
                this.validateIterator();
                return this.delegateIterator.next();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                StandardMultimap.this.totalSize--;
                WrappedCollection.this.removeIfEmpty();
            }

            Iterator<V> getDelegateIterator() {
                this.validateIterator();
                return this.delegateIterator;
            }
        }
    }
}

