/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

final class Cookie {
    private final HashMap m_cookieAv;
    private String m_cookieName;
    private String m_cookieValue;

    private void $init$() {
        this.m_cookieAv = new HashMap();
    }

    public void setValue(String key, String value) {
        if ("Comment".equalsIgnoreCase(key) || "Domain".equalsIgnoreCase(key) || "Max-Age".equalsIgnoreCase(key) || "Path".equalsIgnoreCase(key) || "Secure".equalsIgnoreCase(key) || "Version".equalsIgnoreCase(key) || "Expires".equalsIgnoreCase(key)) {
            this.m_cookieAv.put(key, value);
        } else {
            this.m_cookieName = key;
            this.m_cookieValue = value;
        }
    }

    public String getCookieName() {
        return this.m_cookieName;
    }

    public String getCookieValue() {
        return this.m_cookieValue;
    }

    public String getValue(String key) {
        if (key.equalsIgnoreCase(this.m_cookieName)) {
            return this.m_cookieValue;
        }
        return (String)this.m_cookieAv.get(key);
    }

    public void parse(String encodedCookie) {
        StringTokenizer tok = new StringTokenizer(encodedCookie, ";");
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken().trim();
            int eqPos = thisToken.indexOf("=");
            if (eqPos == -1) {
                this.setValue(thisToken, null);
                continue;
            }
            this.setValue(thisToken.substring(0, eqPos), thisToken.substring(eqPos + 1));
        }
    }

    public String toSimpleString() {
        if (this.m_cookieName == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(this.m_cookieName.length() + this.m_cookieValue.length() + 1);
        buffer.append(this.m_cookieName);
        buffer.append("=");
        buffer.append(this.m_cookieValue);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.m_cookieName != null) {
            buffer.append(this.m_cookieName);
            buffer.append("=");
            buffer.append(this.m_cookieValue);
            if (this.m_cookieAv.size() > 0) {
                buffer.append("; ");
            }
        }
        Iterator i = this.m_cookieAv.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            buffer.append(key);
            String value = (String)this.m_cookieAv.get(key);
            if (value != null) {
                buffer.append("=");
                buffer.append(value);
            }
            if (!i.hasNext()) continue;
            buffer.append("; ");
        }
        return buffer.toString();
    }

    Cookie() {
        this.$init$();
    }
}

