/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.BrowserArb;

final class HttpPing {
    private static final int DEFAULT_TIMEOUT = 1500;
    private final ProxyOptions _proxyOptions;
    private final URL _url;
    private final int _timeout;

    public HttpPing(ProxyOptions options, URL url) {
        this(options, url, 1500);
    }

    public HttpPing(ProxyOptions options, URL url, int timeout) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must be >= 0: " + timeout);
        }
        this._proxyOptions = options;
        this._url = url;
        this._timeout = timeout;
    }

    public void ping() throws PingFailedException {
        PingRunnable runnable = new PingRunnable(null);
        this._proxyOptions.doTask(runnable);
        if (runnable.getThrown() != null) {
            throw runnable.getThrown();
        }
    }

    private PingFailedException convertToPingFailedException(IOException ioe, int httpResponseCode, String httpResponseMessage) {
        if (ioe instanceof SocketTimeoutException || httpResponseCode == 408 || httpResponseCode == 504) {
            if ("download.oracle.com".equals(this._url.getHost()) && this._proxyOptions.getProxyExceptions() != null && (this._proxyOptions.getProxyExceptions().toLowerCase().contains("*.oracle.com") || this._proxyOptions.getProxyExceptions().toLowerCase().contains("download.oracle.com"))) {
                return new PingFailedException(BrowserArb.getString(38), BrowserArb.format(30, this._url.getHost()), ioe, httpResponseCode, httpResponseMessage, null);
            }
            return new PingFailedException(BrowserArb.getString(1), BrowserArb.format(31, this._url.getHost()), ioe, httpResponseCode, httpResponseMessage, null);
        }
        if (httpResponseCode == 407) {
            if (this._proxyOptions.getProxyUserName() != null && this._proxyOptions.getProxyUserName().length() > 0 && this._proxyOptions.getUseProxyAuthentication().booleanValue()) {
                return new PingFailedException(BrowserArb.getString(2), BrowserArb.format(29, this._url.getHost()), ioe, httpResponseCode, httpResponseMessage, null);
            }
            return new PingFailedException(BrowserArb.getString(34), BrowserArb.format(18, this._url.getHost()), ioe, httpResponseCode, httpResponseMessage, null);
        }
        return new PingFailedException(BrowserArb.getString(22), BrowserArb.format(37, this._url.getHost()), ioe, httpResponseCode, httpResponseMessage, null);
    }

    static URL ra$_url(HttpPing httpPing) {
        return httpPing._url;
    }

    static int ra$_timeout(HttpPing httpPing) {
        return httpPing._timeout;
    }

    static PingFailedException mav$convertToPingFailedException(HttpPing httpPing, IOException iOException, int n, String string) {
        return httpPing.convertToPingFailedException(iOException, n, string);
    }

    private class PingRunnable
    implements Runnable {
        private PingFailedException _thrown;

        public PingFailedException getThrown() {
            return this._thrown;
        }

        public void run() {
            URLConnection conn = null;
            int responseCode = -1;
            String responseMessage = null;
            try {
                try {
                    conn = HttpPing.ra$_url(HttpPing.this).openConnection();
                    conn.setConnectTimeout(HttpPing.ra$_timeout(HttpPing.this));
                    conn.setReadTimeout(HttpPing.ra$_timeout(HttpPing.this));
                    if (conn instanceof HttpURLConnection) {
                        HttpURLConnection httpConn = (HttpURLConnection)conn;
                        httpConn.setRequestMethod("HEAD");
                        httpConn.setInstanceFollowRedirects(true);
                    }
                    conn.connect();
                    if (conn instanceof HttpURLConnection) {
                        responseCode = ((HttpURLConnection)conn).getResponseCode();
                        responseMessage = ((HttpURLConnection)conn).getResponseMessage();
                        if (responseCode >= 300 && responseCode != 302) {
                            this._thrown = HttpPing.mav$convertToPingFailedException(HttpPing.this, null, responseCode, responseMessage);
                        }
                    }
                }
                catch (IOException ioe) {
                    this._thrown = HttpPing.mav$convertToPingFailedException(HttpPing.this, ioe, responseCode, responseMessage);
                }
            }
            finally {
                if (conn != null && conn instanceof HttpURLConnection) {
                    ((HttpURLConnection)conn).disconnect();
                }
            }
        }

        private PingRunnable() {
        }

        PingRunnable(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public static final class PingFailedException
    extends Exception {
        private final String _details;
        private final int _responseCode;
        private final String _responseMessage;

        private PingFailedException(String summary, String details, Throwable cause, int responseCode, String responseMessage) {
            super(summary, cause);
            this._details = details;
            this._responseCode = responseCode;
            this._responseMessage = responseMessage;
        }

        public String getDetails() {
            return this._details;
        }

        public int getHttpResponseCode() {
            return this._responseCode;
        }

        public String getHttpResponseMessage() {
            return this._responseMessage;
        }

        PingFailedException(String string, String string2, Throwable throwable, int n, String string3, 1 var6_6) {
            this(string, string2, throwable, n, string3);
        }

        public final class 1 {
        }
    }
}

