/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.URLHyperlinkButton;
import oracle.ide.webbrowser.WOCAuthenticator;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.ideimpl.webbrowser.WocPreferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;

public final class OTNAuthPanel
extends JPanel {
    private final GridBagLayout _layout;
    private final MultiLineLabel _hint;
    private final JLabel _lbUserName;
    private final JTextField _tfUserName;
    private final JLabel _lbPassword;
    private final JPasswordField _pfPassword;
    private final JCheckBox _cbRemember;
    private final URLHyperlinkButton _hlSignUp;
    private final URLHyperlinkButton _hlLostPassword;
    private static final String COMPLETE = "complete";

    private void $init$() {
        this._layout = new GridBagLayout();
        this._hint = new MultiLineLabel();
        this._lbUserName = new JLabel();
        this._tfUserName = new JTextField();
        this._lbPassword = new JLabel();
        this._pfPassword = new JPasswordField();
        this._cbRemember = new JCheckBox();
        this._hlSignUp = new URLHyperlinkButton();
        this._hlLostPassword = new URLHyperlinkButton();
    }

    public OTNAuthPanel() {
        this.$init$();
        this._hint.setTextWrapper(WordWrapper.getTextWrapper());
        this._hint.setMinimumRows(1);
        this._hint.setPreferredAspectRatio(10.0f);
        this._hint.setVerticalShrinking(false);
        this._hlSignUp.setURL(URLFactory.newURL((String)"https://profile.oracle.com/jsp/reg/createUser.jsp?act=5&src=1180588&nexturl=http://www.oracle.com/technology/index.html&language=en"));
        this._hlLostPassword.setURL(URLFactory.newURL((String)"http://profile.oracle.com/jsp/reg/LostPassword.jsp"));
        this.resControls();
        this.layoutControls();
        this.installListeners();
    }

    private void resControls() {
        this._hint.setText(BrowserArb.getString(4));
        ResourceUtils.resLabel((JLabel)this._lbUserName, (Component)this._tfUserName, (String)BrowserArb.getString(9));
        ResourceUtils.resLabel((JLabel)this._lbPassword, (Component)this._pfPassword, (String)BrowserArb.getString(24));
        ResourceUtils.resButton((AbstractButton)((Object)this._hlSignUp), (String)BrowserArb.getString(19));
        ResourceUtils.resButton((AbstractButton)((Object)this._hlLostPassword), (String)BrowserArb.getString(7));
        ResourceUtils.resButton((AbstractButton)this._cbRemember, (String)BrowserArb.getString(12));
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this._hint, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this._lbUserName, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._tfUserName, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this._lbPassword, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._pfPassword, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._cbRemember, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 5);
        this.add((Component)((Object)this._hlSignUp), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)((Object)this._hlLostPassword), gbc);
    }

    private void installListeners() {
        1 dl = new 1();
        this._tfUserName.getDocument().addDocumentListener(dl);
        this._pfPassword.getDocument().addDocumentListener(dl);
    }

    private boolean isComplete() {
        return this._tfUserName.getText().trim().length() > 0 && this._pfPassword.getPassword().length > 0;
    }

    public void setLostPasswordUrl(URL lostPasswordUrl) {
        if (lostPasswordUrl == null) {
            throw new NullPointerException("lostPasswordUrl is null");
        }
        this._hlLostPassword.setURL(lostPasswordUrl);
    }

    public void setSignUpUrl(URL signUpUrl) {
        if (signUpUrl == null) {
            throw new NullPointerException("signUpUrl is null");
        }
        this._hlSignUp.setURL(signUpUrl);
    }

    public void setHintText(String hintText) {
        if (hintText == null) {
            throw new NullPointerException("hintText is null");
        }
        this._hint.setText(hintText);
    }

    public PasswordAuthentication runDialog(Component parent, String title) {
        block7: {
            if (title == null) {
                throw new NullPointerException("title is null");
            }
            JEWTDialog jd = JEWTDialog.createDialog((Component)parent, (String)title, (int)7);
            jd.setContent((Component)this);
            if (this._tfUserName.getText().length() > 0) {
                jd.setInitialFocus((Component)this._pfPassword);
            } else {
                jd.setInitialFocus((Component)this._tfUserName);
            }
            this.loadFieldsFromPreferences();
            jd.setOKButtonEnabled(this.isComplete());
            2 pcl = new 2(this, jd);
            try {
                this.addPropertyChangeListener(COMPLETE, pcl);
                if (!jd.runDialog()) break block7;
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(this._tfUserName.getText().trim(), this._pfPassword.getPassword());
                return passwordAuthentication;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.saveFieldsToPreferences();
                this._pfPassword.setText("");
                this._pfPassword.setCaretPosition(0);
                this.removePropertyChangeListener(COMPLETE, pcl);
            }
        }
        return null;
    }

    private void loadFieldsFromPreferences() {
        WocPreferences prefs = WocPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
        this._tfUserName.setText(prefs.getUser());
        char[] data = prefs.getOTNData();
        this._pfPassword.setText(data == null ? "" : new String(data));
        this._cbRemember.setSelected(data != null);
    }

    private void saveFieldsToPreferences() {
        WocPreferences prefs = WocPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
        if (this._cbRemember.isSelected()) {
            prefs.setOTNData(new String(this._pfPassword.getPassword()));
        } else {
            prefs.setOTNData(null);
        }
        prefs.setUser(this._tfUserName.getText());
        try {
            Preferences.getPreferences().save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        WOCAuthenticator woc = new WOCAuthenticator();
        PasswordAuthentication pw = woc.getRememberedAuthentication();
        WOCAuthenticator.AuthenticationToken token = null;
        if (pw != null) {
            token = woc.logIn(pw);
        }
        if (token == null) {
            OTNAuthPanel authPanel = new OTNAuthPanel();
            pw = authPanel.runDialog(null, "Test");
            if (pw == null) {
                MessageDialog.error(null, (Object)"Auth Canceled!", (String)"Canceled", null);
                System.exit(0);
            }
            token = woc.logIn(pw);
        }
        if (token == null) {
            MessageDialog.error(null, (Object)"Auth Failed!", (String)"Failed", null);
            System.exit(0);
        }
        MessageDialog.information(null, (Object)"Auth Success!", (String)"Success", null);
        System.exit(0);
    }

    static boolean mav$isComplete(OTNAuthPanel oTNAuthPanel) {
        return oTNAuthPanel.isComplete();
    }

    final class 1
    implements DocumentListener {
        public void insertUpdate(DocumentEvent de) {
            this.update();
        }

        public void removeUpdate(DocumentEvent de) {
            this.update();
        }

        public void changedUpdate(DocumentEvent de) {
            this.update();
        }

        private void update() {
            boolean complete = OTNAuthPanel.mav$isComplete(OTNAuthPanel.this);
            OTNAuthPanel.this.firePropertyChange(OTNAuthPanel.COMPLETE, complete ^ true, complete);
        }
    }

    final class 2
    implements PropertyChangeListener {
        private final /* synthetic */ JEWTDialog v$jd;
        final /* synthetic */ OTNAuthPanel this$0;

        public void propertyChange(PropertyChangeEvent pce) {
            this.v$jd.setOKButtonEnabled(OTNAuthPanel.mav$isComplete(this.this$0));
        }

        public 2(OTNAuthPanel oTNAuthPanel, JEWTDialog jEWTDialog) {
            this.v$jd = jEWTDialog;
            this.this$0 = oTNAuthPanel;
        }
    }
}

