/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ProxySettingsArb;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.HttpPing;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.icons.OracleIcons;

public final class ProxySettingsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_useProxy;
    private JTextField textfield_proxyHost;
    private WholeNumberField textfield_proxyPort;
    private JTextField textfield_proxyExceptions;
    private JCheckBox checkbox_useProxyAuth;
    private JLabel label_proxyUserName;
    private JTextField textfield_proxyUserName;
    private JLabel label_proxyPassword;
    private JPasswordField textfield_proxyPassword;
    private boolean _suppressUseProxy;
    private JButton _testProxy;
    private JLabel _testProxyStatus;
    private Thread _testThread;

    public ProxySettingsPanel() {
        this(false);
    }

    public ProxySettingsPanel(boolean suppressUseProxy) {
        this._suppressUseProxy = suppressUseProxy;
        this.initializeComponent();
    }

    private void initializeComponent() {
        String useProxyText = ProxySettingsArb.getString((int)4);
        this.checkbox_useProxy = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_useProxy, (String)useProxyText);
        String proxyHostText = ProxySettingsArb.getString((int)7);
        String proxyPortText = ProxySettingsArb.getString((int)2);
        String proxyExceptionsText = ProxySettingsArb.getString((int)6);
        String exceptionsHintText = ProxySettingsArb.getString((int)1);
        JLabel label_proxyHost = new JLabel();
        JLabel label_proxyPort = new JLabel();
        JLabel label_proxyExceptions = new JLabel();
        JMultiLineLabel label_exceptionsHint = new JMultiLineLabel(exceptionsHintText);
        label_exceptionsHint.setMinimumRows(4);
        this.textfield_proxyHost = new JTextField();
        this.textfield_proxyPort = new WholeNumberField(8);
        this.textfield_proxyExceptions = new JTextField();
        ResourceUtils.resLabel((JLabel)label_proxyHost, (Component)this.textfield_proxyHost, (String)proxyHostText);
        ResourceUtils.resLabel((JLabel)label_proxyPort, (Component)this.textfield_proxyPort, (String)proxyPortText);
        ResourceUtils.resLabel((JLabel)label_proxyExceptions, (Component)this.textfield_proxyExceptions, (String)proxyExceptionsText);
        String useProxyAuthText = ProxySettingsArb.getString((int)0);
        this.checkbox_useProxyAuth = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_useProxyAuth, (String)useProxyAuthText);
        String proxyUserNameText = ProxySettingsArb.getString((int)3);
        String proxyPasswordText = ProxySettingsArb.getString((int)5);
        this.label_proxyUserName = new JLabel();
        this.label_proxyPassword = new JLabel();
        this.textfield_proxyUserName = new JTextField();
        this.textfield_proxyPassword = new JPasswordField();
        ResourceUtils.resLabel((JLabel)this.label_proxyUserName, (Component)this.textfield_proxyUserName, (String)proxyUserNameText);
        ResourceUtils.resLabel((JLabel)this.label_proxyPassword, (Component)this.textfield_proxyPassword, (String)proxyPasswordText);
        Component[] dependents = new Component[]{label_proxyHost, this.textfield_proxyHost, label_proxyPort, this.textfield_proxyPort, label_proxyExceptions, this.textfield_proxyExceptions, label_exceptionsHint, this.checkbox_useProxyAuth};
        new ItemSelectableTracker((ItemSelectable)this.checkbox_useProxy, dependents);
        1 listener = new 1();
        this.checkbox_useProxy.addItemListener(listener);
        this.checkbox_useProxyAuth.addItemListener(listener);
        this.setLayout(new GridBagLayout());
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets indentedInsets = new Insets(2, 29, 2, 5);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        if (!this._suppressUseProxy) {
            this.add(this.checkbox_useProxy, constraints);
        }
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(label_proxyHost, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.textfield_proxyHost, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(label_proxyPort, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add((Component)this.textfield_proxyPort, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(label_proxyExceptions, constraints);
        constraints = new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.textfield_proxyExceptions, constraints);
        constraints = new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add((Component)label_exceptionsHint, constraints);
        constraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 0, new Insets(15, 29, 2, 5), 0, 0);
        this.add(this.checkbox_useProxyAuth, constraints);
        JPanel authPanel = new JPanel();
        authPanel.setLayout(new GridBagLayout());
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        authPanel.add((Component)this.label_proxyUserName, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        authPanel.add((Component)this.textfield_proxyUserName, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        authPanel.add((Component)this.label_proxyPassword, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        authPanel.add((Component)this.textfield_proxyPassword, constraints);
        constraints = new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 0), 0, 0);
        this.add(authPanel, constraints);
        this._testProxy = new JButton();
        this._testProxyStatus = new JLabel();
        JPanel testProxyPanel = new JPanel();
        testProxyPanel.setLayout(new BorderLayout(5, 0));
        testProxyPanel.add((Component)this._testProxy, "West");
        testProxyPanel.add((Component)this._testProxyStatus, "Center");
        constraints = new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 2, new Insets(15, 24, 0, 0), 0, 0);
        this.add(testProxyPanel, constraints);
        ResourceUtils.resButton((AbstractButton)this._testProxy, (String)BrowserArb.getString(13));
        this._testProxy.addActionListener(new 2());
        1ChangeListener cl = new 1ChangeListener();
        this.checkbox_useProxy.addActionListener(cl);
        this.checkbox_useProxyAuth.addActionListener(cl);
        this.textfield_proxyExceptions.getDocument().addDocumentListener(cl);
        this.textfield_proxyHost.getDocument().addDocumentListener(cl);
        this.textfield_proxyPassword.getDocument().addDocumentListener(cl);
        this.textfield_proxyPort.getDocument().addDocumentListener(cl);
        this.textfield_proxyUserName.getDocument().addDocumentListener(cl);
        this.updateProxyAuthFields();
    }

    public void setHost(String host) {
        this.textfield_proxyHost.setText(host);
    }

    public void setPort(String port) {
        this.textfield_proxyPort.setText(port);
    }

    public void setExceptions(String exceptions) {
        this.textfield_proxyExceptions.setText(exceptions);
    }

    public void setUseProxy(boolean useProxy) {
        this.checkbox_useProxy.setSelected(useProxy);
    }

    public void setUseProxyAuthentication(boolean useProxyAuthentication) {
        this.checkbox_useProxyAuth.setSelected(useProxyAuthentication);
    }

    public void setUserName(String userName) {
        this.textfield_proxyUserName.setText(userName);
    }

    public void setPassword(String password) {
        this.textfield_proxyPassword.setText(password);
    }

    public String getHost() {
        return this.textfield_proxyHost.getText();
    }

    public String getPort() {
        try {
            int value = this.textfield_proxyPort.getValue();
            if (value <= 65535) {
                String string = Integer.toString(this.textfield_proxyPort.getValue());
                return string;
            }
            this.textfield_proxyPort.setText("0");
            String string = "";
            return string;
        }
        catch (RuntimeException e) {
            String string = "";
            return string;
        }
    }

    public String getExceptions() {
        return this.textfield_proxyExceptions.getText();
    }

    public boolean getUseProxy() {
        return this.checkbox_useProxy.isSelected();
    }

    public boolean getUseProxyAuthentication() {
        return this.checkbox_useProxyAuth.isSelected();
    }

    public String getUserName() {
        return this.textfield_proxyUserName.getText();
    }

    public String getPassword() {
        return new String(this.textfield_proxyPassword.getPassword());
    }

    public void setProxyOptions(ProxyOptions proxyOptions) {
        this.setHost(proxyOptions.getProxyHost());
        this.setPort(proxyOptions.getProxyPort());
        this.setUseProxy(ProxySettingsPanel.valueOf(proxyOptions.getUseProxy()));
        this.setExceptions(proxyOptions.getProxyExceptions());
        this.setUseProxyAuthentication(ProxySettingsPanel.valueOf(proxyOptions.getUseProxyAuthentication()));
        this.setUserName(proxyOptions.getProxyUserName());
        this.setPassword(new String(proxyOptions.getProxyPassword()));
    }

    private static boolean valueOf(Boolean b) {
        return b == null ? false : b;
    }

    public ProxyOptions getProxyOptions() {
        ProxyOptions po = new ProxyOptions();
        po.setProxyHost(this.getHost());
        po.setProxyPort(this.getPort());
        po.setProxyExceptions(this.getExceptions());
        po.setUseProxy(this.getUseProxy());
        po.setUseProxyAuthentication(this.getUseProxyAuthentication());
        po.setProxyUserName(this.getUserName());
        po.setProxyPassword(this.getPassword());
        return po;
    }

    private void updateProxyAuthFields() {
        boolean enabled = this.checkbox_useProxy.isSelected() && this.checkbox_useProxyAuth.isSelected();
        this.label_proxyUserName.setEnabled(enabled);
        this.label_proxyPassword.setEnabled(enabled);
        this.textfield_proxyUserName.setEnabled(enabled);
        this.textfield_proxyPassword.setEnabled(enabled);
        this._testProxy.setEnabled(this.checkbox_useProxy.isSelected());
    }

    public void onEntry(TraversableContext tc) {
        ProxyOptions proxyOptions = this.findProxyOptions(tc);
        Boolean useProxyBoolean = proxyOptions.getUseProxy();
        boolean useProxy = useProxyBoolean != null ? useProxyBoolean : false;
        String proxyHost = proxyOptions.getProxyHost();
        String proxyPort = proxyOptions.getProxyPort();
        String proxyExceptions = proxyOptions.getProxyExceptions();
        Boolean useProxyAuthBoolean = proxyOptions.getUseProxyAuthentication();
        boolean useProxyAuth = useProxyAuthBoolean != null ? useProxyAuthBoolean : false;
        String proxyUserName = proxyOptions.getProxyUserName();
        String proxyPassword = proxyOptions.getProxyPassword();
        this.setHost(proxyHost);
        this.setPort(proxyPort);
        this.setExceptions(proxyExceptions);
        this.setUseProxy(useProxy);
        this.setUseProxyAuthentication(useProxyAuth);
        this.setUserName(proxyUserName);
        this.setPassword(proxyPassword);
        this.setProxyTestStatus(ProxyTestStatus.NOT_STARTED);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ProxyOptions proxyOptions = this.findProxyOptions(tc);
        boolean useProxy = this.getUseProxy();
        String proxyHost = this.getHost();
        String proxyExceptions = this.getExceptions();
        String proxyPort = this.getPort();
        boolean useProxyAuth = this.getUseProxyAuthentication();
        String proxyUserName = this.getUserName();
        String proxyPassword = this.getPassword();
        proxyOptions.setUseProxy(useProxy ? Boolean.TRUE : Boolean.FALSE);
        proxyOptions.setProxyHost(proxyHost);
        proxyOptions.setProxyExceptions(proxyExceptions);
        proxyOptions.setProxyPort(proxyPort);
        proxyOptions.setUseProxyAuthentication(useProxyAuth);
        proxyOptions.setProxyUserName(proxyUserName);
        proxyOptions.setProxyPassword(proxyPassword);
        if (this._testThread != null) {
            this._testThread.interrupt();
            this.setProxyTestStatus(ProxyTestStatus.NOT_STARTED);
        }
    }

    private ProxyOptions findProxyOptions(TraversableContext tc) {
        return ProxyOptions.getInstance(tc.getPropertyStorage());
    }

    private void setProxyTestProgress(URL url) {
        3 r = new 3(this, url);
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void setProxyTestStatus(ProxyTestStatus status) {
        4 r = new 4(this, status);
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void resetProxyTest() {
        if (this._testThread != null) {
            this._testThread.interrupt();
            this.setProxyTestStatus(ProxyTestStatus.NOT_STARTED);
        }
    }

    private void startProxyTest() {
        ProxyOptions options = this.getProxyOptions();
        this.setProxyTestStatus(ProxyTestStatus.TESTING);
        5 testRunnable = new 5(this, options);
        this._testThread = new Thread((Runnable)testRunnable, BrowserArb.getString(10));
        this._testThread.setPriority(1);
        this._testThread.start();
    }

    private void displayProxyTestFailure(HttpPing.PingFailedException failure) {
        6 r = new 6(this, failure);
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void displayProxyTestDetails(Component parent, HttpPing.PingFailedException failure) {
        JTextArea a = new JTextArea();
        a.setLineWrap(true);
        a.setWrapStyleWord(true);
        a.setRows(22);
        a.setColumns(70);
        a.setEditable(false);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (failure.getHttpResponseCode() == -1) {
            sw.append(BrowserArb.getString(6));
        } else {
            sw.append(BrowserArb.format(15, String.valueOf(failure.getHttpResponseCode()) + " " + failure.getHttpResponseMessage()));
        }
        sw.append("\n\n");
        if (failure.getCause() != null) {
            failure.getCause().printStackTrace(pw);
        }
        pw.close();
        a.setText(sw.toString());
        a.setCaretPosition(0);
        JEWTDialog jd = JEWTDialog.createDialog((Component)parent, (String)BrowserArb.getString(5), (int)16);
        jd.setContent((Component)new JScrollPane(a));
        jd.runDialog();
    }

    public void apply(ApplyEvent e) {
        this.resetProxyTest();
    }

    public void cancel(ApplyEvent e) {
        this.resetProxyTest();
    }

    static void mav$resetProxyTest(ProxySettingsPanel proxySettingsPanel) {
        proxySettingsPanel.resetProxyTest();
    }

    static void mav$setProxyTestProgress(ProxySettingsPanel proxySettingsPanel, URL uRL) {
        proxySettingsPanel.setProxyTestProgress(uRL);
    }

    static void mav$setProxyTestStatus(ProxySettingsPanel proxySettingsPanel, ProxyTestStatus proxyTestStatus) {
        proxySettingsPanel.setProxyTestStatus(proxyTestStatus);
    }

    static void mav$displayProxyTestFailure(ProxySettingsPanel proxySettingsPanel, HttpPing.PingFailedException pingFailedException) {
        proxySettingsPanel.displayProxyTestFailure(pingFailedException);
    }

    static JLabel ra$_testProxyStatus(ProxySettingsPanel proxySettingsPanel) {
        return proxySettingsPanel._testProxyStatus;
    }

    static JButton ra$_testProxy(ProxySettingsPanel proxySettingsPanel) {
        return proxySettingsPanel._testProxy;
    }

    static JCheckBox ra$checkbox_useProxy(ProxySettingsPanel proxySettingsPanel) {
        return proxySettingsPanel.checkbox_useProxy;
    }

    static void mav$updateProxyAuthFields(ProxySettingsPanel proxySettingsPanel) {
        proxySettingsPanel.updateProxyAuthFields();
    }

    static void mav$startProxyTest(ProxySettingsPanel proxySettingsPanel) {
        proxySettingsPanel.startProxyTest();
    }

    static void mav$displayProxyTestDetails(ProxySettingsPanel proxySettingsPanel, Component component, HttpPing.PingFailedException pingFailedException) {
        proxySettingsPanel.displayProxyTestDetails(component, pingFailedException);
    }

    final class 1
    implements ItemListener {
        public final void itemStateChanged(ItemEvent event) {
            ProxySettingsPanel.mav$updateProxyAuthFields(ProxySettingsPanel.this);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            ProxySettingsPanel.mav$startProxyTest(ProxySettingsPanel.this);
        }
    }

    class 1ChangeListener
    implements ActionListener,
    DocumentListener {
        public void actionPerformed(ActionEvent e) {
            ProxySettingsPanel.mav$resetProxyTest(ProxySettingsPanel.this);
        }

        public void insertUpdate(DocumentEvent e) {
            ProxySettingsPanel.mav$resetProxyTest(ProxySettingsPanel.this);
        }

        public void removeUpdate(DocumentEvent e) {
            ProxySettingsPanel.mav$resetProxyTest(ProxySettingsPanel.this);
        }

        public void changedUpdate(DocumentEvent e) {
            ProxySettingsPanel.mav$resetProxyTest(ProxySettingsPanel.this);
        }

        1ChangeListener() {
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ URL v$url;
        final /* synthetic */ ProxySettingsPanel this$0;

        public void run() {
            ProxySettingsPanel.ra$_testProxyStatus(this.this$0).setText(BrowserArb.format(21, this.v$url.getProtocol(), this.v$url.getHost()));
        }

        public 3(ProxySettingsPanel proxySettingsPanel, URL uRL) {
            this.v$url = uRL;
            this.this$0 = proxySettingsPanel;
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ ProxyTestStatus v$status;
        final /* synthetic */ ProxySettingsPanel this$0;

        public void run() {
            if (this.v$status == ProxyTestStatus.NOT_STARTED) {
                ProxySettingsPanel.ra$_testProxyStatus(this.this$0).setVisible(false);
                ProxySettingsPanel.ra$_testProxy(this.this$0).setToolTipText(null);
            } else {
                Icon icon = null;
                String label = null;
                String buttonToolTip = null;
                switch (1.$sm$oracle$ide$webbrowser$ProxySettingsPanel$ProxyTestStatus[this.v$status.ordinal()]) {
                    case 1: {
                        icon = OracleIcons.getIcon((String)"throbber.gif");
                        label = BrowserArb.getString(20);
                        break;
                    }
                    case 2: {
                        icon = OracleIcons.getIcon((String)"check.png");
                        label = BrowserArb.getString(33);
                        buttonToolTip = BrowserArb.getString(23);
                        break;
                    }
                    case 3: {
                        icon = OracleIcons.getIcon((String)"error.png");
                        label = BrowserArb.getString(17);
                        buttonToolTip = BrowserArb.getString(14);
                        break;
                    }
                }
                ProxySettingsPanel.ra$_testProxyStatus(this.this$0).setVisible(true);
                ProxySettingsPanel.ra$_testProxyStatus(this.this$0).setIcon(icon);
                ProxySettingsPanel.ra$_testProxyStatus(this.this$0).setText(label);
                ProxySettingsPanel.ra$_testProxy(this.this$0).setToolTipText(buttonToolTip);
            }
            ProxySettingsPanel.ra$_testProxy(this.this$0).setEnabled(ProxySettingsPanel.ra$checkbox_useProxy(this.this$0).isSelected() && this.v$status != ProxyTestStatus.TESTING);
            this.this$0.revalidate();
        }

        public 4(ProxySettingsPanel proxySettingsPanel, ProxyTestStatus proxyTestStatus) {
            this.v$status = proxyTestStatus;
            this.this$0 = proxySettingsPanel;
        }

        static class 1 {
            static final /* synthetic */ int[] $sm$oracle$ide$webbrowser$ProxySettingsPanel$ProxyTestStatus;

            static {
                int[] nArray = new int[ProxyTestStatus.values().length];
                $sm$oracle$ide$webbrowser$ProxySettingsPanel$ProxyTestStatus = nArray;
                try {
                    nArray[ProxyTestStatus.TESTING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    1.$sm$oracle$ide$webbrowser$ProxySettingsPanel$ProxyTestStatus[ProxyTestStatus.SUCCESSFUL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    1.$sm$oracle$ide$webbrowser$ProxySettingsPanel$ProxyTestStatus[ProxyTestStatus.FAILED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
            }
        }
    }

    final class 5
    implements Runnable {
        private final /* synthetic */ ProxyOptions v$options;
        final /* synthetic */ ProxySettingsPanel this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ProxySettingsPanel proxySettingsPanel = this.this$0;
            synchronized (proxySettingsPanel) {
                ProxyTestStatus newStatus = ProxyTestStatus.NOT_STARTED;
                try {
                    try {
                        URL[] urls;
                        URL[] uRLArray = urls = new URL[]{URLFactory.newURL((String)"http://www.internic.net"), URLFactory.newURL((String)"http://www.oracle.com"), URLFactory.newURL((String)"http://download.oracle.com"), URLFactory.newURL((String)"https://profile.oracle.com/jsp/reg/loginHandler.jsp")};
                        int n = 0;
                        while (n < uRLArray.length) {
                            URL url = uRLArray[n];
                            ProxySettingsPanel.mav$setProxyTestProgress(this.this$0, url);
                            new HttpPing(this.v$options, url).ping();
                            if (Thread.interrupted()) {
                            }
                            ++n;
                        }
                        newStatus = ProxyTestStatus.SUCCESSFUL;
                    }
                    finally {
                        ProxySettingsPanel.mav$setProxyTestStatus(this.this$0, newStatus);
                    }
                }
                catch (HttpPing.PingFailedException failure) {
                    if (Thread.interrupted()) return;
                    newStatus = ProxyTestStatus.FAILED;
                    ProxySettingsPanel.mav$displayProxyTestFailure(this.this$0, failure);
                }
                return;
            }
        }

        public 5(ProxySettingsPanel proxySettingsPanel, ProxyOptions proxyOptions) {
            this.v$options = proxyOptions;
            this.this$0 = proxySettingsPanel;
        }
    }

    final class 6
    implements Runnable {
        private final /* synthetic */ HttpPing.PingFailedException v$failure;
        final /* synthetic */ ProxySettingsPanel this$0;

        public void run() {
            JEWTDialog jd = JEWTDialog.createDialog((Component)((Object)this.this$0), (String)"Test Proxy", (int)16);
            MessagePanel p = new MessagePanel();
            p.setTitle(this.v$failure.getMessage());
            p.setMessageText(this.v$failure.getDetails());
            p.setMessageType(3);
            1 details = new 1(this, "Show details", p, jd);
            p.addHyperAction((Action)details);
            jd.setContent((Component)p);
            jd.runDialog();
        }

        public 6(ProxySettingsPanel proxySettingsPanel, HttpPing.PingFailedException pingFailedException) {
            this.v$failure = pingFailedException;
            this.this$0 = proxySettingsPanel;
        }

        static HttpPing.PingFailedException ra$v$failure(6 var0) {
            return var0.v$failure;
        }

        final class 1
        extends AbstractAction {
            private final /* synthetic */ MessagePanel v$p;
            private final /* synthetic */ JEWTDialog v$jd;
            final /* synthetic */ 6 this$0;

            public void actionPerformed(ActionEvent e) {
                ProxySettingsPanel.mav$displayProxyTestDetails(this.this$0.this$0, (Component)this.v$p, 6.ra$v$failure(this.this$0));
                this.v$jd.closeDialog(false);
            }

            public 1(6 var1_1, String string, MessagePanel messagePanel, JEWTDialog jEWTDialog) {
                this.v$jd = jEWTDialog;
                this.v$p = messagePanel;
                this.this$0 = var1_1;
                super(string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProxyTestStatus
    extends Enum<ProxyTestStatus> {
        private static final /* synthetic */ ProxyTestStatus[] $v;
        public static final /* enum */ ProxyTestStatus NOT_STARTED;
        public static final /* enum */ ProxyTestStatus TESTING;
        public static final /* enum */ ProxyTestStatus SUCCESSFUL;
        public static final /* enum */ ProxyTestStatus FAILED;

        public static ProxyTestStatus valueOf(String string) {
            return Enum.valueOf(ProxyTestStatus.class, string);
        }

        public static final ProxyTestStatus[] values() {
            return (ProxyTestStatus[])$v.clone();
        }

        static {
            ProxyTestStatus[] proxyTestStatusArray = new ProxyTestStatus[4];
            proxyTestStatusArray[3] = FAILED = new ProxyTestStatus("FAILED", 3);
            proxyTestStatusArray[2] = SUCCESSFUL = new ProxyTestStatus("SUCCESSFUL", 2);
            proxyTestStatusArray[1] = TESTING = new ProxyTestStatus("TESTING", 1);
            proxyTestStatusArray[0] = NOT_STARTED = new ProxyTestStatus("NOT_STARTED", 0);
            $v = proxyTestStatusArray;
        }

        private ProxyTestStatus(String string2, int n2) {
        }
    }
}

