/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser.internal;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.security.misc.Checksum;

public final class Util {
    private static Boolean _cachedInternal;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Util() {
    }

    public static boolean isInsideOracle() {
        if (_cachedInternal != null) {
            return _cachedInternal;
        }
        _cachedInternal = Util.detectInternal();
        return _cachedInternal;
    }

    private static boolean isVerboseLogging() {
        return Boolean.getBoolean("ide.internalcheck.verbose");
    }

    private static boolean detectInternal() {
        try {
            if (Util.pingIdeWebSite()) {
                if (Util.isVerboseLogging()) {
                    System.err.println("Detected internal user: pinged internal website");
                }
                boolean bl = true;
                return bl;
            }
            if (Util.checkHostname()) {
                if (Util.isVerboseLogging()) {
                    System.err.println("Detected internal user from hostname");
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (Util.isVerboseLogging()) {
                System.err.println("Failed to detect internal user");
                t.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
    }

    private static synchronized boolean checkHostname() {
        block5: {
            try {
                InetAddress[] inets = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                int i = 0;
                while (i < inets.length) {
                    String hostName = inets[i].getCanonicalHostName();
                    if (hostName != null && hostName.endsWith(".oracle.com")) {
                        boolean bl = true;
                        return bl;
                    }
                    ++i;
                }
            }
            catch (UnknownHostException uhe) {
                if (!Util.isVerboseLogging()) break block5;
                uhe.printStackTrace();
            }
        }
        if (Util.isVerboseLogging()) {
            System.err.println("Failed to detect internal user: No hostname contains .oracle.com");
        }
        return false;
    }

    private static synchronized boolean pingIdeWebSite() {
        ProxyOptions tmppo = new ProxyOptions();
        tmppo.setUseProxy(Boolean.FALSE);
        int[] response = new int[]{0};
        tmppo.doTask(new 1(response));
        return response[0] >= 200 && response[0] <= 299;
    }

    public static String encode(String data) {
        if (data == null) {
            return null;
        }
        try {
            byte[] b = data.getBytes();
            String string = Util.e(Checksum.MD5((byte[])b, null));
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String decode(String data) {
        if (data == null) {
            return null;
        }
        byte[] b = Util.d(data);
        if (b.length > 0) {
            try {
                b = Checksum.SHA((byte[])b, null);
                String string = new String(b);
                return string;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public static String e(byte[] b) {
        StringBuffer result = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            result.append(Util.intToAlpha((b[i] & 0xF0) >> 4));
            result.append(Util.intToAlpha(b[i] & 0xF));
            ++i;
        }
        return result.toString();
    }

    public static byte[] d(String s) {
        int len = s.length();
        byte[] result = new byte[len / 2];
        int i = 0;
        while (i < len) {
            byte b1 = Util.alphaToInt(s.charAt(i));
            byte b2 = Util.alphaToInt(s.charAt(i + 1));
            result[i / 2] = (byte)(b1 << 4 & 0xF0 | b2 & 0xF);
            i += 2;
        }
        return result;
    }

    static {
        $assertionsDisabled = Util.class.desiredAssertionStatus() ^ true;
    }

    private static char intToAlpha(int i) {
        if (!$assertionsDisabled && i >= 16) {
            throw new AssertionError();
        }
        return (char)(i < 10 ? i + 48 : i - 10 + 65);
    }

    private static byte alphaToInt(char c) {
        if (!($assertionsDisabled || c >= '0' && c <= '9' || c >= 'A' && c <= 'F')) {
            throw new AssertionError();
        }
        return (byte)(c >= 'A' ? c - 65 + 10 : c - 48);
    }

    static boolean maS$isVerboseLogging() {
        return Util.isVerboseLogging();
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ int[] v$response;

        public void run() {
            block2: {
                String urlString = System.getProperty("ide.internalcheck.url", "http://ide.us.oracle.com/");
                try {
                    URL urlToPing = new URL(urlString);
                    URLConnection conn = urlToPing.openConnection();
                    conn.setConnectTimeout(800);
                    conn.setReadTimeout(800);
                    ((HttpURLConnection)conn).setRequestMethod("HEAD");
                    conn.connect();
                    this.v$response[0] = ((HttpURLConnection)conn).getResponseCode();
                }
                catch (IOException ioe) {
                    if (!Util.maS$isVerboseLogging()) break block2;
                    System.err.println("Could not connect to " + urlString + " when detecting internal user.");
                    ioe.printStackTrace();
                }
            }
        }

        public 1(int[] nArray) {
            this.v$response = nArray;
        }
    }
}

