/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.ideimpl.webbrowser.BrowserOptions;
import oracle.javatools.controls.FileField;

public final class BrowserOptionsPanel
extends DefaultTraversablePanel
implements ActionListener,
ApplyListener {
    private FileField textfield_browserCommand;
    private JButton button_browse;
    private ProxySettingsPanel proxyPanel;

    public BrowserOptionsPanel() {
        this.setHelpID("f1_prefweb_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    private BrowserOptions findBrowserOptions(TraversableContext tc) {
        return BrowserOptions.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        BrowserOptions browserOptions = this.findBrowserOptions(tc);
        String browserCommand = browserOptions.getBrowserCmdLine();
        this.textfield_browserCommand.setText(browserCommand);
        this.proxyPanel.onEntry(tc);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        int rtn;
        BrowserOptions browserOptions = this.findBrowserOptions(tc);
        String browserCommand = this.textfield_browserCommand.getText();
        if (browserCommand != null && browserCommand.length() > 0 && !this.isCommandLineValid(browserCommand) && (rtn = JOptionPane.showConfirmDialog((Component)((Object)this), BrowserArb.getString(0), BrowserArb.getString(27), 0)) != 0) {
            throw new TraversalException(null);
        }
        browserOptions.setBrowserCmdLine(browserCommand);
        this.proxyPanel.onExit(tc);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.button_browse) {
            String path;
            URL url;
            String title = BrowserArb.getString(3);
            String fileName = this.textfield_browserCommand.getText();
            URL defaultURL = fileName != null && fileName.length() > 0 ? URLFactory.newFileURL((String)fileName) : null;
            URLChooser chooser = DialogUtil.newURLChooser(defaultURL);
            int result = chooser.showOpenDialog((Component)((Object)this), title);
            if (result == 0 && (url = chooser.getSelectedURL()) != null && (path = URLFileSystem.getPlatformPathName((URL)url)) != null) {
                this.textfield_browserCommand.setText(path);
            }
        }
    }

    private void initializeComponent() {
        String browserText = BrowserArb.getString(36);
        JLabel label_browser = new JLabel();
        this.textfield_browserCommand = new FileField();
        this.textfield_browserCommand.setValidateExistingFile(true);
        ResourceUtils.resLabel((JLabel)label_browser, (Component)this.textfield_browserCommand, (String)browserText);
        String buttonText = BrowserArb.getString(28);
        this.button_browse = new JButton();
        ResourceUtils.resButton((AbstractButton)this.button_browse, (String)buttonText);
        this.button_browse.addActionListener(this);
        this.proxyPanel = new ProxySettingsPanel();
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        JPanel panel_browser = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_browser.add((Component)label_browser, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        panel_browser.add((Component)this.textfield_browserCommand, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_browser.add((Component)this.button_browse, constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0);
        this.add(panel_browser, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        this.add(Box.createVerticalStrut(15), constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0);
        this.add((Component)((Object)this.proxyPanel), constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
        String prop = System.getProperty("oracle.macosx.disableWebBrowser");
        if (prop != null && prop.equalsIgnoreCase("true")) {
            label_browser.setVisible(false);
            this.textfield_browserCommand.setVisible(false);
            this.button_browse.setVisible(false);
        }
    }

    private boolean isCommandLineValid(String commandLine) {
        if (commandLine != null && commandLine.length() > 0) {
            File browserFile = new File(commandLine);
            if (browserFile.exists()) {
                return true;
            }
            int lastSpacePos = commandLine.lastIndexOf(32);
            if (lastSpacePos == -1) {
                return false;
            }
            return this.isCommandLineValid(commandLine.substring(0, lastSpacePos));
        }
        return false;
    }

    public void apply(ApplyEvent e) {
        if (this.proxyPanel != null) {
            this.proxyPanel.apply(e);
        }
    }

    public void cancel(ApplyEvent e) {
        if (this.proxyPanel != null) {
            this.proxyPanel.cancel(e);
        }
    }
}

