/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Window;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.SwingUtilities;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.AuthenticationPrompt;

public class IdeAuthenticator
extends Authenticator {
    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication proxyAuth;
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && (proxyAuth = this.getProxyAuthentication()) != null) {
            return proxyAuth;
        }
        AuthenticationPromptRunner runner = new AuthenticationPromptRunner(null);
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return runner.getPasswordAuthentication();
    }

    private PasswordAuthentication getProxyAuthentication() {
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        if (proxyOptions.getUseProxyAuthentication().booleanValue()) {
            String host1 = this.getRequestingHost();
            String host2 = proxyOptions.getProxyHost();
            int port1 = this.getRequestingPort();
            int port2 = Integer.parseInt(proxyOptions.getProxyPort());
            if (host1.equalsIgnoreCase(host2) && port1 == port2) {
                return new PasswordAuthentication(proxyOptions.getProxyUserName(), proxyOptions.getProxyPassword().toCharArray());
            }
        }
        return null;
    }

    static String mav$getRequestingHost(IdeAuthenticator ideAuthenticator) {
        return ideAuthenticator.getRequestingHost();
    }

    static int mav$getRequestingPort(IdeAuthenticator ideAuthenticator) {
        return ideAuthenticator.getRequestingPort();
    }

    static String mav$getRequestingProtocol(IdeAuthenticator ideAuthenticator) {
        return ideAuthenticator.getRequestingProtocol();
    }

    static String mav$getRequestingPrompt(IdeAuthenticator ideAuthenticator) {
        return ideAuthenticator.getRequestingPrompt();
    }

    private final class AuthenticationPromptRunner
    implements Runnable {
        private PasswordAuthentication authentication;

        public void run() {
            AuthenticationPrompt prompt = new AuthenticationPrompt(IdeAuthenticator.mav$getRequestingHost(IdeAuthenticator.this), IdeAuthenticator.mav$getRequestingPort(IdeAuthenticator.this), IdeAuthenticator.mav$getRequestingProtocol(IdeAuthenticator.this), IdeAuthenticator.mav$getRequestingPrompt(IdeAuthenticator.this));
            if (prompt.runDialog(this.getParentWindow())) {
                this.authentication = new PasswordAuthentication(prompt.getUserName(), prompt.getPassword());
            }
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }

        private Window getParentWindow() {
            Window window = IdeUtil.findActiveModalWindow();
            return window != null ? window : IdeUtil.getMainWindow();
        }

        private AuthenticationPromptRunner() {
        }

        AuthenticationPromptRunner(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

