/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.natives.WindowsInternetOptions;
import oracle.ide.panels.Navigable;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.ideimpl.webbrowser.Strings;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.PlatformUtils;

final class ProxyAddin
implements Addin {
    private static final Logger LOG = Logger.getLogger(ProxyAddin.class.getName());
    private static Navigable NAV;

    static Navigable getNavigable() {
        if (NAV == null) {
            NAV = new Navigable(BrowserArb.getString(8), ProxySettingsPanel.class);
        }
        return NAV;
    }

    public void initialize() {
        ProxyAddin.loadDefaultProxy();
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        IdeSettings ideSettings = Ide.getSettings();
        ideSettings.putLegacyData("proxy-options", (Copyable)proxyOptions);
        proxyOptions.addChangeListener(new 1());
        proxyOptions.fireChangeEvent();
        IdeSettings.registerUI((Navigable)ProxyAddin.getNavigable());
    }

    private static void loadDefaultProxy() {
        if (ProxyAddin.proxyOptionsAreSet()) {
            LOG.fine("Skipping HTTP proxy defaults. Proxy options were passed in to the Java VM");
            return;
        }
        if (!PlatformUtils.isWindows()) {
            ProxyAddin.loadProxyFromEnvVars();
        } else {
            ProxyAddin.loadProxyNative();
        }
    }

    private static boolean proxyOptionsAreSet() {
        return System.getProperty("http.proxyHost") != null;
    }

    private static void loadProxyNative() {
        LOG.fine("Defaulting HTTP proxy from Windows Internet Options");
        try {
            WindowsInternetOptions options = new WindowsInternetOptions();
            ProxyAddin.setHttpProxy(options.proxyHost(), options.proxyPort(), options.nonProxyHosts());
        }
        catch (UnsupportedOperationException e) {
            LOG.warning("Unable to default HTTP proxy: " + e.getMessage());
        }
        catch (IllegalStateException e) {
            LOG.warning("Unable to default HTTP proxy: " + e.getMessage());
        }
    }

    private static void loadProxyFromEnvVars() {
        String proxyUrl = ProxyAddin.getenv("http_proxy");
        if (proxyUrl == null) {
            return;
        }
        LOG.fine("Defaulting HTTP proxy from environment variables");
        String[] hostAndPort = Strings.hostAndPort(proxyUrl);
        if (hostAndPort == null) {
            LOG.warning("http_proxy env var is invalid: " + proxyUrl);
            return;
        }
        String noProxy = ProxyAddin.getenv("no_proxy");
        ProxyAddin.setHttpProxy(hostAndPort[0], hostAndPort[1], noProxy);
    }

    static void setHttpProxy(String host, String port, String excludes) {
        if (host == null) {
            return;
        }
        LOG.fine("Default HTTP proxy settings are set to: \n  http.proxyHost=" + host + "\n" + "  http.proxyPort=" + port + "\n" + "  http.nonProxyHosts=" + excludes);
        System.setProperty("http.proxyHost", host);
        System.setProperty("http.proxyPort", port == null ? "80" : port);
        if (excludes != null) {
            System.setProperty("http.nonProxyHosts", excludes);
        }
    }

    private static String getenv(String envVar) {
        String value = System.getenv(envVar.toLowerCase());
        if (value == null) {
            value = System.getenv(envVar.toUpperCase());
        }
        return value;
    }

    ProxyAddin() {
    }

    final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            ProxyOptions proxyOptions = (ProxyOptions)((Object)e.getSource());
            proxyOptions.applyToCurrentVM();
        }
    }
}

