/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

final class Strings {
    private Strings() {
    }

    static String[] hostAndPort(String url) {
        String[] parts = url.split(":");
        if (parts.length < 2) {
            return null;
        }
        String host = Strings.trim(parts[1], '/');
        if (host == null || host.length() == 0) {
            return null;
        }
        String port = null;
        if (parts.length > 2) {
            port = Strings.trim(parts[2], '/');
        }
        return new String[]{host, port};
    }

    static String trim(String s, char c) {
        int start = Strings.firstNonMatchingChar(s, c);
        int end = Strings.lastNonMatchingChar(s, c);
        if (start == -1 || end == -1) {
            return null;
        }
        if (end - start <= 0) {
            return null;
        }
        return s.substring(start, end);
    }

    private static int lastNonMatchingChar(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0) {
            if (s.charAt(i) != c) {
                return i + 1;
            }
            --i;
        }
        return -1;
    }

    private static int firstNonMatchingChar(String s, char c) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != c) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

