/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.io.PrintStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.util.Assert;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GalleryFolder
implements Folder,
Comparable {
    protected static final Collator COLLATOR = Collator.getInstance();
    private String _name;
    private List _children = new ArrayList(10);
    private boolean _unsorted;
    private transient boolean _expanded;

    public GalleryFolder() {
    }

    public GalleryFolder(String name) {
        this();
        this._name = name;
    }

    public List getList() {
        List children = this.getChildrenDirectly();
        return new ArrayList(children);
    }

    public void setList(List list) {
        List children = this.getChildrenDirectly();
        children.clear();
        if (list != null) {
            for (Object next : list) {
                if (!(next instanceof Element)) continue;
                this.add((Element)next);
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean getUnsorted() {
        return this._unsorted;
    }

    public void setUnsorted(boolean unsorted) {
        this._unsorted = unsorted;
    }

    public GalleryFolder getFolder(String folderName) {
        return this.findFolder(folderName, false);
    }

    public GalleryFolder createFolder(String folderName) {
        GalleryFolder f = this.getFolder(folderName);
        if (f == null) {
            f = new GalleryFolder(folderName);
            this.add((Element)f);
        }
        return f;
    }

    public GalleryFolder getGalleryFolder(String folderName) {
        try {
            GalleryFolder galleryFolder = this.findFolder(folderName);
            return galleryFolder;
        }
        catch (Exception ex) {
            Assert.println((String)("GalleryFolder.getGalleryFolder Exception: " + ex.toString()));
            return null;
        }
    }

    public GalleryElement getGalleryElement(String elementName) {
        List children = this.getChildrenDirectly();
        for (Element e : children) {
            String label;
            if (e instanceof GalleryFolder) {
                GalleryElement ge = ((GalleryFolder)e).getGalleryElement(elementName);
                if (ge == null) continue;
                return ge;
            }
            if (!(e instanceof GalleryElement) || (label = e.getShortLabel()) == null || !ModelUtil.areEqual((Object)label, (Object)elementName)) continue;
            return (GalleryElement)e;
        }
        return null;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public Iterator getChildren() {
        List children = this.getChildrenDirectly();
        return children.iterator();
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    public boolean canAdd(Element element) {
        return false;
    }

    public boolean add(Element element) {
        List children = this.getChildrenDirectly();
        return children.add(element);
    }

    public boolean canRemove(Element element) {
        return false;
    }

    public boolean remove(Element element) {
        List children = this.getChildrenDirectly();
        return children.remove(element);
    }

    public void removeAll() {
        List children = this.getChildrenDirectly();
        children.clear();
    }

    public boolean containsChild(Element element) {
        List children = this.getChildrenDirectly();
        return children.contains(element);
    }

    public int size() {
        List children = this.getChildrenDirectly();
        return children.size();
    }

    public String getShortLabel() {
        return this._name;
    }

    public String getLongLabel() {
        return this._name;
    }

    public String getToolTipText() {
        return this._name;
    }

    public Icon getIcon() {
        return null;
    }

    public String toString() {
        return this.getLongLabel();
    }

    public Object getData() {
        return this;
    }

    public int compareTo(Object o) {
        if (o instanceof GalleryElement) {
            return -1;
        }
        if (o instanceof GalleryFolder) {
            GalleryFolder f = (GalleryFolder)o;
            if (this.getUnsorted() != f.getUnsorted()) {
                return this.getUnsorted() ? -1 : 1;
            }
            if (this.getUnsorted() && f.getUnsorted()) {
                return 0;
            }
            return GalleryFolder.compareImpl(this.getShortLabel(), f.getShortLabel());
        }
        return GalleryFolder.compareImpl(this.getShortLabel(), o.toString());
    }

    private static int compareImpl(String strForThis, String strForOther) {
        if (strForThis == null) {
            return strForOther == null ? 0 : -1;
        }
        if (strForOther == null) {
            return 1;
        }
        return COLLATOR.compare(strForThis, strForOther);
    }

    public int getSize() {
        return this.size();
    }

    public Object getElementAt(int index) {
        List children = this.getChildrenDirectly();
        return children.get(index);
    }

    protected boolean isExpanded() {
        return this._expanded;
    }

    protected void setExpanded(boolean expanded) {
        this._expanded = expanded;
    }

    protected List getChildrenDirectly() {
        return this._children;
    }

    protected void setChildrenDirectly(List children) {
        this._children = children;
    }

    protected GalleryElement[] getElementChildren() {
        Collection elements = this.getChildrenByClass(GalleryElement.class);
        return elements.toArray(new GalleryElement[elements.size()]);
    }

    protected GalleryElement[] getSortedElementChildren() {
        Object[] children = this.getElementChildren();
        Arrays.sort(children);
        return children;
    }

    protected GalleryFolder[] getFolderChildren() {
        Collection folders = this.getChildrenByClass(GalleryFolder.class);
        return folders.toArray(new GalleryFolder[folders.size()]);
    }

    protected GalleryFolder findFolder(String folderName) {
        return this.findFolder(folderName, true);
    }

    boolean addElement(ElementInfo info) {
        GalleryElement ele = this.getGalleryElement(info.getName());
        if (ele == null) {
            ele = info.createElement();
            this.add(ele);
            return true;
        }
        return false;
    }

    boolean removeElement(ElementInfo info) {
        GalleryElement ele = info.createElement();
        if ((ele = this.getGalleryElement(ele.getShortLabel())) != null) {
            this.remove(ele);
            return true;
        }
        return false;
    }

    boolean isInScope(TechnologyScope scope) {
        if (scope == null) {
            return false;
        }
        for (Object next : this.getChildrenDirectly()) {
            if (!(next instanceof GalleryFolder ? ((GalleryFolder)next).isInScope(scope) : next instanceof GalleryElement && ((GalleryElement)next).isInScope(scope))) continue;
            return true;
        }
        return false;
    }

    boolean isAvailable(Context context) {
        if (context == null) {
            return false;
        }
        for (Object next : this.getChildrenDirectly()) {
            if (!(next instanceof GalleryFolder ? ((GalleryFolder)next).isAvailable(context) : next instanceof GalleryElement && ((GalleryElement)next).isAvailable(context))) continue;
            return true;
        }
        return false;
    }

    void debugLogTechnologies(PrintStream log, String path, Map techMap) {
        Object[] elements = this.getElementChildren();
        if (elements.length > 0) {
            log.println();
            log.println(path + ":");
            Arrays.sort(elements);
            int i = 0;
            while (i < elements.length) {
                Object e = elements[i];
                String[] technologyKeys = ((GalleryElement)e).getTechnologyKeys();
                String tech = GalleryFolder.getTechnologyString(technologyKeys);
                log.println("  " + ((GalleryElement)e).getShortLabel() + " [" + tech + "]");
                ArrayList<String> l = (ArrayList<String>)techMap.get(tech);
                if (l == null) {
                    l = new ArrayList<String>();
                    techMap.put(tech, l);
                }
                l.add(path + ": " + ((GalleryElement)e).getShortLabel());
                ++i;
            }
        }
        Object[] folders = this.getFolderChildren();
        Arrays.sort(folders);
        int i = 0;
        while (i < folders.length) {
            Object f = folders[i];
            String label = ((GalleryFolder)f).getShortLabel();
            String newPath = path != null ? path + " -> " + label : label;
            ((GalleryFolder)f).debugLogTechnologies(log, newPath, techMap);
            ++i;
        }
    }

    private static String getTechnologyString(String[] technologyKeys) {
        if (technologyKeys == null || technologyKeys.length == 0) {
            return "<none>";
        }
        Arrays.sort(technologyKeys);
        TechnologyRegistry techRegistry = TechnologyRegistry.getInstance();
        TreeSet<TechId> ancestorTechs = new TreeSet<TechId>();
        String key = "";
        int i = 0;
        while (i < technologyKeys.length) {
            TechId techId;
            String technologyKey = technologyKeys[i];
            key = key + technologyKey;
            if (i < technologyKeys.length - 1) {
                key = key + " + ";
            }
            if ((techId = techRegistry.getTechId(technologyKey)) != null) {
                TechId[] dependencies = techRegistry.getDependenciesFor(techId);
                int j = 0;
                while (j < dependencies.length) {
                    TechId dependency = dependencies[j];
                    if (dependency != null) {
                        ancestorTechs.add(dependency);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!ancestorTechs.isEmpty()) {
            key = key + " (depends on ";
            Iterator it = ancestorTechs.iterator();
            while (it.hasNext()) {
                TechId techId = (TechId)it.next();
                key = key + techId.getKey();
                if (!it.hasNext()) continue;
                key = key + " + ";
            }
            key = key + ")";
        }
        return key;
    }

    private Collection getChildrenByClass(Class clazz) {
        List children = this.getChildrenDirectly();
        ArrayList classChildren = new ArrayList();
        for (Object next : children) {
            if (clazz != null && !clazz.isAssignableFrom(next.getClass())) continue;
            classChildren.add(next);
        }
        return classChildren;
    }

    private GalleryFolder findFolder(String folderName, boolean recurse) {
        GalleryFolder[] folders = this.getFolderChildren();
        int i = 0;
        while (i < folders.length) {
            GalleryFolder f;
            GalleryFolder folder = folders[i];
            if (folder.getShortLabel().equals(folderName)) {
                return folder;
            }
            if (recurse && (f = folder.findFolder(folderName, recurse)) != null) {
                return f;
            }
            ++i;
        }
        return null;
    }
}

