/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ide.wizard.spi.WizardHook;
import javax.ide.wizard.spi.WizardInfo;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryHandler;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.GallerySearchEvent;
import oracle.ide.gallery.GallerySearchListener;
import oracle.ide.gallery.GalleryXMLDataNode;
import oracle.ide.gallery.JavaxIdeElementInfo;
import oracle.ide.gallery.ObjectGalleryAddin;
import oracle.ide.gallery.ObjectGalleryPanel;
import oracle.ide.gallery.RootGalleryFolder;
import oracle.ide.gallery.TabbedObjectGalleryPanel;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.XMLDataNode;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.resource.GalleryArb;
import oracle.ide.util.Assert;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;

public final class ObjectGallery {
    private static final String XML_FILENAME = "gallery.xml";
    private final SizeKeeperCallback _dialogCallback;
    private XMLDataNode _model;
    private Context _context;
    private JEWTFinishDialog _dlg;
    private GalleryElement _selItem;
    private TabbedObjectGalleryPanel _panel;
    private boolean _loadedHook;

    private void $init$() {
        this._dialogCallback = new SizeKeeperCallback("new.gallery");
        this._loadedHook = false;
    }

    public ObjectGallery() {
        this.$init$();
        File xmlFile = new File(Ide.getLibDirectory(), XML_FILENAME);
        URL url = URLFactory.newFileURL((File)xmlFile);
        this._model = new GalleryXMLDataNode(url);
    }

    public GalleryFolder getModel() {
        return (GalleryFolder)this._model.getData();
    }

    public void runDialog(Context context) {
        this.runDialog(context, null, null);
    }

    public void runDialog(Context context, String initialFolder, String initialSelection) {
        if (this._context != null) {
            return;
        }
        this._context = context;
        this.loadGalleryData();
        this._dlg = new JEWTFinishDialog((Frame)Ide.getMainWindow(), GalleryArb.getString((int)249), 7);
        RootGalleryFolder rootFolder = (RootGalleryFolder)this._model.getData();
        EventAdapter eventAdapter = new EventAdapter(null);
        if (context != null && context.getProject() != null) {
            ObjectGalleryPanel allItemsPanel = new ObjectGalleryPanel(rootFolder, context);
            ObjectGalleryPanel projectTechnologiesPanel = new ObjectGalleryPanel(rootFolder, context, true, eventAdapter);
            this._panel = new TabbedObjectGalleryPanel(allItemsPanel, projectTechnologiesPanel);
            this._panel.addChangeListener(eventAdapter);
        } else {
            boolean filtered = context == null || context.getProject() == null;
            ObjectGalleryPanel panel = new ObjectGalleryPanel(rootFolder, context, filtered);
            this._panel = new TabbedObjectGalleryPanel(panel);
        }
        this._panel.addListSelectionListener(eventAdapter);
        this._panel.addActionListener(eventAdapter);
        this._dlg.setOKButtonEnabled(false);
        this._dlg.setContent(this._panel);
        this._dlg.setResizable(true);
        this._panel.setContext(context);
        this._panel.setInitialSelection(initialFolder, initialSelection);
        this.activateTab(rootFolder.getLastSelectedTab());
        this._dlg.setPreferredSize(TDialogLauncher.getPreferredDefaultInitialSize());
        this._dlg.setInitialFocus(this._panel.getInitialFocusComponent());
        this.setCanAdvance();
        this._dialogCallback.dialogAboutToRun((JDialog)((Object)this._dlg));
        boolean finished = WizardLauncher.runDialog((JDialog)((Object)this._dlg));
        rootFolder.setMainDividerLocation(this._panel.getMainDividerLocation());
        if (this._panel.getTabCount() == 2) {
            rootFolder.setLastSelectedTab(this._panel.getSelectedIndex());
        }
        if (finished) {
            this.invokeWizard(this._selItem);
        }
        this._context = null;
        this._dlg = null;
        this._selItem = null;
        this._panel = null;
    }

    private void activateTab(int tabIndex) {
        if (this._panel.getTabCount() == 2) {
            if (!this.hasTechnologyScope(this._context)) {
                tabIndex = 0;
            } else if (tabIndex == -1) {
                tabIndex = 1;
            }
        }
        this._panel.setSelectedIndex(tabIndex);
    }

    private boolean hasTechnologyScope(Context context) {
        if (context == null || context.getProject() == null) {
            return false;
        }
        TechnologyScope techScope = TechnologyScopeConfiguration.getInstance((PropertyStorage)context.getProject()).getTechnologyScope();
        return techScope != null && !techScope.isEmpty();
    }

    public void loadGalleryData() {
        if (!this._loadedHook) {
            try {
                ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
                GalleryHandler galleryHook = (GalleryHandler)er.getHook(GalleryHandler.ELEMENT);
                GalleryManager mgr = GalleryManager.getGalleryManager();
                ((ObjectGalleryAddin)mgr).registerFolders(galleryHook.getFolders());
                Set items = galleryHook.getItems();
                for (ElementInfo item : items) {
                    mgr.registerGalleryElement(item);
                }
                WizardHook wizHook = (WizardHook)ExtensionRegistry.getExtensionRegistry().getHook(WizardHook.ELEMENT);
                Collection classes = wizHook.getAllWizardClasses();
                Iterator i = classes.iterator();
                while (i.hasNext()) {
                    WizardInfo wi = wizHook.getWizardInfo((String)i.next());
                    mgr.registerGalleryElement(new JavaxIdeElementInfo(wi));
                }
            }
            finally {
                this._loadedHook = true;
            }
        }
        try {
            this._model.open();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.flushPendingGalleryItems();
    }

    static final boolean isWizardAvailable(Wizard w, Context context) {
        if (w != null) {
            try {
                boolean bl = w.isAvailable(context);
                return bl;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    private void invokeWizard(GalleryElement element) {
        if (this._selItem != null && this._selItem.getWizard() != null) {
            GalleryElement ge = element;
            Context ctx = this._context;
            Wizard wiz = ge.getWizard();
            if (wiz != null) {
                String[] wizParams = ge.getWizardParameters();
                String[] techKeys = ge.getTechnologyKeys();
                WizardManager.getInstance().invokeSecondaryWizard(wiz, ctx, wizParams, techKeys);
            }
        }
    }

    private final void setCanAdvance() {
        try {
            try {
                GalleryElement sel;
                this._selItem = sel = this._panel.getSelectedItem();
            }
            catch (Exception ex) {
                this._selItem = null;
            }
        }
        catch (Throwable throwable) {
            Wizard w = this._selItem != null ? this._selItem.getWizard() : null;
            this._dlg.setOKButtonEnabled(ObjectGallery.isWizardAvailable(w, this._context));
            throw throwable;
        }
        Wizard w = this._selItem != null ? this._selItem.getWizard() : null;
        this._dlg.setOKButtonEnabled(ObjectGallery.isWizardAvailable(w, this._context));
    }

    private static ObjectGalleryAddin getObjectGalleryAddin() {
        GalleryManager galleryManager = GalleryManager.getGalleryManager();
        Assert.check((boolean)(galleryManager instanceof ObjectGalleryAddin));
        if (galleryManager instanceof ObjectGalleryAddin) {
            return (ObjectGalleryAddin)galleryManager;
        }
        return null;
    }

    private void flushPendingGalleryItems() {
        String techLog;
        ObjectGalleryAddin galleryAddin = ObjectGallery.getObjectGalleryAddin();
        if (galleryAddin != null) {
            galleryAddin.removePendingGalleryItems();
            galleryAddin.addPendingGalleryItems();
        }
        if (ModelUtil.hasLength((String)(techLog = System.getProperty("jdev.debug.technology.log")))) {
            PrintStream log;
            if (techLog.equals("System.out")) {
                log = System.out;
            } else if (techLog.equals("System.err")) {
                log = System.err;
            } else {
                try {
                    log = new PrintStream(new FileOutputStream(techLog));
                }
                catch (FileNotFoundException ex) {
                    System.err.println("ERROR opening technology log: " + techLog);
                    return;
                }
            }
            GalleryFolder f = this.getModel();
            if (f != null) {
                TreeMap techMap = new TreeMap();
                log.println();
                log.println("Technologies By Item");
                log.println("--------------------");
                f.debugLogTechnologies(log, null, techMap);
                log.println();
                log.println("Items By Technology");
                log.println("-------------------");
                for (Map.Entry entry : techMap.entrySet()) {
                    String tech = (String)entry.getKey();
                    log.println();
                    log.println(tech + ":");
                    List l = (List)entry.getValue();
                    Iterator it2 = l.iterator();
                    while (it2.hasNext()) {
                        log.println("  " + (String)it2.next());
                    }
                }
            }
        }
    }

    static void mav$setCanAdvance(ObjectGallery objectGallery) {
        objectGallery.setCanAdvance();
    }

    static TabbedObjectGalleryPanel ra$_panel(ObjectGallery objectGallery) {
        return objectGallery._panel;
    }

    static GalleryElement ra$_selItem(ObjectGallery objectGallery) {
        return objectGallery._selItem;
    }

    static Context ra$_context(ObjectGallery objectGallery) {
        return objectGallery._context;
    }

    static JEWTFinishDialog ra$_dlg(ObjectGallery objectGallery) {
        return objectGallery._dlg;
    }

    private final class EventAdapter
    implements ActionListener,
    ChangeListener,
    GallerySearchListener,
    ListSelectionListener {
        public void actionPerformed(ActionEvent e) {
            Wizard w;
            if (ObjectGallery.ra$_selItem(ObjectGallery.this) != null && ObjectGallery.isWizardAvailable(w = ObjectGallery.ra$_selItem(ObjectGallery.this).getWizard(), ObjectGallery.ra$_context(ObjectGallery.this))) {
                ObjectGallery.ra$_dlg(ObjectGallery.this).finish();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ObjectGallery.mav$setCanAdvance(ObjectGallery.this);
            }
        }

        public void searchExpanded(GallerySearchEvent event) {
            ((ObjectGalleryPanel)ObjectGallery.ra$_panel((ObjectGallery)ObjectGallery.this).getComponentAt((int)0)).searchField.setText(event.getSearchText());
            ObjectGallery.ra$_panel(ObjectGallery.this).setSelectedIndex(0);
        }

        public void stateChanged(ChangeEvent e) {
            ObjectGallery.mav$setCanAdvance(ObjectGallery.this);
        }

        private EventAdapter() {
        }

        EventAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class JEWTFinishDialog
    extends JEWTDialog {
        private static final String DFT_SYMBOL = "new-gallery";

        public JEWTFinishDialog(Frame f, String s, int i) {
            super(f, s, i);
            this.setName(DFT_SYMBOL);
            this.setSize(600, 400);
        }

        public void finish() {
            this.dismissDialog(false);
        }
    }
}

