/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.FolderInfo;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryHandler;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.ObjectGallery;
import oracle.ide.gallery.RootGalleryFolder;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.navigator.NavigatorConstants;

final class ObjectGalleryAddin
extends GalleryManager
implements Controller {
    public static final int OBJECT_GALLERY_CMD_ID = Ide.findOrCreateCmdID((String)"ObjectGalleryCommand");
    public static final String OBJECT_GALLERY_CMD = "oracle.ide.cmd.ObjectGalleryCommand";
    private ObjectGallery _gallery;
    private Collection _galleryAddItems;
    private Collection _galleryRemoveItems;
    private Properties _pendingProperties;
    private Collection _foldersAdd;
    private boolean _extGeneratorsLoaded;

    private void $init$() {
        this._extGeneratorsLoaded = false;
    }

    public ObjectGalleryAddin() {
        this.$init$();
    }

    public synchronized ObjectGallery getGallery() {
        if (this._gallery == null) {
            this._gallery = new ObjectGallery();
        }
        return this._gallery;
    }

    public void registerGalleryElement(ElementInfo info) {
        if (this._galleryAddItems == null) {
            this._galleryAddItems = new ArrayList();
        }
        if (!this.removeFromQueue(this._galleryRemoveItems, info) && !this._galleryAddItems.contains(info)) {
            this._galleryAddItems.add(info);
        }
    }

    public void unregisterGalleryElement(ElementInfo info) {
        if (this._galleryRemoveItems == null) {
            this._galleryRemoveItems = new ArrayList();
        }
        if (!this.removeFromQueue(this._galleryAddItems, info)) {
            this._galleryRemoveItems.add(info);
        }
    }

    public Properties getBuilderProperties() {
        if (!this._extGeneratorsLoaded) {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            GalleryHandler handler = (GalleryHandler)er.getHook(GalleryHandler.ELEMENT);
            this.registerBuilderProperties(handler.getGenerators());
            this._extGeneratorsLoaded = true;
        }
        if (this._pendingProperties != null) {
            if (this.getRootFolder().getGenerators() != null) {
                this._pendingProperties.putAll((Map<?, ?>)this.getRootFolder().getGenerators());
            }
            this.getRootFolder().setGenerators(this._pendingProperties);
            this._pendingProperties = null;
        }
        return this.getRootFolder().getGenerators();
    }

    void registerBuilderProperties(Properties properties) {
        if (this._pendingProperties == null) {
            this._pendingProperties = new Properties();
        }
        this._pendingProperties.putAll((Map<?, ?>)properties);
    }

    void registerFolders(Collection folders) {
        if (this._foldersAdd == null) {
            this._foldersAdd = new LinkedHashSet();
        }
        this._foldersAdd.addAll(folders);
    }

    public void initialize() {
        GalleryManager.setGalleryManager(this);
        Menubar mm = Ide.getMenubar();
        IdeAction galleryAction = IdeAction.find((int)OBJECT_GALLERY_CMD_ID);
        galleryAction.addController((Controller)this);
        JMenuItem newMenuItem = mm.createMenuItem((ToggleAction)galleryAction, 1.0f);
        mm.add((Component)newMenuItem, MenuManager.getJMenu((String)"File"), 1.0f);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/ide/gallery/accelerators.xml");
        NavigatorConstants.New = mm.createMenuItem((ToggleAction)galleryAction, MenuConstants.WEIGHT_FILE_NEW_GALLERY);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == OBJECT_GALLERY_CMD_ID) {
            this._invokeGallery(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == OBJECT_GALLERY_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    protected void addPendingGalleryItems() {
        if (this._galleryAddItems != null) {
            for (ElementInfo info : this._galleryAddItems) {
                try {
                    this.addGalleryElement(info);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this._galleryAddItems = null;
        }
    }

    protected void removePendingGalleryItems() {
        if (this._galleryRemoveItems != null) {
            for (ElementInfo info : this._galleryRemoveItems) {
                this.removeGalleryElement(info);
            }
            this._galleryRemoveItems = null;
        }
    }

    private RootGalleryFolder getRootFolder() {
        this.addFolders();
        return (RootGalleryFolder)this.getGallery().getModel();
    }

    private void addFolders() {
        RootGalleryFolder rootfolder = (RootGalleryFolder)this.getGallery().getModel();
        if (this._foldersAdd != null) {
            for (FolderInfo folder : this._foldersAdd) {
                GalleryFolder gf = folder.getCategory() == null ? rootfolder.createFolder(folder.getName()) : rootfolder.createFolder(new String[]{folder.getCategory(), folder.getName()});
                gf.setUnsorted(folder.isUnsorted());
            }
            this._foldersAdd = null;
        }
    }

    private boolean addGalleryElement(ElementInfo info) {
        RootGalleryFolder rf = this.getRootFolder();
        GalleryFolder f = rf.createFolder(info.getPath());
        return f.addElement(info);
    }

    private boolean removeGalleryElement(ElementInfo info) {
        RootGalleryFolder rf = this.getRootFolder();
        GalleryFolder f = rf.getFolder(info.getPath());
        if (f == null) {
            return false;
        }
        return f.removeElement(info);
    }

    private void _invokeGallery(Context context) {
        this.getGallery().runDialog(context);
    }

    private boolean removeFromQueue(Collection items, ElementInfo info) {
        if (items == null) {
            return false;
        }
        boolean removed = false;
        if (!items.isEmpty() && items.contains(info)) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                ElementInfo next = (ElementInfo)it.next();
                if (!next.equals(info)) continue;
                it.remove();
                removed = true;
                break;
            }
        }
        return removed;
    }
}

