/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GallerySearchEvent;
import oracle.ide.gallery.GallerySearchListener;
import oracle.ide.gallery.RootGalleryFolder;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.nulls.NullIcon;
import oracle.ide.resource.GalleryArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.Wizard;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ModelUtil;

final class ObjectGalleryPanel
extends JPanel {
    private boolean _forciblyHideDescriptions;
    private static final Icon NULL_ICON = new NullIcon();
    private static final double MAIN_SPLITTER_RESIZE_WEIGHT = 0.33;
    private static final Border UNDERLINE_BORDER = BorderFactory.createCompoundBorder(JavatoolsBorderFactory.createBottomBorder((Color)SystemColor.controlShadow), BorderFactory.createEmptyBorder(1, 2, 1, 2));
    @Deprecated
    final JLabel lblFilter;
    @Deprecated
    final JComboBox comboFilter;
    @Deprecated
    final JSplitPane itemSplitPane;
    @Deprecated
    final DescriptionScrollPane jspDescription;
    @Deprecated
    final JList listItem;
    final SearchField searchField;
    final JPanel searchPanel;
    final JSplitPane splitPane;
    final JLabel lblCat;
    final JLabel lblItems;
    final JCheckBox chkShowAllDescriptions;
    final JLabel lblDescription;
    final JScrollPane jspTreeCat;
    final JScrollPane jspListItems;
    final JPanel itemsListHeaderPanel;
    final JPanel itemsContainerPanel;
    final JTable tableItems;
    final JTree treeCat;
    final GridBagLayout gridBagLayout1;
    final BorderLayout borderLayout;
    final TechScopesLink techscopeLink;
    final NoResultsFoundPanel expandSearchPanel;
    private String _title;
    private RootGalleryFolder _model;
    private Context _context;
    private TreeModel _treeModel;
    private AllItemsFolder _allItemsFolder;
    private boolean _filterByTechnology;
    private boolean _explicitInitialSel;
    private boolean _persistLastSelectionIndex;
    private final transient Map<String, String> _elementParentMap;

    private void $init$() {
        this._forciblyHideDescriptions = Boolean.parseBoolean(System.getProperty("hide-gallery-descriptions"));
        this.lblFilter = new JLabel();
        this.comboFilter = new JComboBox();
        this.itemSplitPane = new JSplitPane(0, true);
        this.jspDescription = new DescriptionScrollPane();
        this.listItem = new JList();
        this.searchField = new SearchField();
        this.searchPanel = new JPanel();
        this.splitPane = new JSplitPane(1, true);
        this.lblCat = new JLabel();
        this.lblItems = new JLabel();
        this.chkShowAllDescriptions = new JCheckBox();
        this.lblDescription = new JLabel();
        this.jspTreeCat = new JScrollPane();
        this.jspListItems = new JScrollPane(22, 31);
        this.itemsListHeaderPanel = new JPanel();
        this.itemsContainerPanel = new JPanel();
        this.tableItems = new ItemsTable(null);
        this.treeCat = new JTree();
        this.gridBagLayout1 = new GridBagLayout();
        this.borderLayout = new BorderLayout(5, 10);
        this.techscopeLink = new TechScopesLink();
        this._elementParentMap = new HashMap<String, String>();
    }

    ObjectGalleryPanel(RootGalleryFolder model, Context context) {
        this(model, context, false);
    }

    ObjectGalleryPanel(RootGalleryFolder model, Context context, boolean filterByTechnology) {
        this(model, context, filterByTechnology, null);
    }

    ObjectGalleryPanel(RootGalleryFolder model, Context context, boolean filterByTechnology, GallerySearchListener searchListener) {
        this.$init$();
        this._model = model;
        this._context = context;
        this._filterByTechnology = filterByTechnology;
        this.setName(filterByTechnology ? "NormalGalleryPanel" : "FilteredGalleryPanel");
        this.expandSearchPanel = new NoResultsFoundPanel(searchListener);
        this._persistLastSelectionIndex = true;
        try {
            this.jbInit();
            this.postInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout);
        this.setPreferredSize(new Dimension(450, 300));
        ResourceUtils.resButton((AbstractButton)this.chkShowAllDescriptions, (String)GalleryArb.getString((int)65));
        ResourceUtils.resLabel((JLabel)this.lblCat, (Component)this.treeCat, (String)GalleryArb.getString((int)137));
        ResourceUtils.resLabel((JLabel)this.lblItems, (Component)this.tableItems, (String)GalleryArb.getString((int)17));
        this.searchField.setName("SearchField");
        this.searchField.setStyle(SearchField.Style.FILTER);
        this.searchField.setKeyEventTargetComponent((Component)this.treeCat);
        this.searchPanel.setLayout(new GridBagLayout());
        this.expandSearchPanel.setName("NoResultsFound");
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 17;
        g.gridy = 0;
        g.gridx = 1;
        g.weightx = 0.5;
        g.fill = 2;
        g.weightx = 1.0;
        this.searchPanel.add((Component)this.searchField, g);
        ++g.gridx;
        this.searchPanel.add((Component)Box.createHorizontalBox(), g);
        ++g.gridx;
        this.treeCat.setName("CategoryList");
        this.treeCat.setExpandsSelectedPaths(true);
        this.treeCat.setRootVisible(false);
        this.treeCat.setShowsRootHandles(true);
        this.treeCat.getSelectionModel().setSelectionMode(1);
        this.jspTreeCat.setBorder(null);
        this.jspTreeCat.setColumnHeaderView(this.lblCat);
        this.jspTreeCat.setViewportView(this.treeCat);
        this.tableItems.setName("ItemsList");
        this.tableItems.setBorder(null);
        this.tableItems.setShowGrid(false);
        this.tableItems.setAutoscrolls(true);
        this.tableItems.setOpaque(true);
        this.tableItems.setBackground(Color.WHITE);
        this.tableItems.setTableHeader(null);
        this.tableItems.setColumnSelectionAllowed(false);
        this.tableItems.setSelectionMode(0);
        this.lblCat.setBorder(UNDERLINE_BORDER);
        this.jspListItems.setName("JSPItemsList");
        this.jspListItems.setBorder(BorderFactory.createEmptyBorder());
        this.jspListItems.getViewport().setBackground(Color.WHITE);
        this.splitPane.setName("ItemsListSplitPane");
        this.splitPane.setResizeWeight(0.33);
        this.itemsListHeaderPanel.setLayout(new GridBagLayout());
        this.itemsListHeaderPanel.setBorder(UNDERLINE_BORDER);
        GridBagConstraints g2 = new GridBagConstraints();
        g2.gridy = 0;
        g2.gridx = 0;
        g2.weightx = 1.0;
        g2.anchor = 17;
        g2.fill = 2;
        this.itemsListHeaderPanel.add((Component)this.lblItems, g2);
        ++g2.gridx;
        g2.anchor = 13;
        g2.fill = 0;
        this.itemsListHeaderPanel.add((Component)this.chkShowAllDescriptions, g2);
        this.itemsContainerPanel.setLayout(new BorderLayout());
        this.itemsContainerPanel.setBorder(null);
        this.itemsContainerPanel.setOpaque(true);
        this.itemsContainerPanel.setBackground(SystemColor.WHITE);
        this.itemsContainerPanel.add((Component)this.itemsListHeaderPanel, "North");
        this.jspListItems.setViewportView(this.tableItems);
        this.itemsContainerPanel.add((Component)this.jspListItems, "Center");
        this.splitPane.setLeftComponent(this.jspTreeCat);
        this.splitPane.setRightComponent(this.itemsContainerPanel);
        if (this.hasProjectContext() && !this.isAllScope()) {
            this.techscopeLink.setName("TechScopesLink");
            JPanel p = new JPanel(new BorderLayout(0, 10));
            p.add((Component)this.techscopeLink, "North");
            p.add((Component)this.searchPanel, "Center");
            this.add((Component)p, "North");
        } else {
            this.add((Component)this.searchPanel, "North");
        }
        this.add((Component)this.splitPane, "Center");
    }

    private void postInit() {
        this.treeCat.setCellRenderer(new CategoryTreeCellRenderer(null));
        this.tableItems.setDefaultRenderer(GalleryElement.class, new ItemTableCellRenderer(this._model.isShowDescriptions()));
        this.chkShowAllDescriptions.setSelected(this._model.isShowDescriptions());
        EventListener listener = new EventListener(null);
        this.addHierarchyListener(listener);
        this.tableItems.getSelectionModel().addListSelectionListener(listener);
        this.tableItems.addMouseListener(listener);
        this.treeCat.addTreeSelectionListener(listener);
        this.treeCat.addTreeExpansionListener(listener);
        this.searchField.addSearchListener((SearchListener)listener);
        this.chkShowAllDescriptions.addItemListener(listener);
        this.jspListItems.getViewport().addComponentListener(listener);
        this.initTitle();
        this.rebuildGallery();
        this.installKeyHandler();
        ToolTipManager.sharedInstance().registerComponent(this.treeCat);
    }

    private void installKeyHandler() {
        InputMap inputMap = this.tableItems.getInputMap(0);
        String actionMapKey = "nextBackEnter";
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "nextBackEnter");
        inputMap.put(KeyStroke.getKeyStroke(9, 1), "nextBackEnter");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "nextBackEnter");
        this.tableItems.getActionMap().put("nextBackEnter", new TableKeyboardAction(null));
    }

    private TreeModel createTreeModel() {
        ArrayList<GalleryElement> allElements = new ArrayList<GalleryElement>();
        GalleryTreeNode root = new GalleryTreeNode(this._model, allElements);
        this._allItemsFolder = new AllItemsFolder(allElements);
        root.add(new GalleryTreeNode(this._allItemsFolder, null));
        this._treeModel = new DefaultTreeModel(root);
        return this._treeModel;
    }

    private void initTitle() {
        String name = this.hasProjectContext() ? (this._filterByTechnology ? GalleryArb.getString((int)112) : GalleryArb.getString((int)280)) : GalleryArb.getString((int)305);
        this.searchField.setPrompt(String.format("%s %s", GalleryArb.getString((int)87), name));
        this.setTitle(name);
    }

    private GalleryFolder getGalleryFolder(TreePath path) {
        if (path == null) {
            return null;
        }
        Object lastPath = path.getLastPathComponent();
        if (!(lastPath instanceof GalleryTreeNode)) {
            return null;
        }
        GalleryTreeNode treeNode = (GalleryTreeNode)lastPath;
        return GalleryTreeNode.mav$getGalleryFolder(treeNode);
    }

    private void restoreTreeExpansion() {
        boolean autoExpand = this.isAllScope() ^ true;
        GalleryTreeNode root = this.getRoot();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            GalleryTreeNode node = (GalleryTreeNode)e.nextElement();
            GalleryFolder folder = GalleryTreeNode.mav$getGalleryFolder(node);
            if (!autoExpand && !folder.isExpanded()) continue;
            this.treeCat.expandPath(new TreePath(node.getPath()));
        }
    }

    private boolean restoreTreeSelection(TreePath selectedPath) {
        GalleryFolder selectedFolder = this.getGalleryFolder(selectedPath);
        if (selectedFolder instanceof AllItemsFolder) {
            TreePath path = new TreePath(new Object[]{this.getRoot(), this.getRoot().getLastChild()});
            this.treeCat.setSelectionPath(path);
            this.treeCat.scrollPathToVisible(path);
            return true;
        }
        GalleryTreeNode root = this.getRoot();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            GalleryTreeNode next = (GalleryTreeNode)e.nextElement();
            if (selectedFolder != next.getUserObject()) continue;
            TreePath path = new TreePath(next.getPath());
            this.treeCat.setSelectionPath(path);
            this.treeCat.scrollPathToVisible(path);
            return true;
        }
        this.treeCat.setSelectionRow(0);
        return false;
    }

    private GalleryTreeNode getRoot() {
        return (GalleryTreeNode)this._treeModel.getRoot();
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public void setInitialSelection(String wizName) {
        this.setInitialSelection(null, wizName);
    }

    protected void setInitialSelection(String folderName, String wizName) {
        GalleryTreeNode root = this.getRoot();
        if (folderName != null) {
            this._explicitInitialSel = true;
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                GalleryTreeNode next = (GalleryTreeNode)e.nextElement();
                GalleryFolder folder = (GalleryFolder)next.getUserObject();
                if (!folderName.equals(folder.getName())) continue;
                TreePath treePath = new TreePath(next.getPath());
                this.treeCat.setSelectionPath(treePath);
                this.treeCat.scrollPathToVisible(treePath);
                if (this.tableItems.getModel().getRowCount() > 0) {
                    this.tableItems.getSelectionModel().setSelectionInterval(0, 0);
                }
                root = next;
                break;
            }
        }
        if (wizName != null) {
            this._explicitInitialSel = true;
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                GalleryElement[] elements;
                GalleryTreeNode next = (GalleryTreeNode)e.nextElement();
                GalleryFolder folder = (GalleryFolder)next.getUserObject();
                GalleryElement[] galleryElementArray = elements = folder.getElementChildren();
                int n = 0;
                while (n < galleryElementArray.length) {
                    GalleryElement elem = galleryElementArray[n];
                    String elemWiz = elem.getWizardClass();
                    if (wizName.equals(elemWiz)) {
                        this.treeCat.setSelectionPath(new TreePath(next.getPath()));
                        int i = 0;
                        while (i < this.tableItems.getRowCount()) {
                            if (elem.equals(this.tableItems.getValueAt(i, 0))) {
                                this.tableItems.getSelectionModel().setSelectionInterval(i, i);
                                break;
                            }
                            ++i;
                        }
                        return;
                    }
                    ++n;
                }
            }
        }
    }

    GalleryElement getSelectedItem() {
        int row = this.tableItems.getSelectedRow();
        if (row != -1) {
            return (GalleryElement)this.tableItems.getValueAt(row, 0);
        }
        return null;
    }

    void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    int getMainDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    @Deprecated
    int getItemDividerLocation() {
        return -1;
    }

    void shouldRefresh() {
        this.chkShowAllDescriptions.setSelected(this._model.isShowDescriptions());
        TreePath selectedPath = this._model.getSelectedCategoryPath();
        if (selectedPath != null && !this.treeCat.getSelectionPath().equals(selectedPath) && this.restoreTreeSelection(selectedPath)) {
            this._persistLastSelectionIndex = true;
            this.restoreLastSelectedItem();
        }
    }

    private void restoreLastSelectedItem() {
        String savedItem = this._model.getLastSelectedItem();
        int rowCount = this.tableItems.getModel().getRowCount();
        int i = 0;
        while (i < rowCount) {
            GalleryElement galleryItem = (GalleryElement)this.tableItems.getValueAt(i, 0);
            if (ModelUtil.areEqual((Object)galleryItem.getName(), (Object)savedItem)) {
                this.tableItems.getSelectionModel().setSelectionInterval(i, i);
                this.scrollTableToSelectedRow();
                return;
            }
            ++i;
        }
        if (rowCount > 0 && this.tableItems.getSelectedRowCount() == 0) {
            this.tableItems.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void persistLastSelectedItem() {
        GalleryElement element = this.getSelectedItem();
        if (element != null) {
            this._model.setLastSelectedItem(element.getName());
        }
    }

    private void setShowAllDescriptions(boolean showAllDescriptions) {
        this._model.setShowDescriptions(showAllDescriptions);
    }

    private boolean isShowAllDescriptions() {
        return this._model.isShowDescriptions();
    }

    private boolean isAllScope() {
        return this._filterByTechnology ^ true;
    }

    private TechnologyScope getScope() {
        return !this.isAllScope() ? this.getProjectScope() : null;
    }

    private TechnologyScope getProjectScope() {
        if (this._context == null) {
            return null;
        }
        Project project = this._context.getProject();
        return project != null ? TechnologyScopeConfiguration.getInstance((PropertyStorage)project).getTechnologyScope() : null;
    }

    private boolean hasProjectScope() {
        TechnologyScope scope = this.getProjectScope();
        return scope != null && !scope.isEmpty();
    }

    private boolean hasProjectContext() {
        return this._context != null && this._context.getProject() != null;
    }

    private void rebuildGallery() {
        this.treeCat.setModel(this.createTreeModel());
        if (this.treeCat.getRowCount() > 0) {
            TreePath selectedPath = this._model.getSelectedCategoryPath();
            if (selectedPath != null) {
                this.restoreTreeExpansion();
                this._persistLastSelectionIndex = this.restoreTreeSelection(selectedPath);
            } else {
                IdeUtil.expandAllTreeRows((JTree)this.treeCat);
                this.treeCat.setSelectionRow(0);
            }
        }
        this.restoreLastSelectedItem();
    }

    private void scrollTableToSelectedRow() {
        int row = this.tableItems.getSelectedRow();
        Rectangle rect = this.tableItems.getCellRect(row, 0, true);
        this.tableItems.scrollRectToVisible(rect);
    }

    private String getParentFolderFor(GalleryElement element) {
        String key = element.getShortLabel();
        if (this._elementParentMap.containsKey(key)) {
            return this._elementParentMap.get(key);
        }
        return "";
    }

    void setTitle(String _title) {
        this._title = _title;
    }

    String getTitle() {
        return this._title;
    }

    private void fireInvokeWizardAction(GalleryElement element) {
        Wizard wiz = element.getWizard();
        if (wiz != null) {
            this.fireActionPerformed(wiz);
        } else {
            String message = GalleryArb.getString((int)223);
            boolean mType = false;
            String title = GalleryArb.getString((int)75);
            IdeMainWindow mainFrame = Ide.getMainWindow();
            JOptionPane.showMessageDialog((Component)mainFrame, message, title, 0);
        }
    }

    private void fireActionPerformed(Wizard event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        String actionCommand = "ITEM_INVOKED";
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ActionListener.class) {
                if (e == null) {
                    e = new ActionEvent(event, 1001, actionCommand, 0);
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            i -= 2;
        }
    }

    static Icon ra$NULL_ICON() {
        return NULL_ICON;
    }

    static Context ra$_context(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel._context;
    }

    static String mav$getParentFolderFor(ObjectGalleryPanel objectGalleryPanel, GalleryElement galleryElement) {
        return objectGalleryPanel.getParentFolderFor(galleryElement);
    }

    static boolean ra$_forciblyHideDescriptions(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel._forciblyHideDescriptions;
    }

    static void mav$scrollTableToSelectedRow(ObjectGalleryPanel objectGalleryPanel) {
        objectGalleryPanel.scrollTableToSelectedRow();
    }

    static GalleryFolder mav$getGalleryFolder(ObjectGalleryPanel objectGalleryPanel, TreePath treePath) {
        return objectGalleryPanel.getGalleryFolder(treePath);
    }

    static AllItemsFolder ra$_allItemsFolder(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel._allItemsFolder;
    }

    static GalleryTreeNode mav$getRoot(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel.getRoot();
    }

    static boolean ra$_explicitInitialSel(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel._explicitInitialSel;
    }

    static RootGalleryFolder ra$_model(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel._model;
    }

    static void mav$persistLastSelectedItem(ObjectGalleryPanel objectGalleryPanel) {
        objectGalleryPanel.persistLastSelectedItem();
    }

    static boolean mav$isAllScope(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel.isAllScope();
    }

    static void mav$fireInvokeWizardAction(ObjectGalleryPanel objectGalleryPanel, GalleryElement galleryElement) {
        objectGalleryPanel.fireInvokeWizardAction(galleryElement);
    }

    static boolean ra$_persistLastSelectionIndex(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel._persistLastSelectionIndex;
    }

    static void mav$setShowAllDescriptions(ObjectGalleryPanel objectGalleryPanel, boolean bl) {
        objectGalleryPanel.setShowAllDescriptions(bl);
    }

    static boolean mav$hasProjectContext(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel.hasProjectContext();
    }

    static TechnologyScope mav$getScope(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel.getScope();
    }

    static Map ra$_elementParentMap(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel._elementParentMap;
    }

    static TechnologyScope mav$getProjectScope(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel.getProjectScope();
    }

    static void mav$rebuildGallery(ObjectGalleryPanel objectGalleryPanel) {
        objectGalleryPanel.rebuildGallery();
    }

    final class NoResultsFoundPanel
    extends JPanel
    implements ActionListener {
        final JLabel feedback;
        final JButton expandSearch;
        final GallerySearchListener expandSearchListener;

        NoResultsFoundPanel(GallerySearchListener searchListener) {
            this.expandSearchListener = searchListener;
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            GridBagConstraints g = new GridBagConstraints();
            g.gridx = 0;
            g.gridy = 0;
            g.weightx = 1.0;
            g.anchor = 17;
            g.insets.bottom = 10;
            this.feedback = new JLabel();
            ResourceUtils.resLabel((JLabel)this.feedback, null, (String)GalleryArb.getString((int)116));
            this.add((Component)this.feedback, g);
            ++g.gridy;
            if (this.expandSearchListener != null) {
                this.expandSearch = new JButton();
                ResourceUtils.resButton((AbstractButton)this.expandSearch, (String)GalleryArb.getString((int)119));
                this.add((Component)this.expandSearch, g);
                this.expandSearch.addActionListener(this);
            } else {
                this.expandSearch = null;
            }
            g.fill = 1;
            g.weighty = 1.0;
            ++g.gridy;
            this.add((Component)Box.createVerticalBox(), g);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.expandSearchListener != null) {
                GallerySearchEvent itemSearchEvent = new GallerySearchEvent(this, ObjectGalleryPanel.this.searchField.getText());
                this.expandSearchListener.searchExpanded(itemSearchEvent);
            }
        }
    }

    public final class ItemTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private final Color descriptionForegroundColor;
        private final Color selectionHighlightColor;
        private final Color bandingBackgroundColor;
        private final Border paddedItemBorder;
        private final Border descriptionBorder;
        private final Border bottomOnlyBorder;
        private final Border topAndBottomBorder;
        private final JLabel _header;
        private final JLabel _headerDetail;
        private final JTextArea _description;
        private final GridBagConstraints _constraints;
        private boolean _showAllDescriptions;
        private boolean _showItemCategory;
        private AccessibleContext _accessibleContext;

        private void $init$() {
            this.descriptionForegroundColor = new Color(153, 153, 153);
            this.selectionHighlightColor = new Color(216, 236, 253);
            this.bandingBackgroundColor = new Color(250, 250, 250);
            this.paddedItemBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            this.descriptionBorder = BorderFactory.createEmptyBorder(0, 20, 0, 5);
            this.bottomOnlyBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(204, 204, 204)), this.paddedItemBorder);
            this.topAndBottomBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, new Color(204, 204, 204)), this.paddedItemBorder);
            this._header = new JLabel();
            this._headerDetail = new JLabel();
            this._description = new JTextArea();
            this._constraints = new GridBagConstraints();
        }

        ItemTableCellRenderer(boolean showDescriptions) {
            super(new GridBagLayout());
            this.$init$();
            this._showAllDescriptions = showDescriptions;
            this._description.setBorder(this.descriptionBorder);
            this._description.setEditable(false);
            this._description.setOpaque(false);
            this._description.setLineWrap(true);
            this._description.setWrapStyleWord(true);
            this._description.setForeground(this.descriptionForegroundColor);
            this._constraints.gridx = 0;
            this._constraints.insets = new Insets(0, 0, 0, 5);
            this._constraints.ipadx = 5;
            this.add((Component)this._header, this._constraints);
            this._constraints.gridx = 1;
            this._constraints.weightx = 0.5;
            this._constraints.fill = 2;
            this.add((Component)this._headerDetail, this._constraints);
            this._constraints.gridx = 0;
            this._constraints.gridwidth = 2;
            this._constraints.weighty = 1.0;
            this._constraints.fill = 1;
            this.add((Component)this._description, this._constraints);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof GalleryElement) {
                GalleryElement element = (GalleryElement)value;
                Icon enabledIcon = element.getIcon();
                Icon disabledIcon = element.getDisabledIcon();
                this._header.setIcon(enabledIcon != null ? enabledIcon : ObjectGalleryPanel.ra$NULL_ICON());
                this._header.setDisabledIcon(disabledIcon != null ? disabledIcon : ObjectGalleryPanel.ra$NULL_ICON());
                this._header.setText(element.getShortLabel());
                this._header.setFont(this._header.getFont().deriveFont(isSelected ? 1 : 0));
                boolean enabled = element.isAvailable(ObjectGalleryPanel.ra$_context(ObjectGalleryPanel.this));
                this._header.setEnabled(enabled && table.isEnabled());
                if (this._showItemCategory) {
                    this._headerDetail.setText(String.format("(%s)", ObjectGalleryPanel.mav$getParentFolderFor(ObjectGalleryPanel.this, element)));
                    this._headerDetail.setEnabled(this._header.isEnabled());
                } else {
                    this._headerDetail.setText("");
                }
                this._description.setText(element.getLongLabel());
                if (!ObjectGalleryPanel.ra$_forciblyHideDescriptions(ObjectGalleryPanel.this) && (isSelected || this._showAllDescriptions)) {
                    this._description.setForeground(isSelected ? SystemColor.controlText : this.descriptionForegroundColor);
                    this._description.setEnabled(enabled && table.isEnabled());
                    this.add((Component)this._description, this._constraints);
                    this.setBorder(this._showAllDescriptions ? this.bottomOnlyBorder : this.topAndBottomBorder);
                    this.setSize(this.getSize().width, 70);
                } else {
                    this.remove(this._description);
                    this.setBorder(this.paddedItemBorder);
                }
                this.setToolTipText(element.getToolTipText());
                Color bgcolor = row % 2 == 0 ? SystemColor.WHITE : this.bandingBackgroundColor;
                this.setBackground(isSelected ? this.selectionHighlightColor : bgcolor);
                int prefHeight = this.getPreferredSize().height;
                if (prefHeight != table.getRowHeight(row)) {
                    int adjustedHeight = Math.min(prefHeight, 250);
                    table.setRowHeight(row, adjustedHeight);
                }
            }
            return this;
        }

        public String getText() {
            return this._header.getText();
        }

        void setShowCategory(boolean show) {
            this._showItemCategory = show;
        }

        public AccessibleContext getAccessibleContext() {
            if (this._accessibleContext == null) {
                this._accessibleContext = new AccessibleItemTableCellRenderer(null);
            }
            return this._accessibleContext;
        }

        static JLabel ra$_header(ItemTableCellRenderer itemTableCellRenderer) {
            return itemTableCellRenderer._header;
        }

        static JTextArea ra$_description(ItemTableCellRenderer itemTableCellRenderer) {
            return itemTableCellRenderer._description;
        }

        static boolean ra$_showItemCategory(ItemTableCellRenderer itemTableCellRenderer) {
            return itemTableCellRenderer._showItemCategory;
        }

        private class AccessibleItemTableCellRenderer
        extends JComponent.AccessibleJComponent {
            public String getAccessibleName() {
                return ItemTableCellRenderer.ra$_header(ItemTableCellRenderer.this).getText();
            }

            public String getAccessibleDescription() {
                return ItemTableCellRenderer.ra$_header(ItemTableCellRenderer.this).getText() + " " + ItemTableCellRenderer.ra$_description(ItemTableCellRenderer.this).getText();
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LIST_ITEM;
            }

            public String getToolTipText() {
                return ItemTableCellRenderer.ra$_header(ItemTableCellRenderer.this).getText();
            }

            public int getAccessibleChildrenCount() {
                return 1;
            }

            private AccessibleItemTableCellRenderer() {
                super(ItemTableCellRenderer.this);
            }

            AccessibleItemTableCellRenderer(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }

    private static final class CategoryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            this.setToolTipText(this.getText());
            return this;
        }

        private CategoryTreeCellRenderer() {
        }

        CategoryTreeCellRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private final class EventListener
    implements ComponentListener,
    ItemListener,
    HierarchyListener,
    ListSelectionListener,
    MouseListener,
    SearchListener,
    TreeExpansionListener,
    TreeSelectionListener {
        private int _selectedItemTracker;

        public void itemStateChanged(ItemEvent e) {
            JCheckBox checkBox = (JCheckBox)e.getSource();
            boolean showDescriptions = checkBox.isSelected();
            ObjectGalleryPanel.mav$setShowAllDescriptions(ObjectGalleryPanel.this, showDescriptions);
            ItemTableCellRenderer oldRenderer = (ItemTableCellRenderer)ObjectGalleryPanel.this.tableItems.getDefaultRenderer(GalleryElement.class);
            ItemTableCellRenderer newRenderer = new ItemTableCellRenderer(showDescriptions);
            newRenderer.setShowCategory(ItemTableCellRenderer.ra$_showItemCategory(oldRenderer));
            GalleryTableModel model = (GalleryTableModel)ObjectGalleryPanel.this.tableItems.getModel();
            int row = ObjectGalleryPanel.this.tableItems.getSelectedRow();
            ObjectGalleryPanel.this.tableItems.setModel(new DefaultTableModel());
            ObjectGalleryPanel.this.tableItems.setDefaultRenderer(GalleryElement.class, newRenderer);
            ObjectGalleryPanel.this.tableItems.setModel(model);
            ObjectGalleryPanel.this.tableItems.getSelectionModel().setSelectionInterval(row, row);
            ObjectGalleryPanel.mav$scrollTableToSelectedRow(ObjectGalleryPanel.this);
        }

        public void hierarchyChanged(HierarchyEvent event) {
            ObjectGalleryPanel panel;
            if ((event.getChangeFlags() & (long)4) != 0L && (panel = (ObjectGalleryPanel)event.getSource()).isShowing()) {
                int mainDividerLocation = ObjectGalleryPanel.ra$_model(ObjectGalleryPanel.this).getMainDividerLocation();
                if (mainDividerLocation != 0) {
                    ObjectGalleryPanel.this.splitPane.setDividerLocation(mainDividerLocation);
                } else {
                    ObjectGalleryPanel.this.splitPane.setDividerLocation(ObjectGalleryPanel.this.splitPane.getResizeWeight());
                }
                ObjectGalleryPanel.this.removeHierarchyListener(this);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (!ObjectGalleryPanel.ra$_explicitInitialSel(ObjectGalleryPanel.this) && ObjectGalleryPanel.ra$_persistLastSelectionIndex(ObjectGalleryPanel.this)) {
                ObjectGalleryPanel.mav$persistLastSelectedItem(ObjectGalleryPanel.this);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (1 == e.getButton()) {
                Object value;
                int row;
                if (e.getClickCount() == 1) {
                    this._selectedItemTracker = ObjectGalleryPanel.this.tableItems.getSelectedRow();
                }
                if (e.getClickCount() == 2 && (row = ObjectGalleryPanel.this.tableItems.getSelectedRow()) == this._selectedItemTracker && (value = ObjectGalleryPanel.this.tableItems.getModel().getValueAt(row, 0)) instanceof GalleryElement) {
                    GalleryElement element = (GalleryElement)value;
                    ObjectGalleryPanel.mav$fireInvokeWizardAction(ObjectGalleryPanel.this, element);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void treeExpanded(TreeExpansionEvent e) {
            if (ObjectGalleryPanel.mav$isAllScope(ObjectGalleryPanel.this)) {
                GalleryFolder folder = ObjectGalleryPanel.mav$getGalleryFolder(ObjectGalleryPanel.this, e.getPath());
                folder.setExpanded(true);
            }
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            if (ObjectGalleryPanel.mav$isAllScope(ObjectGalleryPanel.this)) {
                GalleryFolder folder = ObjectGalleryPanel.mav$getGalleryFolder(ObjectGalleryPanel.this, e.getPath());
                folder.setExpanded(false);
            }
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath selectedPath = ObjectGalleryPanel.this.treeCat.getSelectionPath();
            GalleryFolder selFolder = ObjectGalleryPanel.mav$getGalleryFolder(ObjectGalleryPanel.this, selectedPath);
            GalleryTableModel model = new GalleryTableModel(selFolder);
            ObjectGalleryPanel.this.tableItems.setModel(model);
            ItemTableCellRenderer tableCellRenderer = (ItemTableCellRenderer)ObjectGalleryPanel.this.tableItems.getDefaultRenderer(GalleryElement.class);
            tableCellRenderer.setShowCategory(selFolder == ObjectGalleryPanel.ra$_allItemsFolder(ObjectGalleryPanel.this));
            if (!ObjectGalleryPanel.this.treeCat.isShowing()) {
                return;
            }
            this.makeTableVisible();
            if (!ObjectGalleryPanel.ra$_explicitInitialSel(ObjectGalleryPanel.this)) {
                ObjectGalleryPanel.ra$_model(ObjectGalleryPanel.this).setSelectedCategoryPath(selectedPath);
                ObjectGalleryPanel.mav$persistLastSelectedItem(ObjectGalleryPanel.this);
            }
        }

        public void searchPerformed(SearchEvent se) {
            TreePath selectedPath;
            GalleryFolder selFolder;
            TreePath selectedPath2;
            GalleryFolder selFolder2;
            if (se.getSearchText().length() > 0 && (selFolder2 = ObjectGalleryPanel.mav$getGalleryFolder(ObjectGalleryPanel.this, selectedPath2 = ObjectGalleryPanel.this.treeCat.getSelectionPath())) != ObjectGalleryPanel.ra$_allItemsFolder(ObjectGalleryPanel.this)) {
                TreePath path = new TreePath(new Object[]{ObjectGalleryPanel.mav$getRoot(ObjectGalleryPanel.this), ObjectGalleryPanel.mav$getRoot(ObjectGalleryPanel.this).getLastChild()});
                ObjectGalleryPanel.this.treeCat.setSelectionPath(path);
                ObjectGalleryPanel.this.treeCat.scrollPathToVisible(path);
                ObjectGalleryPanel.this.tableItems.setModel(new GalleryTableModel(ObjectGalleryPanel.ra$_allItemsFolder(ObjectGalleryPanel.this)));
            }
            if ((selFolder = ObjectGalleryPanel.mav$getGalleryFolder(ObjectGalleryPanel.this, selectedPath = ObjectGalleryPanel.this.treeCat.getSelectionPath())) == ObjectGalleryPanel.ra$_allItemsFolder(ObjectGalleryPanel.this)) {
                ObjectGalleryPanel.ra$_allItemsFolder(ObjectGalleryPanel.this).setSearchText(se.getSearchText());
                GalleryTableModel tableModel = (GalleryTableModel)ObjectGalleryPanel.this.tableItems.getModel();
                Object[] preSearchElems = tableModel.getGalleryElements();
                Object[] postSearchElems = ObjectGalleryPanel.ra$_allItemsFolder(ObjectGalleryPanel.this).getSortedElementChildren();
                if (!Arrays.equals(preSearchElems, postSearchElems)) {
                    tableModel.fireTableDataChanged();
                }
                if (tableModel.getRowCount() > 0) {
                    ObjectGalleryPanel.this.tableItems.getSelectionModel().setSelectionInterval(0, 0);
                    this.makeTableVisible();
                } else {
                    this.makeExpandSearchPanelVisible();
                }
            }
        }

        private void makeTableVisible() {
            if (ObjectGalleryPanel.this.tableItems.getModel().getRowCount() > 0) {
                ObjectGalleryPanel.this.tableItems.getSelectionModel().setSelectionInterval(0, 0);
            }
            ObjectGalleryPanel.this.jspListItems.setViewportView(ObjectGalleryPanel.this.tableItems);
            ObjectGalleryPanel.this.jspListItems.setVerticalScrollBarPolicy(22);
        }

        private void makeExpandSearchPanelVisible() {
            ObjectGalleryPanel.this.tableItems.getSelectionModel().clearSelection();
            ObjectGalleryPanel.this.jspListItems.setViewportView(ObjectGalleryPanel.this.expandSearchPanel);
            ObjectGalleryPanel.this.jspListItems.setVerticalScrollBarPolicy(20);
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        public void componentResized(ComponentEvent e) {
            ObjectGalleryPanel.mav$scrollTableToSelectedRow(ObjectGalleryPanel.this);
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }

        private EventListener() {
        }

        EventListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GalleryTreeNode
    extends DefaultMutableTreeNode {
        public GalleryTreeNode(GalleryFolder folder, List<GalleryElement> children) {
            super(folder);
            Object[] folders = folder.getFolderChildren();
            Arrays.sort(folders);
            int i = 0;
            while (i < folders.length) {
                Object f = folders[i];
                if (this.isAvailable((GalleryFolder)f)) {
                    this.add(new GalleryTreeNode((GalleryFolder)f, children));
                    if (children != null) {
                        GalleryElement[] galleryElementArray = ((GalleryFolder)f).getElementChildren();
                        int n = 0;
                        while (n < galleryElementArray.length) {
                            GalleryElement child = galleryElementArray[n];
                            String folderLabel = ((GalleryFolder)f).toString();
                            ObjectGalleryPanel.ra$_elementParentMap(ObjectGalleryPanel.this).put(child.getShortLabel(), folderLabel);
                            children.add(child);
                            ++n;
                        }
                    }
                }
                ++i;
            }
        }

        private boolean isAvailable(GalleryFolder f) {
            if (ObjectGalleryPanel.mav$isAllScope(ObjectGalleryPanel.this)) {
                return true;
            }
            return ObjectGalleryPanel.mav$hasProjectContext(ObjectGalleryPanel.this) ? f.isInScope(ObjectGalleryPanel.mav$getScope(ObjectGalleryPanel.this)) : f.isAvailable(ObjectGalleryPanel.ra$_context(ObjectGalleryPanel.this));
        }

        private GalleryFolder getGalleryFolder() {
            return (GalleryFolder)this.getUserObject();
        }

        static GalleryFolder mav$getGalleryFolder(GalleryTreeNode galleryTreeNode) {
            return galleryTreeNode.getGalleryFolder();
        }
    }

    private final class GalleryTableModel
    extends AbstractTableModel {
        final GalleryFolder _folder;
        final List<GalleryElement> _elements;

        public GalleryTableModel(GalleryFolder folder) {
            this._folder = folder;
            if (folder == null) {
                this._elements = Collections.emptyList();
            } else {
                this._elements = new ArrayList<GalleryElement>();
                this.refreshElements();
            }
        }

        private void refreshElements() {
            if (this._folder != null) {
                GalleryElement[] children;
                this._elements.clear();
                GalleryElement[] galleryElementArray = children = this._folder.getSortedElementChildren();
                int n = 0;
                while (n < galleryElementArray.length) {
                    GalleryElement e = galleryElementArray[n];
                    try {
                        if (ModelUtil.hasLength((String)e.getShortLabel()) && this.isAvailable(e)) {
                            this._elements.add(e);
                        }
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                    }
                    ++n;
                }
            }
        }

        public Class getColumnClass(int columnIndex) {
            return GalleryElement.class;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return this._elements.size();
        }

        public Object getValueAt(int row, int col) {
            return this._elements.get(row);
        }

        private boolean isAvailable(GalleryElement e) {
            if (ObjectGalleryPanel.mav$isAllScope(ObjectGalleryPanel.this)) {
                return true;
            }
            return ObjectGalleryPanel.mav$hasProjectContext(ObjectGalleryPanel.this) ? e.isInScope(ObjectGalleryPanel.mav$getScope(ObjectGalleryPanel.this)) : e.isAvailable(ObjectGalleryPanel.ra$_context(ObjectGalleryPanel.this));
        }

        public void fireTableDataChanged() {
            this.refreshElements();
            super.fireTableDataChanged();
        }

        GalleryElement[] getGalleryElements() {
            return this._elements.toArray(new GalleryElement[this._elements.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllItemsFolder
    extends GalleryFolder {
        private String searchText;

        AllItemsFolder(List<GalleryElement> children) {
            int count = children.size();
            if (count > 1) {
                HashSet<String> names = new HashSet<String>(count);
                Iterator<GalleryElement> elements = children.iterator();
                while (elements.hasNext()) {
                    String name = elements.next().getShortLabel();
                    if (names.add(name)) continue;
                    elements.remove();
                }
            }
            this.setList(children);
        }

        @Override
        public Icon getIcon() {
            return OracleIcons.getIcon((String)"new.png");
        }

        @Override
        public String getShortLabel() {
            return GalleryArb.getString((int)308);
        }

        @Override
        public String getName() {
            return this.getShortLabel();
        }

        @Override
        public String getLongLabel() {
            return this.getShortLabel();
        }

        @Override
        protected final GalleryElement[] getElementChildren() {
            GalleryElement[] elements = super.getElementChildren();
            if (this.getSearchText() != null && this.getSearchText().length() > 0) {
                ArrayList<GalleryElement> list = new ArrayList<GalleryElement>();
                Pattern pattern = Pattern.compile(this.getSearchText(), 2);
                GalleryElement[] galleryElementArray = elements;
                int n = 0;
                while (n < galleryElementArray.length) {
                    GalleryElement element = galleryElementArray[n];
                    if (pattern.matcher(element.getShortLabel()).find() || pattern.matcher(ObjectGalleryPanel.mav$getParentFolderFor(ObjectGalleryPanel.this, element)).find() || pattern.matcher(Arrays.toString(element.getTechnologyKeys())).find()) {
                        list.add(element);
                    }
                    ++n;
                }
                return list.toArray(new GalleryElement[list.size()]);
            }
            return elements;
        }

        void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        String getSearchText() {
            return this.searchText;
        }

        @Override
        protected final GalleryElement[] getSortedElementChildren() {
            GalleryElement[] children = this.getElementChildren();
            Arrays.sort(children, new LabelOnlyComparator(null));
            return children;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelOnlyComparator
    implements Comparator<GalleryElement> {
        @Override
        public int compare(GalleryElement o1, GalleryElement o2) {
            int compare = GalleryFolder.COLLATOR.compare(o1.getShortLabel(), o2.getShortLabel());
            return compare;
        }

        private LabelOnlyComparator() {
        }

        LabelOnlyComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class TechScopesLink
    extends JPanel
    implements ActionListener {
        JLabel _prefix;
        HyperlinkButton _techScopesLink;

        private void $init$() {
            this._prefix = new JLabel();
            this._techScopesLink = new HyperlinkButton();
        }

        TechScopesLink() {
            super(new FlowLayout(0, 2, 0));
            this.$init$();
            ResourceUtils.resLabel((JLabel)this._prefix, null, (String)GalleryArb.getString((int)262));
            ResourceUtils.resButton((AbstractButton)this._techScopesLink, (String)GalleryArb.getString((int)266));
            this._techScopesLink.addActionListener((ActionListener)this);
            this.add(this._prefix);
            this.add((Component)this._techScopesLink);
        }

        public void actionPerformed(ActionEvent e) {
            if (ObjectGalleryPanel.ra$_context(ObjectGalleryPanel.this) != null && ObjectGalleryPanel.ra$_context(ObjectGalleryPanel.this).getProject() != null) {
                TechnologyScope currentScope = ObjectGalleryPanel.mav$getProjectScope(ObjectGalleryPanel.this);
                ProjectPropertiesDialog.showDialog((Context)ObjectGalleryPanel.ra$_context(ObjectGalleryPanel.this), (Frame)Ide.getMainWindow(), (Project)ObjectGalleryPanel.ra$_context(ObjectGalleryPanel.this).getProject(), (String[])new String[]{"Technology Scope"});
                if (!currentScope.equals((Object)ObjectGalleryPanel.mav$getProjectScope(ObjectGalleryPanel.this))) {
                    ObjectGalleryPanel.mav$rebuildGallery(ObjectGalleryPanel.this);
                }
            }
        }
    }

    private class TableKeyboardAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent ae) {
            JTable table = (JTable)ae.getSource();
            String actionCommand = ae.getActionCommand();
            boolean tab = actionCommand.equals("\t");
            boolean enter = actionCommand.equals("\n");
            if (tab && (ae.getModifiers() & 1) == 1) {
                tab = false;
            }
            if (enter) {
                GalleryElement element = ObjectGalleryPanel.this.getSelectedItem();
                if (element != null) {
                    ObjectGalleryPanel.mav$fireInvokeWizardAction(ObjectGalleryPanel.this, element);
                }
            } else if (tab) {
                table.transferFocus();
            } else {
                table.transferFocusBackward();
            }
        }

        private TableKeyboardAction() {
        }

        TableKeyboardAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ItemsTable
    extends JTable {
        public void setModel(TableModel dataModel) {
            super.setModel(dataModel);
            int rows = this.getRowCount();
            int columns = this.getColumnCount();
            int i = 0;
            while (i < rows && columns > 0) {
                try {
                    this.prepareRenderer(this.getCellRenderer(i, 0), i, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }

        private ItemsTable() {
        }

        ItemsTable(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

