/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.ObjectGalleryPanel;
import oracle.ide.help.HelpSystem;

class TabbedObjectGalleryPanel
extends JTabbedPane
implements ChangeListener {
    private ObjectGalleryPanel[] _panels;
    private static final Border PANEL_BORDER = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private static final String HELP_ID = "f1_idenewobjectgallery_html";

    public TabbedObjectGalleryPanel(ObjectGalleryPanel ... panels) {
        this.setName("GalleryTabs");
        if (panels == null) {
            throw new NullPointerException("Array of panels should not be null");
        }
        if (panels.length == 0) {
            throw new IllegalArgumentException("No panels added");
        }
        ObjectGalleryPanel[] objectGalleryPanelArray = this._panels = panels;
        int n = 0;
        while (n < objectGalleryPanelArray.length) {
            ObjectGalleryPanel panel = objectGalleryPanelArray[n];
            panel.setBorder(PANEL_BORDER);
            this.add((Component)panel, panel.getTitle());
            ++n;
        }
        this.addChangeListener(this);
        HelpSystem hs = HelpSystem.getHelpSystem();
        if (hs != null) {
            hs.registerTopic((JComponent)this, HELP_ID);
        }
    }

    void addListSelectionListener(ListSelectionListener listener) {
        ObjectGalleryPanel[] objectGalleryPanelArray = this._panels;
        int n = 0;
        while (n < objectGalleryPanelArray.length) {
            ObjectGalleryPanel panel = objectGalleryPanelArray[n];
            panel.tableItems.getSelectionModel().addListSelectionListener(listener);
            ++n;
        }
    }

    void addActionListener(ActionListener listener) {
        ObjectGalleryPanel[] objectGalleryPanelArray = this._panels;
        int n = 0;
        while (n < objectGalleryPanelArray.length) {
            ObjectGalleryPanel panel = objectGalleryPanelArray[n];
            panel.addActionListener(listener);
            ++n;
        }
    }

    void setContext(Context context) {
        ObjectGalleryPanel[] objectGalleryPanelArray = this._panels;
        int n = 0;
        while (n < objectGalleryPanelArray.length) {
            ObjectGalleryPanel panel = objectGalleryPanelArray[n];
            panel.setContext(context);
            ++n;
        }
    }

    void setInitialSelection(String initialFolder, String initialSelection) {
        ObjectGalleryPanel[] objectGalleryPanelArray = this._panels;
        int n = 0;
        while (n < objectGalleryPanelArray.length) {
            ObjectGalleryPanel panel = objectGalleryPanelArray[n];
            panel.setInitialSelection(initialFolder, initialSelection);
            ++n;
        }
    }

    Component getInitialFocusComponent() {
        return this.getActivePanel();
    }

    int getMainDividerLocation() {
        return this.getActivePanel().getMainDividerLocation();
    }

    GalleryElement getSelectedItem() {
        return this.getActivePanel().getSelectedItem();
    }

    ObjectGalleryPanel getActivePanel() {
        return this._panels[this.getSelectedIndex()];
    }

    ObjectGalleryPanel getPanelAt(int index) {
        if (index >= this._panels.length) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._panels.length);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        return this._panels[index];
    }

    public void stateChanged(ChangeEvent e) {
        this.getActivePanel().shouldRefresh();
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this._panels.length) {
            super.setSelectedIndex(index);
        } else if (this._panels.length > 0) {
            super.setSelectedIndex(0);
        }
    }
}

