/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.tsql;

import oracle.dbtools.migration.parser.defaults.DefaultVariabletNameTranslator;
import oracle.dbtools.migration.workbench.core.preferences.ConfigurationData;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class TSQLVariableNameTranslator
extends DefaultVariabletNameTranslator {
    public static final String IDENTIFIER_SEPARATOR = ".";
    public static final String VARIABLE_PREFIX = "@";
    public static final String BRACKET_DELIMITER = "[]";
    public static final String ORACLE_QUOTED_DELIMITER = "\"";
    public static String PREPEND_VAR = "v_";

    public String translateVariableName(String string) {
        String string2 = this.prefixVarName(string = this.translateToVarFormat(string));
        return string2 != null ? string2 : PREPEND_VAR + string;
    }

    private String translateToVarFormat(String string) {
        String string2 = string = string.trim().startsWith(VARIABLE_PREFIX) ? string.trim().substring(1) : string.trim();
        if (string.length() > 28) {
            string = string.substring(0, 24) + string.substring(string.length() - 4);
        }
        return string;
    }

    public String translateAliasName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.startsWith("'") && string2.endsWith("'")) {
            string2 = ORACLE_QUOTED_DELIMITER + string2.substring(1, string2.length() - 1) + ORACLE_QUOTED_DELIMITER;
        } else if (string2.startsWith(ORACLE_QUOTED_DELIMITER) && string2.endsWith(ORACLE_QUOTED_DELIMITER)) {
            string2 = string2.substring(1, string2.length() - 1);
            while (string2.startsWith("'") && string2.endsWith("'")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            string2 = ORACLE_QUOTED_DELIMITER + string2 + ORACLE_QUOTED_DELIMITER;
        }
        string2 = string2.replace('.', '_');
        string2 = string2.replace('!', '_');
        return string2;
    }

    public String translateInParamName(String string) {
        string = this.translateToVarFormat(string);
        return this.prefixInParamName(string);
    }

    public String prefixVarName(String string) {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return null;
        }
        ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)preferences);
        return configurationData.getVarPrefix() + string;
    }

    public String prefixInParamName(String string) {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return null;
        }
        ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)preferences);
        return string;
    }
}

