/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.table.ResultsSetTableContextMenu;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.navigator.AbstractThirdPartyAddin;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.scriptrunner.CommandRegistry;
import oracle.dbtools.raptor.timesten.BasicObjectCheck;
import oracle.dbtools.raptor.timesten.TTDBEditorFactory;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseFactory;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.commands.AutoCommit;
import oracle.dbtools.raptor.timesten.commands.BuiltInProcedure;
import oracle.dbtools.raptor.timesten.commands.Describe;
import oracle.dbtools.raptor.timesten.commands.DsSize;
import oracle.dbtools.raptor.timesten.commands.TTVersion;
import oracle.dbtools.raptor.timesten.connection.TimesTenConnectionCreator;
import oracle.dbtools.raptor.timesten.connection.TimesTenConnectionListener;
import oracle.dbtools.raptor.timesten.controls.table.TimesTenCountRowsMenu;
import oracle.dbtools.raptor.timesten.format.TimesTenLoaderFormatter;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.net.URLPath;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class TTAddin
extends AbstractThirdPartyAddin {
    private static final Logger theLogger = Logger.getLogger(TTAddin.class.getPackage().getName());
    private static final String JDBC_JAR_REGEX = ".*ttjdbc5\\.jar!/$|.*classes1[45]\\.jar!/$";
    private final DBConfig theDbConfig = DBConfig.getInstance();

    public void initialize() {
        super.initialize();
        DatabaseFactory.registerDatabaseCreator((DatabaseFactory.DatabaseCreator)TimesTenPlugInDatabaseFactory.getInstance());
        URL[] uRLArray = this.theDbConfig.getThirdPartyPath().getEntries();
        URL uRL = null;
        for (int i = 0; i < uRLArray.length; ++i) {
            if (!uRLArray[i].toString().matches(JDBC_JAR_REGEX)) continue;
            theLogger.log(Level.INFO, "Found a TimesTen JDBC driver in User Preferences " + uRLArray[i].toString());
            uRL = uRLArray[i];
            break;
        }
        URLPath uRLPath = URLPath.newURLPathFromString((String)System.getenv("CLASSPATH"));
        URL[] uRLArray2 = uRLPath.getEntries();
        URL uRL2 = null;
        for (int i = 0; i < uRLArray2.length; ++i) {
            if (!uRLArray2[i].toString().matches(JDBC_JAR_REGEX)) continue;
            theLogger.log(Level.INFO, "Found a TimesTen JDBC driver " + uRLArray2[i].toString() + " in CLASSPATH");
            uRL2 = uRLArray2[i];
            break;
        }
        if (uRL2 == null && uRL == null) {
            return;
        }
        if (!(uRL2 == null || uRL != null && uRL.equals(uRL2))) {
            this.prependJdbcJar(uRL2, uRLArray);
        }
        ViewerAddin.registerPackage((String)"oracle.dbtools.raptor.timesten");
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.raptor.timesten");
        CommandRegistry.addListener(AutoCommit.class);
        CommandRegistry.addListener(Describe.class);
        CommandRegistry.addListener(DsSize.class);
        CommandRegistry.addListener(TTVersion.class);
        CommandRegistry.addListener(BuiltInProcedure.class);
        FormatRegistry.registerFormater((IResultFormatter)new TimesTenLoaderFormatter());
        BasicObjectCheck.registerACLObject();
        DBEditorFactoryRegistry.registerDBEditorFactory(TimesTenPlugInDatabaseImpl.class, (DBEditorFactory)TTDBEditorFactory.getInstance());
        ResultsSetTableContextMenu.getContextMenu().addContextMenuListener((ContextMenuListener)TimesTenCountRowsMenu.getInstance());
        Connections.getInstance().addConnectionListener((ConnectionListener)new TimesTenConnectionListener());
        System.setProperty("oracle.dbtools.raptor.timesten.recoverFromClosedCursor", Boolean.toString(true));
        DatabaseProvider.registerConnectionCreator((String)"TimesTen", (ConnectionCreator)new TimesTenConnectionCreator());
    }

    private void prependJdbcJar(URL uRL, URL[] uRLArray) {
        URLPath uRLPath = new URLPath(uRL);
        for (int i = 0; i < uRLArray.length; ++i) {
            if (uRLArray[i].equals(uRL)) {
                theLogger.log(Level.WARNING, "Removing duplicate entry " + uRLArray[i].toString() + " in CLASSPATH");
                continue;
            }
            uRLPath.add(uRLArray[i]);
        }
        this.theDbConfig.setThirdPartyPath(uRLPath);
        theLogger.log(Level.INFO, "Prepending " + uRL.toString() + " to User Preferences");
    }

    public String getSubType() {
        return "TimesTen";
    }
}

