/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.raptor.timesten.OracleTypeModeImpl;
import oracle.dbtools.raptor.timesten.TimesTenTypeModeImpl;
import oracle.dbtools.raptor.timesten.TypeMode;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.timesten.TimesTenDatabase;
import oracle.javatools.db.timesten.TimesTenDatabaseDescriptor;

public class TimesTenPlugInDatabaseFactory
extends DatabaseFactory.DatabaseCreator {
    private DatabaseDescriptor m_descriptor;
    private static TimesTenPlugInDatabaseFactory m_instance;

    private TimesTenPlugInDatabaseFactory() {
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        dataTypeRegistry.registerProvider((DataTypeRegistry.Registerer)new OracleTypeModeImpl.Registerer(), OracleTypeModeImpl.class);
        dataTypeRegistry.registerProvider((DataTypeRegistry.Registerer)new TimesTenTypeModeImpl.Registerer(), TimesTenTypeModeImpl.class);
    }

    static synchronized TimesTenPlugInDatabaseFactory getInstance() {
        if (m_instance == null) {
            m_instance = new TimesTenPlugInDatabaseFactory();
        }
        return m_instance;
    }

    protected Database createDatabaseImpl(String string, String string2, Connection connection) {
        if (this.isTimesTenConnection(connection)) {
            TypeMode typeMode = TimesTenPlugInDatabaseFactory.getTypeMode(connection);
            switch (typeMode) {
                case ORACLE_TYPE_MODE: {
                    return new OracleTypeModeImpl(string2, connection);
                }
                case TIMESTEN_TYPE_MODE: {
                    return new TimesTenTypeModeImpl(string2, connection);
                }
                case UNKNOWN_TYPE_MODE: {
                    return null;
                }
            }
        }
        return null;
    }

    protected boolean isTimesTenConnection(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                return string.startsWith("TimesTen");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    public static TypeMode getTypeMode(Connection connection) {
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall("call ttconfiguration");
            resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                if (!resultSet.getString(1).equals("TypeMode")) continue;
                String string = resultSet.getString(2);
                if (string.equals("0")) {
                    TypeMode typeMode = TypeMode.ORACLE_TYPE_MODE;
                    return typeMode;
                }
                if (string.equals("1")) {
                    TypeMode typeMode = TypeMode.TIMESTEN_TYPE_MODE;
                    return typeMode;
                }
                TypeMode typeMode = TypeMode.UNKNOWN_TYPE_MODE;
                return typeMode;
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return TypeMode.UNKNOWN_TYPE_MODE;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        if (TimesTenDatabase.class.isAssignableFrom(clazz)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new TimesTenDatabaseDescriptor();
            }
            return this.m_descriptor;
        }
        return null;
    }
}

