/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.TTIndexBuilder;
import oracle.dbtools.raptor.timesten.TTSequenceBuilder;
import oracle.dbtools.raptor.timesten.TypeMode;
import oracle.dbtools.raptor.timesten.ddlgen.TimesTenDDLGenerator;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Index;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.JdbcDatabaseImpl;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.timesten.TimesTenDatabase;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimesTenPlugInDatabaseImpl
extends JdbcDatabaseImpl
implements TimesTenDatabase {
    protected static final List theSupportedObjectTypes = Arrays.asList("TABLE", "VIEW", "MATERIALIZED VIEW", "SEQUENCE", "INDEX");
    private Map<String, String> theConfiguration = new HashMap<String, String>(64);
    public static final String CHAR_SEMANTICS = "unit";
    private String theCatalog;

    public TimesTenPlugInDatabaseImpl(String string, Connection connection) {
        super("IdeConnections", string, connection);
        try {
            this.theCatalog = connection.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.getDatabaseConfiguration();
        this.setDDLGenerator((DDLGenerator)new TimesTenDDLGenerator((DBObjectProvider)this));
    }

    private void getDatabaseConfiguration() {
        try {
            CallableStatement callableStatement = this.getConnection().prepareCall("call ttconfiguration");
            ResultSet resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                this.theConfiguration.put(resultSet.getString(1), resultSet.getString(2));
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public TypeMode getTypeMode() {
        String string = this.theConfiguration.get("TypeMode");
        if (string.equals("0")) {
            return TypeMode.ORACLE_TYPE_MODE;
        }
        if (string.equals("1")) {
            return TypeMode.TIMESTEN_TYPE_MODE;
        }
        throw new RuntimeException("Unknown type mode" + string);
    }

    public DataType getDataType(String string) {
        return super.getDataType(string.trim().toUpperCase());
    }

    public boolean canCreateDBObject(Schema schema, DBObjectProvider dBObjectProvider, String string) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createObject(SchemaObject schemaObject, boolean bl) throws DBException {
        SchemaObject schemaObject2;
        block5: {
            if (schemaObject == null) {
                throw new DBException(null, "NULL object in createObject()");
            }
            String string = schemaObject.getType();
            SchemaObject schemaObject3 = schemaObject2 = bl ? this.getObject(string, schemaObject.getSchema(), schemaObject.getName()) : null;
            if (!theSupportedObjectTypes.contains(schemaObject.getType())) throw new DBException((Throwable)new UnsupportedOperationException());
            try {
                this.createObjects(new SchemaObject[]{schemaObject}, schemaObject.getType(), bl);
            }
            catch (DBException dBException) {
                Throwable throwable = dBException.getCause();
                if (!(throwable instanceof SQLException)) break block5;
                int n = ((SQLException)throwable).getErrorCode();
                if (n == 955 || n == 12000 || n == 12006) throw dBException;
                try {
                    this.deleteObject(schemaObject, true);
                    throw dBException;
                }
                catch (DBException dBException2) {
                    // empty catch block
                }
                throw dBException;
            }
        }
        this.finishCreate(new SchemaObject[]{schemaObject}, new SchemaObject[]{schemaObject2});
    }

    private void createObjects(SchemaObject[] schemaObjectArray, String string, boolean bl) throws DBException {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Ddl[] ddlArray = new Ddl[schemaObjectArray.length];
        DDLGenerator dDLGenerator = this.getDDLGenerator();
        if (dDLGenerator != null) {
            for (int i = 0; i < schemaObjectArray.length; ++i) {
                ddlArray[i] = dDLGenerator.getCreateDDL(schemaObjectArray[i], false, false);
                if (ddlArray[i] == null) {
                    throw new DBException((Throwable)new UnsupportedOperationException());
                }
                if (!"INDEX".equals(schemaObjectArray[i].getType())) continue;
                arrayList.add(((Index)schemaObjectArray[i]).getTable());
            }
        }
        if (bl) {
            SchemaObject[] schemaObjectArray2 = new SchemaObject[schemaObjectArray.length];
            int n = 0;
            for (int i = 0; i < schemaObjectArray.length; ++i) {
                SchemaObject schemaObject = this.getObject(string, schemaObjectArray[i].getSchema(), schemaObjectArray[i].getName());
                if (schemaObject == null) continue;
                if (schemaObject == schemaObjectArray[i]) {
                    throw new DBException((Throwable)new IllegalStateException("new " + string + " == old " + string));
                }
                if (!this.canDelete(schemaObject, false)) {
                    throw new DBException((DBObject)schemaObject, "Cannot drop existing " + string);
                }
                schemaObjectArray2[n++] = schemaObject;
            }
            if (n > 0) {
                if (n < schemaObjectArray2.length) {
                    SchemaObject[] schemaObjectArray3 = schemaObjectArray2;
                    schemaObjectArray2 = new SchemaObject[n];
                    System.arraycopy(schemaObjectArray3, 0, schemaObjectArray2, 0, n);
                }
                this.deleteObjects(schemaObjectArray2, false);
            }
        }
        this.executeDdl(ddlArray, Ddl.s_ddlOrder, false);
        for (Table table : arrayList) {
            this.getObject("TABLE", table.getSchema(), table.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDdl(Ddl[] ddlArray, String[] stringArray, boolean bl) throws DBException {
        Connection connection;
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    for (int j = 0; j < ddlArray.length; ++j) {
                        String[] stringArray2;
                        if (null == ddlArray[j] || null == (stringArray2 = ddlArray[j].getArrayTrimSlash(stringArray[i]))) continue;
                        for (int k = 0; k < stringArray2.length; ++k) {
                            if (statement == null) {
                                statement = connection.createStatement();
                            }
                            this.sqlTrace(stringArray2[k]);
                            try {
                                statement.execute(stringArray2[k]);
                                continue;
                            }
                            catch (SQLException sQLException) {
                                if (bl) {
                                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                                    continue;
                                }
                                throw new DBException((Throwable)sQLException);
                            }
                            catch (Exception exception) {
                                throw new DBException((Throwable)exception);
                            }
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new DBException((Throwable)sQLException);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected void finishCreate(SchemaObject[] schemaObjectArray, SchemaObject[] schemaObjectArray2) throws DBException {
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        DBException dBException = null;
        for (int i = 0; i < schemaObjectArray.length; ++i) {
            SchemaObject schemaObject = schemaObjectArray[i];
            SchemaObject schemaObject2 = schemaObjectArray2 == null ? null : schemaObjectArray2[i];
            String string = schemaObject.getSchema().getName();
            Schema schema = this.getSchema(string);
            if (schemaObject2 != null) {
                this.uncacheObject(schemaObject2);
            }
            SchemaObject schemaObject3 = null;
            schemaObject3 = schemaObject.getType().equals("SEQUENCE") ? this.getCreatedSequenceObject(string, schemaObject.getName()) : (schemaObject.getType().equals("INDEX") ? this.getCreatedIndexObject(string, schemaObject.getName()) : this.getCreatedObject(schemaObject.getType(), schema, schemaObject.getName()));
            if (schemaObject3 == null) {
                DBException dBException2 = new DBException((DBObject)schemaObject, "Error fetching new object back from the database");
                if (dBException == null) {
                    dBException = dBException2;
                    continue;
                }
                dBException.setNextException(dBException2);
                continue;
            }
            if (schemaObject2 != null) {
                DBUtil.updateObjectAndIDs((DBObject)schemaObject2, (DBObject)schemaObject3);
                this.cacheObject(schemaObject2, false);
                DBObjectChange.fireObjectUpdated((SchemaObject)schemaObject2);
                continue;
            }
            arrayList.add(schemaObject3);
            this.cacheObject(schemaObject3, false);
        }
        if (arrayList.size() > 0) {
            SchemaObject[] schemaObjectArray3 = arrayList.toArray(new SchemaObject[arrayList.size()]);
            this.fireObjectsAdded(schemaObjectArray3[0].getSchema(), schemaObjectArray3);
        }
        if (dBException != null) {
            throw dBException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaObject getCreatedSequenceObject(String string, String string2) throws DBException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT NAME,OWNER FROM SYS.SEQUENCES WHERE OWNER='" + string + "' AND NAME='" + string2 + "'");
            while (resultSet.next()) {
                if (!resultSet.getString(1).trim().equals(string2) || !resultSet.getString(2).trim().equals(string)) continue;
                Schema schema = this.getSchema(string);
                Sequence sequence = new Sequence(string2, schema);
                return sequence;
            }
        }
        catch (SQLException sQLException) {
            SchemaObject schemaObject = null;
            return schemaObject;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaObject getCreatedIndexObject(String string, String string2) throws DBException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT IXNAME,IXOWNER FROM SYS.INDEXES WHERE IXOWNER='" + string + "' AND IXNAME='" + string2 + "'");
            while (resultSet.next()) {
                if (!resultSet.getString(1).trim().equals(string2) || !resultSet.getString(2).trim().equals(string)) continue;
                Schema schema = this.getSchema(string);
                Index index = new Index(string2, schema);
                return index;
            }
        }
        catch (SQLException sQLException) {
            SchemaObject schemaObject = null;
            return schemaObject;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    public String getUniqueName(String string, DBObject dBObject, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        string = this.normaliseType(string);
        if (!ModelUtil.hasLength((String)string2)) {
            string2 = string + 1;
        }
        if (dBObject instanceof Schema) {
            SchemaObject[] schemaObjectArray = null;
            try {
                schemaObjectArray = this.listObjects(this.listObjectTypes(), (Schema)dBObject);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (schemaObjectArray != null) {
                for (int i = 0; i < schemaObjectArray.length; ++i) {
                    if (string.equals("INDEX") || string.equals("CONSTRAINT")) {
                        if (schemaObjectArray[i].getType() == "VIEW") continue;
                        this.addChildrenNames(schemaObjectArray[i].getOwnedObjects(new String[]{string}), arrayList);
                        continue;
                    }
                    arrayList.add(schemaObjectArray[i].getName());
                }
            }
        } else if (dBObject instanceof SchemaObject) {
            this.addChildrenNames(dBObject.getOwnedObjects(new String[]{string}), arrayList);
        }
        return DBUtil.getUniqueName(arrayList, (String)string2);
    }

    private void addChildrenNames(DBObject[] dBObjectArray, Collection collection) {
        for (int i = 0; i < dBObjectArray.length; ++i) {
            collection.add(dBObjectArray[i].getName());
        }
    }

    protected Collection<SchemaObject> listObjectsImpl(String[] abstractSchemaObject, Schema schema, String string) throws DBException {
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        boolean bl = false;
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = null;
        String string2 = schema == null ? null : schema.getName();
        String string3 = string;
        for (String string4 : abstractSchemaObject) {
            if (string4.equalsIgnoreCase("INDEX")) {
                this.addIndexObjects(arrayList, string2, string);
                continue;
            }
            if (!string4.equalsIgnoreCase("SEQUENCE")) continue;
            this.addSequenceObjects(arrayList, string2, string);
        }
        try {
            databaseMetaData = this.getConnection().getMetaData();
            try {
                resultSet = databaseMetaData.getTables(this.theCatalog, this.isUseSchema() ? string2 : null, string3, (String[])abstractSchemaObject);
                bl = resultSet.next();
            }
            catch (SQLException sQLException) {
                if ("S1C00".equals(sQLException.getSQLState())) {
                    resultSet = databaseMetaData.getTables(this.theCatalog, null, null, (String[])abstractSchemaObject);
                    bl = resultSet.next();
                }
                throw sQLException;
            }
            while (bl) {
                String string4;
                AbstractSchemaObject abstractSchemaObject2 = null;
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                string4 = resultSet.getString(3);
                String string7 = resultSet.getString(4);
                if (this._catalogMatches(string5) && this._schemaMatches(string2, string6) && (string3 != null || this._tableMatches(string, string4))) {
                    abstractSchemaObject2 = (AbstractSchemaObject)this.createSchemaObject(string6, string4, string7);
                }
                if (abstractSchemaObject2 != null) {
                    this.markForLazyInit(abstractSchemaObject2);
                    arrayList.add((SchemaObject)abstractSchemaObject2);
                }
                bl = resultSet.next();
            }
        }
        catch (SQLException sQLException) {
            throw new DBException((Throwable)sQLException);
        }
        return arrayList;
    }

    private boolean _catalogMatches(String string) {
        return this.theCatalog == null || string == null || this.theCatalog.equals(string);
    }

    private boolean _schemaMatches(String string, String string2) {
        return !this.isUseSchema() || !ModelUtil.hasLength((String)string) || ModelUtil.areEqual((Object)string, (Object)string2);
    }

    private boolean _tableMatches(String string, String string2) {
        if (string == null) {
            return true;
        }
        String string3 = string.replaceAll("%", ".*");
        return string2.matches(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIndexObjects(List list, String string, String string2) throws DBException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT rtrim(IXNAME) FROM SYS.INDEXES WHERE rtrim(IXOWNER)='" + string + "'");
            AbstractSchemaObject abstractSchemaObject = null;
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (this._tableMatches(string2, string3)) {
                    abstractSchemaObject = (AbstractSchemaObject)this.createSchemaObject(string, string3, "INDEX");
                }
                if (abstractSchemaObject == null) continue;
                this.markForLazyInit(abstractSchemaObject);
                list.add(abstractSchemaObject);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSequenceObjects(List list, String string, String string2) throws DBException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT rtrim(NAME) FROM SYS.SEQUENCES WHERE rtrim(OWNER)='" + string + "'");
            AbstractSchemaObject abstractSchemaObject = null;
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (this._tableMatches(string2, string3)) {
                    abstractSchemaObject = (AbstractSchemaObject)this.createSchemaObject(string, string3, "SEQUENCE");
                }
                if (abstractSchemaObject == null) continue;
                this.markForLazyInit(abstractSchemaObject);
                list.add(abstractSchemaObject);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private Object createSchemaObject(String string, String string2, String string3) throws DBException {
        SchemaObject schemaObject = null;
        DBObjectBuilder dBObjectBuilder = this.getBuilderForType(string3);
        if (dBObjectBuilder != null) {
            Schema schema = this.getSchema(string);
            NameBasedID nameBasedID = new NameBasedID(string3, schema.getName(), string2, (AbstractDBObjectProvider)this);
            schemaObject = dBObjectBuilder.createObject(string2, schema, (DBObjectID)nameBasedID);
        }
        return schemaObject;
    }

    protected boolean canEditDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        return false;
    }

    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("INDEX", (DBObjectBuilder)new TTIndexBuilder((JdbcDatabase)this, this.theCatalog));
        this.registerBuilder("SEQUENCE", (DBObjectBuilder)new TTSequenceBuilder((JdbcDatabase)this, this.theCatalog));
    }

    public Schema getSchema(String string) throws DBException {
        Schema schema = super.getSchema(string);
        if (schema == null) {
            schema = new Schema(string);
        }
        return schema;
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        Registerer() {
        }

        public void registerDataTypes(DataTypeRegistry dataTypeRegistry) {
        }
    }
}

