/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.scriptrunner.CommandListener;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.ide.util.IdeUtil;

public class BuiltInProcedure
extends CommandListener {
    private static final Logger LOGGER = Logger.getLogger(BuiltInProcedure.class.getPackage().getName());
    private static final String BUILT_IN_REGEX = "^[cC][aA][lL][lL]\\s+[tT][tT].+";
    private static final int ROW_HEIGHT = 20;
    private static final byte SPACE_BETWEEN_COLUMNS = 2;

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        try {
            String string = connection.getMetaData().getDatabaseProductName();
            String string2 = sQLCommand.getSql();
            if (!string.equalsIgnoreCase("timesten")) {
                return false;
            }
            if (string2.matches(BUILT_IN_REGEX)) {
                LOGGER.log(Level.INFO, "Executing TimesTen built-in procedure " + string2);
                this.executeBuiltInProcedureSql(scriptRunnerContext, connection, string2);
                return true;
            }
            LOGGER.log(Level.INFO, "Passing miscellaneous " + string2 + " to TimesTen.");
            this.executeMiscellaneousSql(scriptRunnerContext, connection, string2);
            return true;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "sql  failed, " + exception.getLocalizedMessage());
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            try {
                scriptRunnerContext.getOutputStream().write((sQLCommand.getSql() + " failed: " + exception.getLocalizedMessage() + "\n").getBytes(IdeUtil.getIdeEncoding()));
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return true;
        }
    }

    private void executeMiscellaneousSql(ScriptRunnerContext scriptRunnerContext, Connection connection, String string) throws Exception {
        this.executeBuiltInProcedureSql(scriptRunnerContext, connection, string);
    }

    private void executeBuiltInProcedureSql(ScriptRunnerContext scriptRunnerContext, Connection connection, String string) throws Exception {
        Statement statement = null;
        Object var5_5 = null;
        try {
            statement = connection.createStatement();
            boolean bl = statement.execute(string);
            if (bl) {
                this.processResultSet(statement.getResultSet(), scriptRunnerContext, string);
            } else {
                scriptRunnerContext.getOutputStream().write((string + " succeeded.\n").getBytes(IdeUtil.getIdeEncoding()));
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void processResultSet(ResultSet resultSet, ScriptRunnerContext scriptRunnerContext, String string) throws Exception {
        MyResultSetModel myResultSetModel = new MyResultSetModel(resultSet);
        List list = myResultSetModel.generateASCIIOutput();
        for (String string2 : list) {
            scriptRunnerContext.getOutputStream().write(string2.getBytes(IdeUtil.getIdeEncoding()));
        }
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return BuiltInProcedure.toHexString(byArray, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(256);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(Integer.toHexString(0xFF & (short)byArray[i]));
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyResultSetModel
    extends AbstractTableModel {
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        private String[] theColumnNames;
        private int[] theColumnOffset;
        private int[] theColumnWidth;
        private int theNoColumns;
        private boolean[] theBinaryDataFlag;
        private int theMaxWidth;

        private MyResultSetModel(ResultSet resultSet) throws Exception {
            this.init(resultSet);
        }

        private void init(ResultSet resultSet) throws Exception {
            int n;
            int n2;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.theNoColumns = resultSetMetaData.getColumnCount();
            this.theColumnNames = new String[this.theNoColumns];
            this.theBinaryDataFlag = new boolean[this.theNoColumns];
            this.theColumnWidth = new int[this.theNoColumns];
            this.theColumnOffset = new int[this.theNoColumns];
            for (n2 = 1; n2 <= this.theNoColumns; ++n2) {
                this.theColumnNames[n2 - 1] = resultSetMetaData.getColumnName(n2);
                String string = resultSetMetaData.getColumnTypeName(n2);
                LOGGER.info("Column " + this.theColumnNames[n2 - 1] + " type " + string);
                string = resultSetMetaData.getColumnTypeName(n2);
                if (string.equals("BINARY") || string.equals("VARBINARY")) {
                    this.theBinaryDataFlag[n2 - 1] = true;
                }
                if (this.theColumnNames[n2 - 1].length() <= this.theColumnWidth[n2 - 1]) continue;
                this.theColumnWidth[n2 - 1] = this.theColumnNames[n2 - 1].length();
            }
            n2 = 0;
            while (resultSet.next()) {
                Object[] objectArray = new Object[this.theNoColumns];
                for (int i = 1; i <= this.theNoColumns; ++i) {
                    int n3;
                    objectArray[i - 1] = resultSet.getObject(i);
                    if (this.theBinaryDataFlag[i - 1]) {
                        objectArray[i - 1] = BuiltInProcedure.toHexString(resultSet.getBytes(i));
                    }
                    if (objectArray[i - 1] == null || (n3 = objectArray[i - 1].toString().trim().length()) <= this.theColumnWidth[i - 1]) continue;
                    this.theColumnWidth[i - 1] = n3;
                }
                this.theRows.add(objectArray);
                ++n2;
            }
            this.theColumnOffset[0] = 0;
            for (n = 1; n < this.theNoColumns; ++n) {
                this.theColumnOffset[n] = this.theColumnOffset[n - 1] + this.theColumnWidth[n - 1] + 2;
            }
            this.theMaxWidth = this.theColumnOffset[n - 1] + this.theColumnWidth[n - 1] + 8;
        }

        private List<String> generateASCIIOutput() {
            int n;
            int n2;
            ArrayList<String> arrayList = new ArrayList<String>(this.theRows.size());
            char[] cArray = new char[this.theMaxWidth];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = 32;
            }
            String string = new String(cArray);
            StringBuffer stringBuffer = null;
            Object object = null;
            arrayList.add("\n");
            stringBuffer = new StringBuffer(string);
            for (int i = 0; i < this.theNoColumns; ++i) {
                stringBuffer.insert(this.theColumnOffset[i], this.theColumnNames[i]);
            }
            stringBuffer.append("\n");
            arrayList.add(stringBuffer.toString());
            char[] cArray2 = null;
            stringBuffer = new StringBuffer(string);
            for (n2 = 0; n2 < this.theNoColumns; ++n2) {
                cArray2 = new char[this.theColumnWidth[n2]];
                for (n = 0; n < cArray2.length; ++n) {
                    cArray2[n] = 45;
                }
                stringBuffer.insert(this.theColumnOffset[n2], cArray2);
            }
            stringBuffer.append("\n");
            arrayList.add(stringBuffer.toString());
            for (n2 = 0; n2 < this.theRows.size(); ++n2) {
                stringBuffer = new StringBuffer(string);
                for (n = 0; n < this.theNoColumns; ++n) {
                    object = this.theRows.get(n2)[n];
                    if (object == null) continue;
                    stringBuffer.insert(this.theColumnOffset[n], object.toString().trim());
                }
                stringBuffer.append("\n");
                arrayList.add(stringBuffer.toString());
            }
            arrayList.add("\n" + this.theRows.size() + " rows selected\n");
            return arrayList;
        }

        @Override
        public int getColumnCount() {
            return this.theColumnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > this.theNoColumns) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public String getColumnName(int n) {
            return this.theColumnNames[n];
        }
    }
}

