/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.scriptrunner.CommandListener;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.ide.util.IdeUtil;

public class DsSize
extends CommandListener {
    private static final String DSSIZE_SQL = "SELECT PERM_ALLOCATED_SIZE, PERM_IN_USE_SIZE, PERM_IN_USE_HIGH_WATER,TEMP_ALLOCATED_SIZE,TEMP_IN_USE_SIZE,TEMP_IN_USE_HIGH_WATER FROM SYS.MONITOR";

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        try {
            String string = connection.getMetaData().getDatabaseProductName();
            if (sQLCommand.getSql().indexOf("dssize") == 0 && string.equalsIgnoreCase("timesten")) {
                DsSizeUnit dsSizeUnit = DsSizeUnit.KB;
                String string2 = sQLCommand.getSql();
                int n = sQLCommand.getSql().indexOf(" ");
                if (n > -1 && n++ < string2.length() && (string2.charAt(n) == 'm' || string2.charAt(n) == 'M')) {
                    dsSizeUnit = DsSizeUnit.MB;
                }
                String string3 = this.executeDsSizeSql(connection, dsSizeUnit);
                scriptRunnerContext.getOutputStream().write(("\n" + string2 + "\n").getBytes(IdeUtil.getIdeEncoding()));
                scriptRunnerContext.getOutputStream().write(string3.getBytes(IdeUtil.getIdeEncoding()));
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return false;
    }

    private String executeDsSizeSql(Connection connection, DsSizeUnit dsSizeUnit) throws Exception {
        Statement statement = null;
        Object var4_4 = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(DSSIZE_SQL);
            StringBuffer stringBuffer = new StringBuffer(512);
            while (resultSet.next()) {
                stringBuffer.append("PERM_ALLOCATED_SIZE:\t");
                stringBuffer.append((double)resultSet.getLong(1) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
                stringBuffer.append("PERM_IN_USE_SIZE:\t");
                stringBuffer.append((double)resultSet.getLong(2) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
                stringBuffer.append("PERM_IN_USE_HIGH_WATER:\t");
                stringBuffer.append((double)resultSet.getLong(3) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
                stringBuffer.append("TEMP_ALLOCATED_SIZE:\t");
                stringBuffer.append((double)resultSet.getLong(4) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
                stringBuffer.append("TEMP_IN_USE_SIZE:\t");
                stringBuffer.append((double)resultSet.getLong(5) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
                stringBuffer.append("TEMP_IN_USE_HIGH_WATER:\t");
                stringBuffer.append((double)resultSet.getLong(6) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DsSizeUnit {
        KB(1.0),
        MB(1024.0);

        private double factor;

        private DsSizeUnit(double d) {
            this.factor = d;
        }

        private double getFactor() {
            return this.factor;
        }
    }
}

