/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.commands;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.logging.Logger;

public class TTInstanceInformation {
    private static final Logger theLogger = Logger.getLogger(TTInstanceInformation.class.getPackage().getName());
    private static TTInstanceInformation INSTANCE;
    private static final String TT_VERSION_CMD = "ttVersion -m";
    private Properties theInstanceProperties = new Properties();
    private static final String ERROR_UNKNOWN_INSTANCE = "Cannot process Oracle TimesTen instance information, check Oracle TimesTen database installation and/or your environment.  Oracle TimesTen plug-in will NOT function properly.";
    private boolean theStatus;

    private TTInstanceInformation() {
        this.getInstanceInformation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInstanceInformation() {
        BufferedReader bufferedReader = null;
        try {
            String string;
            Process process = Runtime.getRuntime().exec(TT_VERSION_CMD);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("=");
                if (stringArray.length != 2) continue;
                this.theInstanceProperties.setProperty(stringArray[0].trim(), stringArray[1].trim());
            }
            this.setTheStatus(true);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static TTInstanceInformation getInstance() {
        return TTInstanceInformation.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TTInstanceInformation getInstance(Component component) {
        Class<TTInstanceInformation> clazz = TTInstanceInformation.class;
        synchronized (TTInstanceInformation.class) {
            if (INSTANCE == null) {
                INSTANCE = new TTInstanceInformation();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            INSTANCE.validate(component);
            return INSTANCE;
        }
    }

    public boolean accessControlEnabled() {
        boolean bl = false;
        if (this.theInstanceProperties.getProperty("access_control", "0").equalsIgnoreCase("1")) {
            theLogger.info("Instance " + this.getInstanceName() + "; access control is enabled.");
            bl = true;
        } else {
            theLogger.info("Instance " + this.getInstanceName() + "; no access control in place.");
        }
        return bl;
    }

    public String getInstanceName() {
        return this.theInstanceProperties.getProperty("instance", "Unknown");
    }

    public Properties getInstanceProperties() {
        return this.theInstanceProperties;
    }

    public String getEffectiveDaemonHome() {
        return this.theInstanceProperties.getProperty("effective_daemonhome");
    }

    public String getInstanceAdministrator() {
        return this.theInstanceProperties.getProperty("instance_admin");
    }

    public boolean isInstanceAdministrator(String string) {
        String string2 = this.getInstanceAdministrator();
        if (string2 == null) {
            return false;
        }
        return string.equals(this.getInstanceAdministrator());
    }

    public synchronized boolean isTheStatus() {
        return this.theStatus;
    }

    private synchronized void setTheStatus(boolean bl) {
        this.theStatus = bl;
    }

    public void validate() {
        this.validate(null);
    }

    public void validate(Component component) {
        if (this.isTheStatus() || component == null) {
            // empty if block
        }
    }
}

