/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.connection;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationType;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.timesten.connection.TimesTenConnectionCreator;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTConnectionPanel
extends IConnectionPanel {
    private static final String USER_SPECIFIED_DSN = "User specified";
    private static final String CLIENT_SERVER_ACTION_COMMAND = "C/S";
    private static final String DIRECT_ACTION_COMMAND = "Direct";
    private static final String[] ERROR_STRINGS = new String[]{"Connection cannot be empty for user specified DSN", "Connection string needs to include DSN attribute for user specified DSN", "Connection string cannot contain DSN attribute, DSN already selected", "Connection string cannot contain OraclePWD or PWD attributes", "Access control is enabled, username and/or password must be input"};
    private static final String PWD_REGEX = "\\s*[pP][wW][dD]\\s*=.*";
    private static final String ORACLE_PWD_REGEX = "\\s*[oO][rR][aA][cC][lL][eE][pP][wW][dD]\\s*=.*";
    public static final String ORACLE_PWD = "oraclePassword";
    private static final String TIMESTEN_DRIVERS_REGEX = "TimesTen\\s+Data\\s+Manager\\s+7\\.0|TimesTen\\s+Data\\s+Manager\\s+Debug\\s+7\\.0|TimesTen\\s+Client\\s+7\\.0|\\s*TimesTen\\s+7\\.0\\s+Driver\\s*|\\s*TimesTen\\s+7\\.0\\s+Client\\s+Driver\\s*";
    private static final Pattern TIMESTEN_DRIVERS_REGEX_PATTERN = Pattern.compile("TimesTen\\s+Data\\s+Manager\\s+7\\.0|TimesTen\\s+Data\\s+Manager\\s+Debug\\s+7\\.0|TimesTen\\s+Client\\s+7\\.0|\\s*TimesTen\\s+7\\.0\\s+Driver\\s*|\\s*TimesTen\\s+7\\.0\\s+Client\\s+Driver\\s*", 2);
    private static final String ODBC_REGISTRY_KEY = "SOFTWARE\\ODBC\\ODBC.INI";
    private static final String ODBC_DATA_SOURCES_REGISTRY_KEY = "\\ODBC Data Sources";
    private static final String DEFAULT_USER_ODBCINI_FILE = ".odbc.ini";
    private static final String DEFAULT_SYSTEM_ODBCINI_FILE = "sys.odbc.ini";
    private static final String DEFAULT_SYSTEM_INIFILE = "/var/TimesTen/sys.odbc.ini";
    private static final String COMMON_INIFILE = "/etc/odbc.ini";
    private static final String DATA_SOURCES_SECTION_REGEX = "\\[ODBC\\s+Data\\s+Sources\\]";
    private JComboBox theDsnList;
    private ButtonGroup theDriverButtonGroup;
    private JRadioButton theCSButton;
    private JRadioButton theDirectButton;
    public static final String DIRECT_DRIVER_CLASSNAME = "com.timesten.jdbc.TimesTenDriver";
    private List<String> theClientDSN = new ArrayList<String>(8);
    private List theCompleteDSNList = new ArrayList(32);
    private DsnSelectListener theDsnSelectListener;
    private JTextField theConnStrField;
    private JPasswordField theCachePWDField;
    private boolean theUserSpecifiedDSNFlag;
    private static Logger theLogger = Logger.getLogger(TTConnectionPanel.class.getPackage().getName());
    private TTInstanceInformation theInstance = TTInstanceInformation.getInstance();

    public TTConnectionPanel() {
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                TTConnectionPanel.this.theInstance.validate((Component)((Object)TTConnectionPanel.this));
                super.componentShown(componentEvent);
            }
        };
        this.addComponentListener(componentAdapter);
        this.init();
    }

    public static void addFile(File file) throws IOException {
        URL uRL = file.toURL();
        Class[] classArray = new Class[]{URL.class};
        PolicyClassLoader policyClassLoader = (PolicyClassLoader)ClassLoader.getSystemClassLoader();
        String string = "tt_jar";
        ConfigurationType configurationType = ConfigurationType.MAIN_CLASS_PATH_ELEMENT;
        ConfigurationOrigin configurationOrigin = new ConfigurationOrigin(configurationType, string);
        SharedCodeSource sharedCodeSource = policyClassLoader.addCodeSource(file, configurationOrigin);
        sharedCodeSource.toString();
    }

    private void init() {
        JRadioButton jRadioButton;
        JComponent jComponent;
        Insets insets = new Insets(10, 5, 0, 0);
        if (this.theDsnList == null) {
            this.setLayout(new GridBagLayout());
            jComponent = new JLabel("DSN");
            this.theDsnList = new JComboBox();
            ResourceUtils.resLabel((JLabel)jComponent, (Component)this.theDsnList, (String)"DSN");
            this.add(jComponent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
            this.add(this.theDsnList, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                this.processWindowsDsn();
            } else {
                this.processUnixDsn();
            }
            this.theDsnList.addItem(USER_SPECIFIED_DSN);
        }
        this.theDriverButtonGroup = new ButtonGroup();
        jComponent = new JRadioButton("Client/server", true);
        this.theCSButton = jComponent;
        ((AbstractButton)jComponent).setActionCommand(CLIENT_SERVER_ACTION_COMMAND);
        this.theDirectButton = jRadioButton = new JRadioButton("Direct driver");
        jRadioButton.setActionCommand(DIRECT_ACTION_COMMAND);
        if (this.theDsnList.getItemCount() == 1) {
            this.theUserSpecifiedDSNFlag = true;
            ((AbstractButton)jComponent).setEnabled(true);
            ((AbstractButton)jComponent).setSelected(true);
            jRadioButton.setEnabled(true);
        } else {
            ((AbstractButton)jComponent).setEnabled(false);
            jRadioButton.setEnabled(false);
        }
        this.theDriverButtonGroup.add((AbstractButton)jComponent);
        this.theDriverButtonGroup.add(jRadioButton);
        this.theDsnSelectListener = new DsnSelectListener(this.theDriverButtonGroup);
        this.theDsnList.addActionListener(this.theDsnSelectListener);
        this.add(new JLabel("Connection type"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(jComponent);
        jPanel.add(jRadioButton);
        this.add(jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.1, 23, 0, insets, 0, 0));
        JLabel jLabel = new JLabel("Connection string");
        this.add(jLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.theConnStrField = new JTextField(" ", 32);
        this.add(this.theConnStrField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        JLabel jLabel2 = new JLabel("Oracle Password (for Cache)");
        this.add(jLabel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.9, 23, 0, insets, 0, 0));
        this.theCachePWDField = new JPasswordField(16);
        this.add(this.theCachePWDField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.9, 23, 2, insets, 0, 0));
    }

    public void clear() {
        this.theDsnList.setSelectedIndex(-1);
        this.theConnStrField.setText("");
        this.theCachePWDField.setText("");
        this.theUserSpecifiedDSNFlag = false;
        this._cd.usePassword(true);
        this._cd.useUserName(true);
    }

    public Properties getConnectionProperties(boolean bl) {
        theLogger.info("Include OraclePWD " + bl);
        Properties properties = this.m_props;
        properties.put("RaptorConnectionType", "TimesTen");
        properties.put("driver", DIRECT_DRIVER_CLASSNAME);
        properties.put("subtype", "TimesTen");
        properties.put("user", this.getUserName());
        properties.put("password", this.getPassword());
        String string = this.getDSNUrl();
        if (string == null) {
            return null;
        }
        properties.put("URL", string);
        properties.put("customUrl", string);
        String string2 = new String(this.theCachePWDField.getPassword());
        if (string2.length() > 0) {
            properties.put(ORACLE_PWD, string2);
        }
        this.suppressPasswordAndUserName(properties, TTConnectionPanel.isCSUrl(string));
        return properties;
    }

    private String getDSNUrl() {
        boolean bl = false;
        String string = this.theConnStrField.getText().toUpperCase().trim();
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("jdbc:timesten:");
        String string2 = this.theDsnList.getSelectedItem().toString();
        if (this.theUserSpecifiedDSNFlag) {
            if (string.indexOf("DSN=") == -1) {
                JOptionPane.showMessageDialog((Component)this.getDialog(), ERROR_STRINGS[1], "Invalid connection string", 0);
                this.setErrorStatus(ERROR_STRINGS[1]);
                return null;
            }
            if (this.hasPassword(string)) {
                JOptionPane.showMessageDialog((Component)this.getDialog(), ERROR_STRINGS[3], "Invalid connection string", 0);
                this.setErrorStatus(ERROR_STRINGS[3]);
                return null;
            }
            if (this.theDriverButtonGroup.getSelection().getActionCommand().equals(CLIENT_SERVER_ACTION_COMMAND)) {
                bl = true;
            }
        } else {
            if (string.indexOf("DSN=") != -1) {
                JOptionPane.showMessageDialog((Component)this.getDialog(), ERROR_STRINGS[2], "Invalid connection string", 0);
                this.setErrorStatus(ERROR_STRINGS[2]);
                return null;
            }
            if (this.hasPassword(string)) {
                JOptionPane.showMessageDialog((Component)this.getDialog(), ERROR_STRINGS[3], "Invalid connection string", 0);
                this.setErrorStatus(ERROR_STRINGS[3]);
                return null;
            }
            bl = this.isCSDsn(string2);
            string = "DSN=" + string2 + ";" + string;
        }
        stringBuffer.append(bl ? "client:" : "direct:");
        stringBuffer.append(string);
        stringBuffer.append(";ConnectionName=");
        stringBuffer.append(this.getConnectionName());
        return stringBuffer.toString();
    }

    public void testConnection(Properties properties) throws ConnectionException {
        Properties properties2 = this.getConnectionProperties(true);
        if (properties2 == null) {
            this.setStatus("Cannot obtain connection descriptor, test failed");
            throw new ConnectionException("Cannot obtain connection descriptor, test failed");
        }
        if (TimesTenConnectionCreator.shouldPromptForPasswordImpl(properties)) {
            this.setErrorStatus(ConnectionDialogArb.getString((int)28) + ERROR_STRINGS[4]);
            theLogger.log(Level.SEVERE, ERROR_STRINGS[4]);
            throw new ConnectionException(ERROR_STRINGS[4]);
        }
        theLogger.log(Level.INFO, "Testing TimesTen connection " + this.getConnectionName());
        try {
            theLogger.log(Level.INFO, "Start testing TimesTen connection " + this.getConnectionName());
            Connection connection = DatabaseConnections.getInstance().getConnection(properties2);
            this.getDialog().setPassword(properties2.getProperty("password"));
            if (this.isCache(properties2)) {
                this.testCacheConnection(connection);
            }
            theLogger.log(Level.INFO, "TimesTen connection to " + this.getConnectionName() + " succeeded.");
            this.setStatus(ConnectionDialogArb.getString((int)27));
        }
        catch (Exception exception) {
            theLogger.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            this.setErrorStatus(ConnectionDialogArb.getString((int)28) + exception.getLocalizedMessage());
            theLogger.log(Level.SEVERE, exception.getLocalizedMessage());
            throw new ConnectionException(exception.getLocalizedMessage());
        }
    }

    public static boolean isCSUrl(String string) {
        return string.indexOf(":client:") != -1;
    }

    private boolean isCSDsn(String string) {
        return this.theClientDSN.contains(string);
    }

    private void suppressPasswordAndUserName(Properties properties, boolean bl) {
        boolean bl2 = this.theInstance.accessControlEnabled();
        if (bl2 && properties != null && (this.getUserName() == null || this.getUserName().equals(this.getCurrentUserName()))) {
            theLogger.log(Level.INFO, "Access control enabled, suppress password for external user");
            properties.remove("password");
        }
    }

    private String getCurrentUserName() {
        String string = "";
        try {
            string = System.getProperty("user.name");
            theLogger.info("Current user name " + string);
        }
        catch (Exception exception) {
            theLogger.log(Level.WARNING, "Cannot get login name", exception);
        }
        return string;
    }

    public void updatePrompts(Properties properties) {
        String[] stringArray = properties.getProperty("URL").split(";");
        StringBuffer stringBuffer = new StringBuffer(32);
        for (String string : stringArray) {
            String[] stringArray2;
            if (string.length() == 0 || (stringArray2 = string.split("=")).length == 0 || stringArray2[0].equals("ConnectionName")) continue;
            if (stringArray2[0].startsWith("jdbc:timesten:")) {
                if (this.theCompleteDSNList.contains(stringArray2[1])) {
                    this.theDsnList.setSelectedItem(stringArray2[1]);
                    continue;
                }
                this.theDsnList.setSelectedItem(USER_SPECIFIED_DSN);
                this.theDirectButton.setEnabled(true);
                this.theCSButton.setEnabled(true);
                this.theCSButton.setSelected(false);
                this.theDirectButton.setSelected(false);
                if (stringArray2[0].indexOf("client") != -1) {
                    this.theCSButton.setSelected(true);
                } else {
                    this.theDirectButton.setSelected(true);
                }
                stringBuffer.append("DSN=" + stringArray2[1] + ";");
                continue;
            }
            stringBuffer.append(string + ";");
        }
        this.theConnStrField.setText(stringBuffer.toString());
        String string = properties.getProperty(ORACLE_PWD);
        if (string != null) {
            this.theCachePWDField.setText(string);
        }
    }

    public String getDriver() {
        return DIRECT_DRIVER_CLASSNAME;
    }

    private boolean hasPassword(String string) {
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].matches(PWD_REGEX) && !stringArray[i].matches(ORACLE_PWD_REGEX)) continue;
            return true;
        }
        return false;
    }

    private boolean isCache(Properties properties) {
        return properties.getProperty(ORACLE_PWD) != null;
    }

    private boolean testCacheConnection(Connection connection) throws ConnectionException {
        Statement statement = null;
        Statement statement2 = null;
        try {
            theLogger.info("Testing end-to-end Oracle connectivity for Cache connection");
            connection.setAutoCommit(false);
            statement2 = connection.prepareStatement("call ttOptSetFlag('Passthrough',3)");
            statement2.execute();
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select * from dual");
            resultSet.next();
            resultSet.close();
            statement.close();
            statement2.close();
            connection.rollback();
            theLogger.info("End-to-end Oracle connectivity for Cache connection succeeded.");
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            this.setErrorStatus("Cannot connect to Oracle " + sQLException.getMessage());
            theLogger.log(Level.SEVERE, "Cannot connect to Oracle " + sQLException.getMessage());
            throw new ConnectionException("Cannot connect to Oracle " + sQLException.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setDefaultPrompts() {
    }

    private List<String> getUnixODBCFiles() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        try {
            String string = System.getProperty("user.home");
            String string2 = string + "/" + DEFAULT_USER_ODBCINI_FILE;
            String string3 = System.getProperty("ODBCINI", string2);
            theLogger.log(Level.INFO, "Using ODBCINI file " + string3);
            arrayList.add(string3);
            String string4 = this.theInstance.getEffectiveDaemonHome();
            String string5 = string4 + "/" + DEFAULT_SYSTEM_ODBCINI_FILE;
            String string6 = System.getProperty("SYSODBCINI", string5);
            theLogger.log(Level.INFO, "Using SYSODBCINI file " + string6);
            arrayList.add(string6);
            arrayList.add(DEFAULT_SYSTEM_INIFILE);
            arrayList.add(COMMON_INIFILE);
            return arrayList;
        }
        catch (Exception exception) {
            theLogger.log(Level.WARNING, "Cannot access one or more system properties, DSN list may be incomplete", exception);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] getDsnListFromOdbcIniFile(String string) {
        Object[] objectArray = new Object[2];
        ArrayList<String> arrayList = new ArrayList<String>(8);
        ArrayList<String> arrayList2 = new ArrayList<String>(8);
        objectArray[0] = arrayList;
        objectArray[1] = arrayList2;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return objectArray;
        }
        try {
            String string2;
            theLogger.info("Processing " + string);
            bufferedReader = new BufferedReader(fileReader);
            boolean bl = false;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string2.matches("\\s*#.*")) continue;
                if (string2.matches("\\s*\\[.*\\]") && bl) {
                    break;
                }
                if (string2.matches(DATA_SOURCES_SECTION_REGEX)) {
                    theLogger.info("Found data store section<" + string2 + ">");
                    bl = true;
                    continue;
                }
                if (!bl || (stringArray = string2.split("=")).length != 2 || !TIMESTEN_DRIVERS_REGEX_PATTERN.matcher(stringArray[1]).matches()) continue;
                arrayList.add(stringArray[0].trim());
                if (stringArray[1].toUpperCase().indexOf("CLIENT") == -1) continue;
                arrayList2.add(stringArray[0].trim());
            }
        }
        catch (IOException iOException) {
            theLogger.log(Level.WARNING, "Unexpected IO error", iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return objectArray;
    }

    private void processUnixDsn() {
        List<String> list = this.getUnixODBCFiles();
        for (String string : list) {
            Object[] objectArray = TTConnectionPanel.getDsnListFromOdbcIniFile(string);
            List list2 = (List)objectArray[0];
            List list3 = (List)objectArray[1];
            for (String string2 : list2) {
                if (this.theCompleteDSNList.contains(string2)) continue;
                this.theCompleteDSNList.add(string2);
            }
            this.theClientDSN.addAll(list3);
        }
        Collections.sort(this.theCompleteDSNList);
        for (String string : this.theCompleteDSNList) {
            this.theDsnList.addItem(string);
        }
    }

    private void processWindowsDsn() {
        NativeHandler nativeHandler = new NativeHandler();
        nativeHandler.initialize();
        this.processWindowsSystemDsn(nativeHandler);
        this.processWindowsUserDsn(nativeHandler);
        Collections.sort(this.theCompleteDSNList);
        for (Object e : this.theCompleteDSNList) {
            this.theDsnList.addItem(e);
        }
        try {
            Class<?> clazz = Class.forName(DIRECT_DRIVER_CLASSNAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processWindowsSystemDsn(NativeHandler nativeHandler) {
        try {
            RegistryKey registryKey = NativeHandler.getRegistry().getLocalMachineKey().openKey(ODBC_REGISTRY_KEY, 131097L);
            Iterator iterator = registryKey.iterateSubKeys();
            Object var4_6 = null;
            String string = "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources";
            RegistryKey registryKey2 = NativeHandler.getRegistry().getLocalMachineKey().openKey(string, 131097L);
            this.addToWindowsDsnList(iterator, registryKey2);
        }
        catch (RegistryNotAvailableException registryNotAvailableException) {
            theLogger.log(Level.WARNING, registryNotAvailableException.getStackTrace()[0].toString(), registryNotAvailableException);
        }
        catch (RegistryException registryException) {
            theLogger.log(Level.WARNING, registryException.getStackTrace()[0].toString(), registryException);
        }
    }

    private void processWindowsUserDsn(NativeHandler nativeHandler) {
        try {
            RegistryKey registryKey = NativeHandler.getRegistry().getCurrentUserKey().openKey(ODBC_REGISTRY_KEY, 131097L);
            Iterator iterator = registryKey.iterateSubKeys();
            Object var4_6 = null;
            String string = "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources";
            RegistryKey registryKey2 = NativeHandler.getRegistry().getCurrentUserKey().openKey(string, 131097L);
            this.addToWindowsDsnList(iterator, registryKey2);
        }
        catch (RegistryNotAvailableException registryNotAvailableException) {
            theLogger.log(Level.WARNING, registryNotAvailableException.getStackTrace()[0].toString(), registryNotAvailableException);
        }
        catch (RegistryException registryException) {
            theLogger.log(Level.WARNING, registryException.getStackTrace()[0].toString(), registryException);
        }
    }

    private void addToWindowsDsnList(Iterator iterator, RegistryKey registryKey) {
        String string = null;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            string = e.toString();
            try {
                String string2 = registryKey.getStringValue(string);
                if (!string2.matches(TIMESTEN_DRIVERS_REGEX) || this.theCompleteDSNList.contains(e)) continue;
                this.theCompleteDSNList.add(e);
                if (string2.indexOf("Client") == -1) continue;
                this.theClientDSN.add(e.toString());
            }
            catch (RegistryException registryException) {}
        }
    }

    public Properties getConnectionProperties() {
        return this.getConnectionProperties(false);
    }

    public String getConnectionType() {
        return "TimesTen";
    }

    private class DsnSelectListener
    implements ActionListener {
        private final ButtonGroup theBg;

        DsnSelectListener(ButtonGroup buttonGroup) {
            this.theBg = buttonGroup;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = TTConnectionPanel.this.theDsnList.getSelectedItem().toString();
            if (string.equals(TTConnectionPanel.USER_SPECIFIED_DSN)) {
                TTConnectionPanel.this.theUserSpecifiedDSNFlag = true;
            } else {
                TTConnectionPanel.this.suppressPasswordAndUserName((Properties)((ConnectionDescriptor)null), TTConnectionPanel.this.isCSDsn(string));
            }
            TTConnectionPanel.this.theUserSpecifiedDSNFlag = string.equals(TTConnectionPanel.USER_SPECIFIED_DSN);
            Enumeration<AbstractButton> enumeration = this.theBg.getElements();
            while (enumeration.hasMoreElements()) {
                if (TTConnectionPanel.this.theUserSpecifiedDSNFlag || TTConnectionPanel.this.theDsnList.getItemCount() == 1) {
                    enumeration.nextElement().setEnabled(true);
                    continue;
                }
                enumeration.nextElement().setEnabled(false);
            }
        }
    }
}

