/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.connection;

import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public class TimesTenConnectionCreator
extends AbstractConnectionCreator {
    public static final String SUBTYPE_THIRD_PARTY = "TimesTen";
    private static final Logger LOGGER = Logger.getLogger(TimesTenConnectionCreator.class.getPackage().getName());

    protected void setCustomProperties(Properties properties, Properties properties2) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (properties2.getProperty(string) != null) continue;
            properties2.setProperty(string, properties.getProperty(string));
        }
    }

    protected boolean allowNullPassword() {
        return true;
    }

    public boolean shouldEncrypt(String string) {
        if (string.equals("oraclePassword")) {
            return true;
        }
        return super.shouldEncrypt(string);
    }

    public boolean shouldPromptForPassword(Properties properties) {
        boolean bl = TimesTenConnectionCreator.shouldPromptForPasswordImpl(properties);
        return bl;
    }

    public static boolean shouldPromptForPasswordImpl(Properties properties) {
        String string = properties.getProperty("user");
        String string2 = properties.getProperty("password");
        TTInstanceInformation tTInstanceInformation = TTInstanceInformation.getInstance();
        boolean bl = tTInstanceInformation.accessControlEnabled();
        if (bl) {
            if (string == null) {
                return false;
            }
            if (string.length() == 0 || string.equals(TimesTenConnectionCreator.getCurrentUserName())) {
                return false;
            }
            if (string2 == null) {
                return true;
            }
        }
        return false;
    }

    private static String getCurrentUserName() {
        String string = "";
        try {
            string = System.getProperty("user.name");
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }
}

