/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.ddlgen;

import java.util.ArrayList;
import oracle.dbtools.raptor.timesten.ddlgen.TimesTenBaseDDLGenerator;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;

public class TimesTenRelationalDDLGenerator
extends TimesTenBaseDDLGenerator {
    public TimesTenRelationalDDLGenerator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public Ddl getDeleteDDL(SchemaObject schemaObject, boolean bl) {
        return this.dropRelation((Relation)schemaObject, bl);
    }

    protected Ddl dropRelation(Relation relation, boolean bl) {
        StringBuffer stringBuffer;
        String string = this.getSchemaDotName((DBObject)relation);
        String string2 = relation.getType();
        ArrayList<String> arrayList = new ArrayList<String>();
        Constraint[] constraintArray = relation.getConstraints();
        for (int i = 0; i < constraintArray.length; ++i) {
            if (!(constraintArray[i] instanceof FKConstraint)) continue;
            stringBuffer = new StringBuffer();
            FKConstraint fKConstraint = (FKConstraint)constraintArray[i];
            stringBuffer.append("ALTER " + string2 + " " + string + " ");
            stringBuffer.append("DROP CONSTRAINT ");
            stringBuffer.append("\"" + fKConstraint.getName() + "\"");
            stringBuffer.append("\n");
            arrayList.add(stringBuffer.toString());
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("DROP").append(" ").append(string2).append(" ");
        stringBuffer2.append(string);
        if (bl) {
            stringBuffer2.append(" ").append("CASCADE").append(" ").append("CONSTRAINTS");
        }
        stringBuffer = new Ddl();
        stringBuffer.put("DROPCON", arrayList);
        stringBuffer.put("DROP", stringBuffer2.toString());
        return stringBuffer;
    }

    protected String getColumnList(Column[] columnArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("(").append("\n");
        for (int i = 0; i < columnArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",").append("\n");
            }
            if (bl) {
                stringBuffer.append("  ");
            }
            stringBuffer.append("  " + this.theDBObjectProvider.getExternalName(columnArray[i].getName()));
        }
        stringBuffer.append("\n");
        if (bl) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(")").append("\n");
        return stringBuffer.toString();
    }
}

