/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.ddlgen;

import oracle.dbtools.raptor.timesten.ddlgen.TimesTenBaseDDLGenerator;
import oracle.dbtools.raptor.timesten.ddlgen.TimesTenDDLConstants;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.diff.ResultSet;

public class TimesTenSequenceDDLGenerator
extends TimesTenBaseDDLGenerator
implements TimesTenDDLConstants {
    public TimesTenSequenceDDLGenerator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public Ddl getCreateDDL(SchemaObject schemaObject, boolean bl, boolean bl2) {
        return this.getCreateSequenceDDL((Sequence)schemaObject);
    }

    public Ddl getDeleteDDL(SchemaObject schemaObject, boolean bl) {
        return this.dropBasicObject(schemaObject);
    }

    public Ddl[] getUpdateDDL(SchemaObject schemaObject, SchemaObject schemaObject2) {
        return null;
    }

    public Ddl[] getUpdateDDL(ResultSet resultSet) {
        return null;
    }

    private Ddl getCreateSequenceDDL(Sequence sequence) {
        String string = this.getSchemaDotName((DBObject)sequence);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE").append(" ");
        stringBuffer.append("SEQUENCE").append(" ");
        stringBuffer.append(string).append(" ");
        if (null != sequence.getIncrementBy()) {
            stringBuffer.append("INCREMENT").append(" ").append("BY").append(" ");
            stringBuffer.append(sequence.getIncrementBy().toString()).append(" ");
        }
        if (null != sequence.getStartWith()) {
            stringBuffer.append("START").append(" ").append("WITH").append(" ");
            stringBuffer.append(sequence.getStartWith().toString()).append(" ");
        }
        if (null != sequence.getMaxValue()) {
            stringBuffer.append("MAXVALUE").append(" ");
            stringBuffer.append(sequence.getMaxValue().toString()).append(" ");
        }
        if (null != sequence.getMinValue()) {
            stringBuffer.append("MINVALUE").append(" ");
            stringBuffer.append(sequence.getMinValue().toString()).append(" ");
        }
        if (null != sequence.getCycleFlag() && sequence.getCycleFlag().equals(Boolean.TRUE)) {
            stringBuffer.append("CYCLE").append(" ");
        }
        if (sequence.getCacheFlag() != null && sequence.getCacheFlag().booleanValue() && sequence.getCacheSize() != null && sequence.getCacheSize().intValue() > 1) {
            stringBuffer.append("CACHE").append(" ").append(sequence.getCacheSize().toString()).append(" ");
        }
        if (null == sequence.getOrderFlag() || sequence.getOrderFlag().equals(Boolean.TRUE)) {
            // empty if block
        }
        Ddl ddl = new Ddl();
        ddl.put("SEQ", stringBuffer.toString());
        return ddl;
    }
}

