/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.ddlgen;

import java.util.ArrayList;
import oracle.dbtools.raptor.timesten.ddlgen.TimesTenRelationalDDLGenerator;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

public class TimesTenTableDDLGenerator
extends TimesTenRelationalDDLGenerator {
    public TimesTenTableDDLGenerator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public Ddl getCreateDDL(SchemaObject schemaObject, boolean bl, boolean bl2) {
        return this.createTable((Table)schemaObject);
    }

    public Ddl[] getUpdateDDL(SchemaObject schemaObject, SchemaObject schemaObject2) {
        return null;
    }

    public Ddl[] getUpdateDDL(ResultSet resultSet) {
        return null;
    }

    private Ddl createTable(Table table) {
        Ddl ddl = this.createRelationalObject((Relation)table);
        String string = this.getSchemaDotName((DBObject)table);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE");
        Object object = table.getProperty("TableType");
        if (Table.TableType.SESSION_TEMP == object || Table.TableType.TRANSACTION_TEMP == object) {
            stringBuffer.append(" ").append("GLOBAL").append(" ").append("TEMPORARY");
        }
        stringBuffer.append(" ").append("TABLE").append(" ").append(string).append("\n").append("(").append("\n").append(ddl.get("TAB")).append(this.createPrimaryKey(table)).append(")").append("\n");
        Ddl ddl2 = new Ddl();
        ddl2.put("TAB", stringBuffer.toString());
        return ddl2;
    }

    private String createPrimaryKey(Table table) {
        Constraint[] constraintArray = table.getConstraints();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < constraintArray.length; ++i) {
            if (!(constraintArray[i] instanceof PKConstraint)) continue;
            PKConstraint pKConstraint = (PKConstraint)constraintArray[i];
            stringBuffer.append(", ");
            stringBuffer.append("PRIMARY KEY\n").append(this.getColumnList(pKConstraint.getColumns(), true));
        }
        return stringBuffer.toString();
    }

    private Ddl createRelationalObject(Relation relation) {
        Constraint[] constraintArray;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        Column[] columnArray = relation.getColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",").append("\n");
            }
            constraintArray = this.createColumnDDL(columnArray[i]);
            stringBuffer.append(constraintArray.get("ACO"));
            if (!constraintArray.containsKey("CMC")) continue;
            arrayList.add(constraintArray.get("CMC"));
        }
        stringBuffer.append("\n");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        constraintArray = relation.getConstraints();
        for (int i = 0; i < constraintArray.length; ++i) {
            if (!"UniqueConstraint".equals(constraintArray[i].getConstraintType())) continue;
            arrayList2.add(this.createConstraint(constraintArray[i]));
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < constraintArray.length; ++i) {
            if (!(constraintArray[i] instanceof FKConstraint)) continue;
            arrayList3.add(this.createConstraint(constraintArray[i]));
        }
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (int i = 0; i < constraintArray.length; ++i) {
            if (!(constraintArray[i] instanceof CheckConstraint)) continue;
            arrayList4.add(this.createConstraint(constraintArray[i]));
        }
        Ddl ddl = new Ddl();
        ddl.put("TAB", stringBuffer.toString());
        ddl.put("CONUK", arrayList2);
        ddl.put("CONFK", arrayList3);
        ddl.put("CONCC", arrayList4);
        Table.TableType tableType = (Table.TableType)relation.getProperty("TableType");
        return ddl;
    }

    private Ddl createColumnDDL(Column column) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("  ");
        stringBuffer.append(this.theDBObjectProvider.getExternalName(column.getName()));
        stringBuffer.append(" ");
        DataType dataType = null;
        try {
            dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (dataType != null) {
            stringBuffer.append(dataType.getDDL(column.getDataTypeUsage()));
            if (null != column.getDefault()) {
                stringBuffer.append(" ");
                stringBuffer.append("DEFAULT");
                stringBuffer.append(" ");
                object = column.getDefault().toString();
                stringBuffer.append((String)object);
            }
        }
        if (column.isNotNull()) {
            stringBuffer.append(" ").append("NOT").append(" ").append("NULL");
        }
        object = new Ddl();
        object.put("ACO", stringBuffer.toString());
        return object;
    }

    protected void appendConstraintName(StringBuffer stringBuffer, String string) {
        if (ModelUtil.hasLength((String)string)) {
            boolean bl;
            boolean bl2 = bl = string.length() == 12 || string.length() == 11;
            if (!bl || !"SYS_C".equals(string.substring(0, 5))) {
                stringBuffer.append("CONSTRAINT").append(" ");
                stringBuffer.append(this.theDBObjectProvider.getExternalName(string)).append(" ");
            }
        }
    }

    private String createConstraint(Constraint constraint) {
        String string = this.getSchemaDotName((DBObject)constraint.getRelation());
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("ALTER").append(" ").append("TABLE").append(" ");
        stringBuffer2.append(string);
        stringBuffer2.append("\n");
        if (constraint instanceof PKConstraint) {
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(this.addUniqueConstraint((UniqueConstraint)constraint));
        } else if (constraint instanceof UniqueConstraint) {
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(this.addUniqueConstraint((UniqueConstraint)constraint));
        }
        stringBuffer.append(" ");
        if (constraint.isEnabled()) {
            stringBuffer.append("ENABLE");
        } else {
            stringBuffer.append("DISABLE");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String addUniqueConstraint(UniqueConstraint uniqueConstraint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ADD").append(" ");
        this.appendConstraintName(stringBuffer, uniqueConstraint.getName());
        if (uniqueConstraint instanceof PKConstraint) {
            stringBuffer.append("PRIMARY").append(" ").append("KEY");
        } else {
            stringBuffer.append("UNIQUE");
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.getColumnList(uniqueConstraint.getColumns(), false));
        return stringBuffer.toString();
    }
}

