/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.index;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.db.DBIcons;
import oracle.ide.db.UIArb;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;

public class IndexEditorPanel
extends JPanel
implements ActionListener,
ListDataListener,
DocumentListener,
ItemListener {
    private ArrayList m_whatsHappening = new ArrayList();
    private JLabel m_lblIndexName = new JLabel();
    JLabel m_lblIndexType = new JLabel(UIArb.getString((int)815));
    private JLabel m_lblColExprs = new JLabel();
    private JList m_lstColExprs = new JList();
    private JButton m_btnAddColExpr = new JButton();
    private JButton m_btnRemoveColExpr = new JButton();
    private JButton m_btnUpColExpr = new JButton();
    private JButton m_btnDownColExpr = new JButton();
    private DefaultListModel m_mdlColExprs = new DefaultListModel();
    private ListSelectionListener m_mdlColExprsListSelectionListener;
    private DefaultComboBoxModel m_mdlCmbColExpr = new DefaultComboBoxModel();
    private JTextField m_fldName;
    private JLabel m_lblColExpr = new JLabel();
    private JComboBox m_cmbColExpr = new JComboBox();
    private JComboBox m_cmbCol = new JComboBox();
    private JLabel m_lblAsc = new JLabel();
    private JComboBox m_cmbAsc = new JComboBox();
    private DBObjectProvider m_prov;
    private Table m_table;
    private Index m_oldIndex;
    private Index m_index;
    private boolean m_isNewIndex;
    private IndexInfoVerifier m_verifier;
    private JRadioButton m_rdbNonUnique = new JRadioButton();
    private JRadioButton m_rdbUnique = new JRadioButton();
    private JPanel m_pnlNormal;
    private GridBagConstraints m_gbcNormalDomain;
    WizardCallbacks m_callbacks;
    private Table m_originalTable;
    private static String WH_ADD_A_COLUMN_EXPRESSION = "Add a column expression";
    private static String WH_REMOVE_A_COLUMN_EXPRESSION = "Remove a column expression";
    private static String WH_MOVE_A_COLUMN_EXPRESSION_UP = "Move a column expression up";
    private static String WH_MOVE_A_COLUMN_EXPRESSION_DOWN = "Move a column expression down";
    private static String WH_EDIT_COLUMN_EXPRESSION = "Edit column Expression";
    private static String WH_CHANGE_COLEXPR_SELECTION = "Change column expression selection";
    private static String WH_SET_ASC_DESC = "Set the column expression order";
    private static final String[] INDEXTYPES = new String[]{"INDEXTYPE"};
    private static final int NOPARALLEL = 1;
    private static final int PARALLEL_DEFAULT = 0;

    public IndexEditorPanel() {
        this(true);
    }

    public IndexEditorPanel(boolean bl) {
        ButtonGroup buttonGroup = new ButtonGroup();
        ResourceUtils.resButton((AbstractButton)this.m_rdbNonUnique, (String)UIArb.getString((int)607));
        ResourceUtils.resButton((AbstractButton)this.m_rdbUnique, (String)UIArb.getString((int)733));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_rdbNonUnique);
        buttonGroup2.add(this.m_rdbUnique);
        this.m_rdbNonUnique.setSelected(true);
        this.m_rdbNonUnique.addActionListener(this);
        this.m_rdbUnique.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_lblColExprs, (Component)this.m_lstColExprs, (String)UIArb.getString((int)83));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.m_lstColExprs.setModel(this.m_mdlColExprs);
        this.m_lstColExprs.setSelectionMode(0);
        Insets insets = new Insets(2, 2, 2, 2);
        this.m_btnUpColExpr.setMargin(insets);
        this.m_btnUpColExpr.setIcon(ComponentArb.getIcon((int)3));
        this.m_btnUpColExpr.setDisabledIcon(ComponentArb.getIcon((int)23));
        DBObjectRenderer.setToolTipText((JComponent)this.m_btnUpColExpr, (String)UIArb.getString((int)756));
        this.m_btnUpColExpr.addActionListener(this);
        this.m_btnDownColExpr.setMargin(insets);
        this.m_btnDownColExpr.setIcon(ComponentArb.getIcon((int)9));
        this.m_btnDownColExpr.setDisabledIcon(ComponentArb.getIcon((int)0));
        DBObjectRenderer.setToolTipText((JComponent)this.m_btnDownColExpr, (String)UIArb.getString((int)462));
        this.m_btnDownColExpr.addActionListener(this);
        this.m_btnAddColExpr.setMargin(insets);
        this.m_btnAddColExpr.setIcon(DBIcons.getIcon((int)36));
        DBObjectRenderer.setToolTipText((JComponent)this.m_btnAddColExpr, (String)UIArb.getString((int)521));
        this.m_btnAddColExpr.addActionListener(this);
        this.m_btnRemoveColExpr.setMargin(insets);
        this.m_btnRemoveColExpr.setIcon(DBIcons.getIcon((int)23));
        DBObjectRenderer.setToolTipText((JComponent)this.m_btnRemoveColExpr, (String)UIArb.getString((int)370));
        this.m_btnRemoveColExpr.addActionListener(this);
        if (bl) {
            this.m_fldName = new JTextField();
            ResourceUtils.resLabel((JLabel)this.m_lblIndexName, (Component)this.m_fldName, (String)UIArb.getString((int)364));
            this.m_fldName.setColumns(30);
        }
        ResourceUtils.resLabel((JLabel)this.m_lblColExpr, (Component)this.m_cmbColExpr, (String)UIArb.getString((int)103));
        this.m_cmbColExpr.addItemListener(this);
        this.m_cmbColExpr.setModel(this.m_mdlCmbColExpr);
        this.m_cmbColExpr.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.m_lblAsc, (Component)this.m_cmbAsc, (String)UIArb.getString((int)181));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.m_btnAddColExpr, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnRemoveColExpr, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnUpColExpr, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnDownColExpr, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jScrollPane.getViewport().add((Component)this.m_lstColExprs, null);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.m_lblColExprs, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel2.add(Box.createHorizontalStrut(150), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this.m_lblColExpr, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel3.add((Component)this.m_cmbColExpr, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.m_lblAsc, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 0), 0, 0));
        jPanel3.add((Component)this.m_cmbAsc, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.m_pnlNormal = new JPanel(new GridBagLayout());
        this.m_pnlNormal.add((Component)this.m_rdbNonUnique, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 15), 0, 0));
        this.m_pnlNormal.add((Component)this.m_rdbUnique, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 15), 0, 0));
        this.m_pnlNormal.add((Component)jPanel2, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.m_pnlNormal.add((Component)jPanel3, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 15, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        if (bl) {
            this.add((Component)this.m_lblIndexName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
            this.add((Component)this.m_fldName, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        }
        this.add((Component)this.m_lblIndexType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.m_gbcNormalDomain = new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
        this.add((Component)this.m_pnlNormal, this.m_gbcNormalDomain);
    }

    protected void init(DBObjectProvider dBObjectProvider, Table table, IndexInfoVerifier indexInfoVerifier, WizardCallbacks wizardCallbacks, Table table2, boolean bl) {
        this.m_prov = dBObjectProvider;
        this.m_table = table;
        this.m_verifier = indexInfoVerifier;
        this.m_callbacks = wizardCallbacks;
        this.m_originalTable = table2;
        this.m_lstColExprs.getSelectionModel().removeListSelectionListener(this.m_mdlColExprsListSelectionListener);
        this.m_mdlColExprs.removeListDataListener(this);
        this.m_mdlColExprs.removeAllElements();
        this.m_index = null;
        this.m_mdlCmbColExpr.removeAllElements();
        this.m_mdlColExprsListSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                IndexEditorPanel.this.logActionStart(WH_CHANGE_COLEXPR_SELECTION, true);
                IndexEditorPanel.this.updateSelColExpr(IndexEditorPanel.this.m_lstColExprs.getSelectedValue());
                IndexEditorPanel.this.logActionEnd(WH_CHANGE_COLEXPR_SELECTION);
            }
        };
        this.m_mdlColExprs.addListDataListener(this);
        this.m_cmbAsc.addActionListener(this);
        this.m_cmbAsc.setEditable(false);
        if (0 == this.m_cmbAsc.getItemCount()) {
            this.m_cmbAsc.addItem(null);
            this.m_cmbAsc.addItem("ASC");
            this.m_cmbAsc.addItem("DESC");
        }
        this.m_lstColExprs.getSelectionModel().addListSelectionListener(this.m_mdlColExprsListSelectionListener);
        this.updateTableColumns(table);
        this.updateIndexData(null);
        this.updateColExpr(null);
        this.updateButtons();
        this.updateListContents(this.m_mdlColExprs);
        this.setFieldEnable(indexInfoVerifier, null, bl);
    }

    public void setFieldEnable(IndexInfoVerifier indexInfoVerifier, Index index, boolean bl) {
        if (null != indexInfoVerifier) {
            boolean bl2;
            boolean bl3 = bl2 = this.m_mdlColExprs.size() > 0;
            if (null != this.m_fldName) {
                this.m_lblIndexName.setEnabled(bl && indexInfoVerifier.canRenameIndex(index));
                this.m_fldName.setEnabled(bl && indexInfoVerifier.canRenameIndex(index));
            }
            this.m_rdbNonUnique.setEnabled(bl && indexInfoVerifier.canEditUniqueness(index));
            this.m_rdbUnique.setEnabled(bl && indexInfoVerifier.canEditUniqueness(index));
            this.m_lblColExprs.setEnabled(bl && indexInfoVerifier.canEditIndex(index));
            this.m_btnAddColExpr.setEnabled(bl && indexInfoVerifier.canEditIndex(index));
            this.m_btnDownColExpr.setEnabled(bl && bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_btnRemoveColExpr.setEnabled(bl && bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_btnUpColExpr.setEnabled(bl && bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_lblColExpr.setEnabled(bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_cmbColExpr.setEditable(bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_cmbColExpr.setEnabled(bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_lblAsc.setEnabled(bl && indexInfoVerifier.canEditIndex(index));
            this.m_cmbAsc.setEnabled(bl && indexInfoVerifier.canEditIndex(index));
        }
    }

    private void updateTableColumns(Table table) {
        this.m_cmbColExpr.removeItemListener(this);
        this.m_mdlCmbColExpr.removeAllElements();
        if (table != null) {
            for (Column column : table.getColumns()) {
                String string = column.getName();
                if (column instanceof ViewColumn && string.contains(".")) {
                    string = string.substring(string.indexOf(".") + 1);
                }
                this.m_mdlCmbColExpr.addElement(string);
            }
        }
        this.m_cmbColExpr.addItemListener(this);
    }

    public JTextField getNameField() {
        return this.m_fldName;
    }

    public void commit() throws TraversalException {
        if (null != this.m_index) {
            TraversalException traversalException = this.saveIndexAttributes();
            if (traversalException != null) {
                throw traversalException;
            }
            if (null != this.m_fldName) {
                this.m_index.setName(this.m_prov.getInternalName(this.m_fldName.getText()));
            }
            if (this.m_index.getIndexType() != Index.IndexType.DOMAIN) {
                this.m_index.setDomainIndextype(null);
                this.m_index.setDomainIndextypeOpStatus(null);
                this.m_index.setDomainIndextypeParameters(null);
            }
            if (this.m_verifier != null) {
                this.m_verifier.verifyIndex(this.m_oldIndex, this.m_index);
            }
        }
    }

    private TraversalException saveIndexAttributes() {
        if (null != this.m_index) {
            IndexObject[] indexObjectArray = null;
            this.m_index.setIndexType(Index.IndexType.NORMAL);
            if (this.m_rdbUnique.isSelected()) {
                this.m_index.setIndexType(Index.IndexType.UNIQUE);
            }
            indexObjectArray = new IndexObject[this.m_mdlColExprs.size()];
            for (int i = 0; i < this.m_mdlColExprs.size(); ++i) {
                indexObjectArray[i] = (IndexObject)this.m_mdlColExprs.getElementAt(i);
            }
            this.m_index.setColumnExpressions(indexObjectArray);
        }
        return null;
    }

    public void setIndex(Index index) {
        this.m_index = index;
        if (null != index) {
            this.populateName(index);
            this.populateIndexType(index);
        }
    }

    public void setTable(Table table) {
        if (table != this.m_table) {
            this.m_table = table;
            this.updateTableColumns(table);
        }
    }

    public Index getIndex() {
        return this.m_index;
    }

    public void updateIndexData(Index index) {
        this.m_index = index;
        if (index == null) {
            if (null != this.m_fldName) {
                this.m_fldName.setText("");
                this.m_fldName.setEnabled(false);
            }
            this.m_oldIndex = null;
        } else {
            this.m_oldIndex = this.m_isNewIndex ? null : (Index)index.copyTo(null);
            this.populateName(index);
        }
        this.populateIndexType(this.m_index);
        this.populateUniqueness(this.m_index);
        this.populateColumnExpressions(this.m_index);
        if (null != this.m_fldName) {
            this.m_fldName.requestFocusInWindow();
        }
    }

    public void setNewIndex(boolean bl) {
        this.m_isNewIndex = bl;
        this.m_verifier.setEditable(this.m_isNewIndex);
    }

    private void switchToNormalIndex() {
        this.add((Component)this.m_pnlNormal, this.m_gbcNormalDomain);
        this.validate();
        this.repaint();
    }

    private void switchIndexType() {
    }

    private void switchUnique() {
        this.m_cmbAsc.setEnabled(this.m_verifier.canEditIndex(null));
    }

    private void updateColExpr(IndexObject indexObject) {
        if (indexObject == null) {
            this.m_cmbColExpr.setSelectedItem("");
            this.m_lblColExpr.setEnabled(false);
            this.m_cmbColExpr.setEnabled(false);
            this.m_cmbAsc.setSelectedItem(null);
            this.m_lblAsc.setEnabled(false);
            this.m_cmbAsc.setEnabled(false);
        } else {
            this.m_cmbColExpr.setSelectedItem(indexObject.getExpression().getSQLText());
            this.m_cmbAsc.setSelectedItem(indexObject.getOrder());
            boolean bl = null == this.m_verifier || this.m_verifier.canEditIndex(null);
            this.m_lblColExpr.setEnabled(bl);
            this.m_cmbColExpr.setEnabled(bl);
            boolean bl2 = null == this.m_verifier || this.m_verifier.canEditIndex(null);
            this.m_lblAsc.setEnabled(bl2);
            this.m_cmbAsc.setEnabled(bl2);
        }
    }

    private void updateSelColExpr(Object object) {
        if (null != object) {
            this.m_lstColExprs.setSelectedValue(object, true);
            this.updateColExpr((IndexObject)object);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this.m_lstColExprs.getSelectedIndex();
        IndexObject indexObject = n != -1 ? (IndexObject)this.m_mdlColExprs.get(n) : null;
        SQLFragment sQLFragment = null == indexObject ? null : indexObject.getExpression();
        String string2 = string = null == sQLFragment ? null : sQLFragment.getSQLText();
        if (string != null) {
            bl = true;
            IndexObject indexObject2 = n > 0 ? (IndexObject)this.m_mdlColExprs.get(n - 1) : null;
            IndexObject indexObject3 = n < this.m_mdlColExprs.getSize() - 1 ? (IndexObject)this.m_mdlColExprs.get(n + 1) : null;
            bl2 = indexObject2 != null;
            bl3 = indexObject3 != null;
        }
        this.m_btnRemoveColExpr.setEnabled(null != this.m_index && null != this.m_verifier && bl && this.m_verifier.canEditIndex(this.m_index));
        this.m_btnAddColExpr.setEnabled(null != this.m_index && null != this.m_verifier && this.m_verifier.canEditIndex(this.m_index) && this.m_verifier.canAddIndexEntry(this.m_index));
        this.m_btnUpColExpr.setEnabled(null != this.m_index && null != this.m_verifier && bl2 && this.m_verifier.canEditIndex(this.m_index));
        this.m_btnDownColExpr.setEnabled(null != this.m_index && null != this.m_verifier && bl3 && this.m_verifier.canEditIndex(this.m_index));
    }

    public void populateName(Index index) {
        if (null != this.m_fldName) {
            if (null != index) {
                this.m_fldName.setText(this.m_prov.getExternalName(index.getName()));
            }
            boolean bl = this.m_isNewIndex || this.m_verifier == null || this.m_verifier.canRenameIndex(index);
            this.m_fldName.setEnabled(bl);
            this.m_fldName.setEditable(bl);
        }
    }

    public void populateIndexType(Index index) {
        this.switchIndexType();
    }

    public void populateUniqueness(Index index) {
        if (null == index) {
            this.m_rdbNonUnique.setSelected(true);
            this.m_rdbNonUnique.setEnabled(false);
            this.m_rdbUnique.setEnabled(false);
        } else {
            this.m_rdbNonUnique.setSelected(Index.IndexType.NORMAL == index.getIndexType());
            this.m_rdbUnique.setSelected(Index.IndexType.UNIQUE == index.getIndexType());
            this.m_rdbNonUnique.setEnabled(this.m_verifier != null && this.m_verifier.canEditUniqueness(null));
            this.m_rdbUnique.setEnabled(this.m_verifier != null && this.m_verifier.canEditUniqueness(null));
        }
    }

    public void populateColumnExpressions(Index index) {
        this.m_cmbColExpr.setSelectedItem(null);
        this.m_cmbAsc.setSelectedIndex(0);
        this.m_mdlColExprs.removeAllElements();
        if (null != index) {
            IndexObject[] indexObjectArray = index.getColumnExpressions();
            for (int i = 0; i < indexObjectArray.length; ++i) {
                this.m_mdlColExprs.addElement(indexObjectArray[i]);
            }
            if (null != indexObjectArray && indexObjectArray.length > 0) {
                this.m_lstColExprs.setSelectedIndex(0);
                this.updateColExpr(indexObjectArray[0]);
            }
        }
    }

    private void updateListContents(Object object) {
        boolean bl = false;
        if (this.m_mdlColExprs == object) {
            bl = this.m_mdlColExprs.getSize() > 0;
            this.m_lstColExprs.setFocusable(bl);
            boolean bl2 = bl && (null == this.m_verifier || this.m_verifier.canEditIndex(null));
            this.m_lblColExpr.setEnabled(bl2);
            this.m_cmbColExpr.setEditable(bl2);
            this.m_cmbColExpr.setEnabled(bl2);
        }
        if (this.m_callbacks != null) {
            Boolean bl3 = null == this.m_index || bl;
            this.m_callbacks.wizardEnableButtons(Boolean.TRUE, bl3, bl3);
        }
    }

    private void swap(int n, int n2) {
        Object e = this.m_mdlColExprs.getElementAt(n);
        Object e2 = this.m_mdlColExprs.getElementAt(n2);
        this.m_mdlColExprs.setElementAt(e, n2);
        this.m_mdlColExprs.setElementAt(e2, n);
    }

    private void updateIndexName() {
        this.logActionStart(WH_EDIT_COLUMN_EXPRESSION, true);
        String string = (String)this.m_cmbColExpr.getSelectedItem();
        String string2 = (String)this.m_cmbAsc.getSelectedItem();
        int n = this.m_lstColExprs.getSelectedIndex();
        if (n >= 0) {
            SQLFragment sQLFragment = OracleIndexBuilder.createExpression((String)string, (Relation)this.m_table, (DBObjectProvider)this.m_prov);
            IndexObject indexObject = new IndexObject(sQLFragment, string2);
            this.m_mdlColExprs.setElementAt(indexObject, n);
        }
        this.m_lstColExprs.repaint();
        this.logActionEnd(WH_EDIT_COLUMN_EXPRESSION);
    }

    public void logActionStart(String string, boolean bl) {
        if (!bl && 0 != this.m_whatsHappening.size()) {
            Assert.check((boolean)false, (String)("Trying to " + string + " whilst doing " + this.m_whatsHappening.get(0)));
        }
        this.m_whatsHappening.add(0, string);
    }

    public void logActionEnd(String string) {
        if (0 == this.m_whatsHappening.size()) {
            Assert.check((boolean)false, (String)("Lost track of " + string + ", appear to be doing nothing"));
        }
        Assert.check((boolean)string.equals(this.m_whatsHappening.get(0)), (String)("Lost track of " + string + ", appear to be " + this.m_whatsHappening.get(0)));
        this.m_whatsHappening.remove(0);
    }

    public int logSize() {
        return this.m_whatsHappening.size();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_rdbNonUnique || object == this.m_rdbUnique) {
            this.switchUnique();
            this.saveIndexAttributes();
            this.updateButtons();
        } else if (object == this.m_cmbAsc) {
            this.logActionStart(WH_SET_ASC_DESC, true);
            if (this.logSize() == 1) {
                this.m_cmbColExpr.requestFocusInWindow();
            }
            this.updateIndexName();
            this.logActionEnd(WH_SET_ASC_DESC);
        } else if (object == this.m_btnAddColExpr) {
            this.logActionStart(WH_ADD_A_COLUMN_EXPRESSION, false);
            this.m_lstColExprs.clearSelection();
            if (this.m_lstColExprs.getSelectedValue() == null) {
                Constraint[] constraintArray;
                Object object2 = "";
                Column[] columnArray = this.m_table.getColumns();
                if (columnArray.length > 0) {
                    object2 = columnArray[0].getName();
                    constraintArray = this.m_table.getConstraints();
                    for (int i = 0; i < constraintArray.length; ++i) {
                        if ("PKConstraint".equals(constraintArray[i].getConstraintType())) {
                            object2 = ((PKConstraint)constraintArray[i]).getColumns()[0].getName();
                            break;
                        }
                        if (!"UniqueConstraint".equals(constraintArray[i].getConstraintType())) continue;
                        object2 = ((UniqueConstraint)constraintArray[i]).getColumns()[0].getName();
                    }
                }
                constraintArray = object2;
                SQLFragment sQLFragment = OracleIndexBuilder.createExpression((String)constraintArray, (Relation)this.m_table, (DBObjectProvider)this.m_prov);
                IndexObject indexObject = new IndexObject(sQLFragment);
                this.m_mdlColExprs.addElement(indexObject);
                this.m_lstColExprs.setSelectedIndex(this.m_mdlColExprs.size() - 1);
                this.m_cmbColExpr.requestFocusInWindow();
            }
            this.saveIndexAttributes();
            this.updateButtons();
            this.logActionEnd(WH_ADD_A_COLUMN_EXPRESSION);
        } else if (object == this.m_btnRemoveColExpr) {
            this.logActionStart(WH_REMOVE_A_COLUMN_EXPRESSION, false);
            int n = this.m_lstColExprs.getSelectedIndex();
            if (n != -1) {
                int n2 = n == this.m_mdlColExprs.size() - 1 ? n - 1 : n + 1;
                this.m_lstColExprs.setSelectedIndex(n2);
                this.m_mdlColExprs.removeElementAt(n);
                if (n2 == -1) {
                    this.updateSelColExpr(null);
                    this.updateColExpr(null);
                }
            }
            this.saveIndexAttributes();
            this.updateButtons();
            this.logActionEnd(WH_REMOVE_A_COLUMN_EXPRESSION);
        } else if (object == this.m_btnUpColExpr) {
            this.logActionStart(WH_MOVE_A_COLUMN_EXPRESSION_UP, false);
            int n = this.m_lstColExprs.getSelectedIndex();
            if (n > 0) {
                this.swap(n--, n);
                this.m_lstColExprs.setSelectedIndex(n);
            }
            this.logActionEnd(WH_MOVE_A_COLUMN_EXPRESSION_UP);
        } else if (object == this.m_btnDownColExpr) {
            this.logActionStart(WH_MOVE_A_COLUMN_EXPRESSION_DOWN, false);
            int n = this.m_lstColExprs.getSelectedIndex();
            if (n < this.m_mdlColExprs.getSize() - 1) {
                this.swap(n++, n);
                this.m_lstColExprs.setSelectedIndex(n);
            }
            this.logActionEnd(WH_MOVE_A_COLUMN_EXPRESSION_DOWN);
        } else if (object == this.m_mdlColExprs) {
            this.saveIndexAttributes();
            this.updateButtons();
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateIndexName();
    }

    private static class NumberField
    extends NumberTextField {
        public NumberField() {
            this.setDataType(Integer.class);
            this.setSigned(false);
        }

        protected String convertNumberToString(Number number) {
            return number.toString();
        }

        protected boolean validateNumber(Number number) {
            return number == null || number.intValue() > 0;
        }
    }
}

