/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.sqldialog.ActionSql;
import oracle.dbtools.raptor.controls.sqldialog.SQLDialogHelpProvider;
import oracle.dbtools.raptor.timesten.dialogs.sql.ActionSqlPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.AlterTablePanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.UIUtils;

public class AlterTableDialog {
    private DBObject theDBObject;
    private static final String TITLE = "Add Column";

    public AlterTableDialog(DBObject dBObject) {
        this.theDBObject = dBObject;
    }

    public void showDialog() throws Exception {
        final AlterTablePanel alterTablePanel = new AlterTablePanel(this.theDBObject);
        final ActionSqlPanel actionSqlPanel = new ActionSqlPanel(alterTablePanel);
        JPanel[] jPanelArray = new JPanel[]{alterTablePanel, actionSqlPanel};
        String[] stringArray = new String[]{"Prompts", "SQL"};
        UIUtils.showPanelAsTabbedDialog((JPanel[])jPanelArray, (String[])stringArray, (String)TITLE, (ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = AlterTableDialog.this.theDBObject.getConnectionName();
                AlterTableDialog.this.processDialog(actionEvent, alterTablePanel, actionSqlPanel, string, AlterTableDialog.this.theDBObject);
            }
        }, (HelpProvider)new SQLDialogHelpProvider("Add a column to the selected table."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDialog(ActionEvent actionEvent, AlterTablePanel alterTablePanel, ActionSqlPanel actionSqlPanel, String string, DBObject dBObject) {
        if (alterTablePanel.validateValues()) {
            DBUtil.getInstance().setRaiseError(true);
            PreparedStatement preparedStatement = DBUtil.getInstance().prepareExecute(string, actionSqlPanel.getSQL().trim(), actionSqlPanel.getBinds());
            if (preparedStatement == null) {
                return;
            }
            try {
                boolean bl = preparedStatement.execute();
                Log.log((String)actionSqlPanel.getSQL());
                ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
                this.processConfirm(actionSqlPanel, string);
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Exception)exception);
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                    preparedStatement = null;
                }
            }
        }
    }

    public void processConfirm(ActionSqlPanel actionSqlPanel, String string) {
        PropertyPanel propertyPanel = new PropertyPanel();
        propertyPanel.removeAll();
        ActionSql actionSql = new ActionSql();
        String string2 = "Confirm";
        string2 = actionSql.manualSubs(string2, actionSqlPanel.getDictionary());
        String string3 = "Column #0# has been added to table \"#OBJECT_NAME#\"";
        String string4 = actionSql.manualSubs(string3, actionSqlPanel.getDictionary());
        string4 = actionSql.processPrompts(string4, actionSqlPanel.getPromptPanel().getTextValues(), null);
        propertyPanel.addSingleComp(string4);
        UIUtils.showPanelAsDialog((JPanel)propertyPanel, (String)string2, null, (int)1);
    }
}

