/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.dbtools.raptor.timesten.OracleTypeModeImpl;
import oracle.dbtools.raptor.timesten.dialogs.sql.ISqlPromptPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.SimpleCreateTablePanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.dialogs.MessageDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlterTablePanel
extends JPanel
implements ISqlPromptPanel {
    private static final String CHECKBOX_VALUE = "CHECKBOX_VALUE";
    private Map<String, Object> _dict = new HashMap<String, Object>();
    private List<JComponent> _textValues = new ArrayList<JComponent>();
    private DataType[] _supportedDataTypes;
    private JTextField _columnNameField;
    private JComboBox _dataTypeComboBox;
    private JTextField _precisionField;
    private JTextField _scaleField;
    private JComboBox _unitComboBox;
    private JTextField _dataTypeAttributeField;
    private String _conn;
    private int row = 0;
    private Database _database;
    private DBObject _dbObject;
    private static Table _table = new Table();
    private DataType _currentDataType;
    private String _currentAlterSql;
    private static final String[] alterSql = new String[]{"alter table \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\" add(#0# #1#)", "alter table \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\" add(#0# #1#(#2#) )", "alter table \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\" add(#0# #1#(#2#,#3#) )", "alter table \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\" add(#0# #1#(#2# #4#) )"};
    private FocusListener _focusListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!(focusEvent.getSource() instanceof JComboBox)) {
                AlterTablePanel.this.processReloadablePrompts((JComponent)focusEvent.getSource());
            }
        }
    };
    private ItemListener _comboListener = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                AlterTablePanel.this._currentDataType = (DataType)AlterTablePanel.this._dataTypeComboBox.getSelectedItem();
                if (AlterTablePanel.this._currentDataType.hasDataTypeAttribute("precision") || AlterTablePanel.this._currentDataType.hasDataTypeAttribute("size")) {
                    AlterTablePanel.this._precisionField.setEnabled(true);
                    AlterTablePanel.this._precisionField.setEditable(true);
                } else {
                    AlterTablePanel.this._precisionField.setText("");
                    AlterTablePanel.this._precisionField.setEditable(false);
                    AlterTablePanel.this._precisionField.setEnabled(false);
                    AlterTablePanel.this._precisionField.setEditable(false);
                }
                if (AlterTablePanel.this._currentDataType.hasDataTypeAttribute("scale")) {
                    AlterTablePanel.this._scaleField.setEnabled(true);
                    AlterTablePanel.this._scaleField.setEditable(true);
                } else {
                    AlterTablePanel.this._scaleField.setText("");
                    AlterTablePanel.this._scaleField.setEditable(false);
                    AlterTablePanel.this._scaleField.setEnabled(false);
                    AlterTablePanel.this._scaleField.setEditable(false);
                }
                if (AlterTablePanel.this._currentDataType.hasDataTypeAttribute("unit")) {
                    AlterTablePanel.this._unitComboBox.setEnabled(true);
                } else {
                    AlterTablePanel.this._unitComboBox.setEnabled(false);
                }
            }
        }
    };

    public AlterTablePanel(DBObject dBObject) {
        this._dbObject = dBObject;
        this._dict = dBObject.getDictionary();
        this._conn = dBObject.getConnectionName();
        this._database = dBObject.getDatabase();
        this._supportedDataTypes = this._database.listSupportedDataTypes();
        ArrayList<DataType> arrayList = new ArrayList<DataType>(this._supportedDataTypes.length);
        for (DataType dataType : this._supportedDataTypes) {
            arrayList.add(dataType);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                DataType dataType = (DataType)object;
                DataType dataType2 = (DataType)object2;
                return dataType.getName().compareTo(dataType2.getName());
            }

            public boolean equals(Object object) {
                return super.equals(object);
            }
        });
        this._supportedDataTypes = arrayList.toArray(this._supportedDataTypes);
        this.setLayout(new GridBagLayout());
        this.init();
    }

    @Override
    public List<String> getValues() {
        String string;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this._columnNameField.getText();
        if (string2 != null) {
            arrayList.add(string2);
        }
        if ((object = this._dataTypeComboBox.getSelectedItem()) != null) {
            arrayList.add(object.toString());
        }
        if ((string = this._dataTypeAttributeField.getText()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public void evalDefaults() {
        if (this._database instanceof OracleTypeModeImpl) {
            this._dataTypeComboBox.setSelectedItem(this._database.getDataType("VARCHAR2"));
            this._dataTypeAttributeField.setText("4000");
        } else {
            this._dataTypeComboBox.setSelectedItem(this._database.getDataType("CHAR"));
            this._dataTypeAttributeField.setText("32");
        }
    }

    public void init() {
        String[] stringArray;
        String string = null;
        if (this._dict.get("OBJECT_OWNER") != null && this._dict.get("OBJECT_NAME") != null) {
            stringArray = this._dict.get("OBJECT_OWNER").toString();
            String string2 = this._dict.get("OBJECT_NAME").toString();
            this.addRow(new JLabel("Owner"), new JLabel((String)stringArray));
            this.addRow(new JLabel("Name"), new JLabel(string2));
            SchemaObject schemaObject = this._dbObject.getSchemaObject();
            if (schemaObject instanceof Table) {
                Table table = (Table)schemaObject;
                DefaultListModel<Column> defaultListModel = new DefaultListModel<Column>();
                for (Column column : table.getColumns()) {
                    defaultListModel.addElement(column);
                }
                string = SimpleCreateTablePanel.getUniqueNameEnh("COLUMN", defaultListModel);
            }
        }
        this._columnNameField = new JTextField(25);
        this.addRow(new JLabel("Column Name"), this._columnNameField);
        if (string != null) {
            this._columnNameField.setText(string);
        }
        this._textValues.add(this._columnNameField);
        stringArray = new String[this._supportedDataTypes.length];
        int n = 0;
        for (Column[] columnArray : this._supportedDataTypes) {
            stringArray[n++] = columnArray.getName();
        }
        this._dataTypeComboBox = new JComboBox<DataType>(this._supportedDataTypes);
        this.addRow(new JLabel("Data Type"), this._dataTypeComboBox);
        this._textValues.add(this._dataTypeComboBox);
        this._dataTypeComboBox.addItemListener(this._comboListener);
        this._precisionField = new JTextField(25);
        this.addRow(new JLabel("Precision/Size"), this._precisionField);
        this._textValues.add(this._precisionField);
        this._scaleField = new JTextField(25);
        this.addRow(new JLabel("Scale"), this._scaleField);
        this._textValues.add(this._scaleField);
        this._unitComboBox = new JComboBox<String>(new String[]{" ", "BYTE", "CHAR"});
        this._unitComboBox.setSelectedIndex(0);
        this.addRow(new JLabel("Unit"), this._unitComboBox);
        this._textValues.add(this._unitComboBox);
        this._dataTypeAttributeField = new JTextField(25);
        this.evalDefaults();
        this.add(Box.createGlue(), new GridBagConstraints(0, this.row, 1, 1, 0.0, 10.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    private void addRow(Component component, Component component2) {
        this.add(component, new GridBagConstraints(0, this.row, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(component2, new GridBagConstraints(1, this.row, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
        ++this.row;
    }

    public void processReloadablePrompts(JComponent jComponent) {
    }

    public void update() {
    }

    @Override
    public List<JComponent> getTextValues() {
        return this._textValues;
    }

    @Override
    public Map<String, Object> getDictionary() {
        return this._dict;
    }

    public void setDictionary(Map<String, Object> map) {
        this._dict = map;
    }

    @Override
    public String getSql() {
        if (this._currentDataType.hasDataTypeAttribute("unit")) {
            if (this._precisionField.getText().trim().length() > 0) {
                return alterSql[3];
            }
            return alterSql[0];
        }
        if (this._precisionField.getText().trim().length() > 0) {
            if (this._scaleField.getText().trim().length() > 0) {
                return alterSql[2];
            }
            return alterSql[1];
        }
        return alterSql[0];
    }

    public boolean validateValues() {
        String string;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this._columnNameField.getText().trim().equals("")) {
            stringBuffer.append("Column name cannot be empty.");
            bl = false;
        }
        DataType dataType = (DataType)this._dataTypeComboBox.getSelectedItem();
        DataTypeUsage dataTypeUsage = dataType.createDefaultUsage();
        DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute("size");
        if (dataTypeAttribute != null) {
            string = this._precisionField.getText().trim();
            if (string.length() == 0) {
                if (dataTypeAttribute.isMandatory()) {
                    stringBuffer.append("Size cannot be empty");
                    bl = false;
                }
            } else {
                dataTypeUsage.putAttributeValue("size", (Object)DataTypeHelper.toLong((Object)string));
            }
        }
        if ((dataTypeAttribute = dataType.getDataTypeAttribute("precision")) != null) {
            string = this._precisionField.getText().trim();
            if (string.length() == 0) {
                if (dataTypeAttribute.isMandatory()) {
                    stringBuffer.append("Precision cannot be empty");
                    bl = false;
                }
            } else {
                dataTypeUsage.putAttributeValue("precision", (Object)DataTypeHelper.toLong((Object)string));
            }
        }
        if (dataType.hasDataTypeAttribute("scale") && (string = this._scaleField.getText().trim()).length() > 0) {
            dataTypeUsage.putAttributeValue("scale", (Object)DataTypeHelper.toLong((Object)string));
        }
        if (dataType.hasDataTypeAttribute("unit") && this._unitComboBox.getSelectedIndex() > 0) {
            dataTypeUsage.putAttributeValue("unit", (Object)this._unitComboBox.getSelectedItem().toString());
        }
        try {
            dataType.validateUsage(dataTypeUsage, (oracle.javatools.db.DBObject)_table);
        }
        catch (DataTypeValidationException dataTypeValidationException) {
            stringBuffer.append("Data type definition " + dataTypeValidationException.toString());
            bl = false;
        }
        if (!bl) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)"Error", null);
        }
        return bl;
    }
}

